﻿// <summary>ソースコード：XMLファイルクラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;
using System.Xml;

using CommonMP.HYSSOP.Interface.HSTools;
using CommonMP.HYSSOP.CoreImpl.HSData;

namespace CommonMP.HYSSOP.CoreImpl.HSTools
{
    /// <summary><para>class outline:</para>
    /// <para>XMLファイル読込クラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2008/10/01][新規作成]</para>
    /// </remarks>
    public class HySXmlReader : HySXmlNode //, HySIOStream
    {
        /// <summary> フルパスＸＭＬファイル名 </summary>
        protected string m_sFileNameWithPath;
        /// <summary> ＸＭＬドキュメント </summary>
        protected XmlDocument m_csXmlDocument = new XmlDocument();

        /// <summary><para>method outline:</para>
        /// <para>コンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySXmlReader csXMLReader = HySXmlReader( csXmlFileNameWithPath ) </para>
        /// </example>
        /// <param name="csXmlFileNameWithPath">XMLファイル名称(フルパス)</param>
        /// <returns>生成されたインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySXmlReader(HySString csXmlFileNameWithPath)
            :base(null)
        {
            m_sFileNameWithPath = csXmlFileNameWithPath.ToString();
            this.LoadXML();
            m_csXmlNode = m_csXmlDocument.DocumentElement;
        }
        /// <summary><para>method outline:</para>
        /// <para>コンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySXmlReader csXMLReader = HySXmlReader( sXmlFileNameWithPath ) </para>
        /// </example>
        /// <param name="sXmlFileNameWithPath">XMLファイル名称(フルパス)</param>
        /// <returns>生成されたインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySXmlReader(string sXmlFileNameWithPath)
            :base(null)
        {
            m_sFileNameWithPath = sXmlFileNameWithPath;
            this.LoadXML();
            m_csXmlNode = m_csXmlDocument.DocumentElement;
        }
        /// <summary><para>method outline:</para>
        /// <para>ＸＭＬファイル読込</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> LoadXML( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        protected void LoadXML()
        {
            try
            {
                m_csXmlDocument.Load(m_sFileNameWithPath);
                //XmlNodeList csNdList = m_csXmlDocument.GetElementsByTagName("");
            }
            catch
            {
                // ver1.5 エラートレース日本語対応
                string DispStatement = Properties.HysMsgResources.STATEMENT_XML_READ_ERROR + " (" 
                    + m_sFileNameWithPath.ToString()+")";
                HySLog.LogOut(HySLog.ONLINE, "HySXmlReader.LoadXML", DispStatement);
               // HySLog.LogOut(HySLog.ONLINE, "HySXmlReader.LoadXML", "ＸＭＬファイル読込エラー(" + m_sFileNameWithPath.ToString() + ")");
            }
        }
        /// <summary><para>method outline:</para>
        /// <para>ＸＭＬルートノード取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySXmlNode csRootNode = GetRootNode( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>ルートノード</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySXmlNode GetRootNode()
        {
            if (m_csXmlDocument.DocumentElement != null)
            {
                return new HySXmlNode(m_csXmlDocument.DocumentElement);
            }
            else
            {
                return null;
            }
        }
    }
}
