﻿// <summary>ソースコード：XMLファイルクラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;
using System.Xml;

using System.Diagnostics;
using System.IO;

using CommonMP.HYSSOP.Interface;
using CommonMP.HYSSOP.Interface.HSTools;
using CommonMP.HYSSOP.CoreImpl.HSData;

namespace CommonMP.HYSSOP.CoreImpl.HSTools
{
    /// <summary><para>class outline:</para>
    /// <para>XMLファイル書き出しクラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2008/10/01][新規作成]</para>
    /// </remarks>
    public class HySXmlWriter : HySRoot //HySIOStream
    {
        /// <summary> フルパスＸＭＬファイル名 </summary>
        protected string m_sFileNameWithPath;
        /// <summary> ＸＭＬドキュメント </summary>
        protected XmlDocument m_csXmlDocument = null;
        //protected XmlTextWriter m_csWriter=null;
        /// <summary> ルートノード </summary>
        protected HySXmlNode m_csRootNode = null;


        /// <summary><para>method outline:</para>
        /// <para>コンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySXmlWriter csXMLWriter = HySXmlWriter( csXmlFileNameWithPath ) </para>
        /// </example>
        /// <param name="csXmlFileNameWithPath">XMLファイル名称(フルパス)</param>
        /// <returns>生成されたインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySXmlWriter(string csXmlFileNameWithPath)
        {
            m_sFileNameWithPath = csXmlFileNameWithPath;
            /*
            if (File.Exists(m_sFileNameWithPath) == true)
            {
                File.Delete(m_sFileNameWithPath);
            }
            //m_csXmlDocument.Load(m_sFileNameWithPath);
            FileStream csFile = new FileStream(m_sFileNameWithPath, (FileMode)HySFile.CREATE_NEW, (FileAccess)HySFile.WRITE);
            StreamWriter csStreamWriter = new StreamWriter(csFile, System.Text.Encoding.Default);

            m_csWriter = new XmlTextWriter(csStreamWriter);

            */
            m_csXmlDocument = new XmlDocument();
            XmlDeclaration xmlDecl = m_csXmlDocument.CreateXmlDeclaration("1.0", "UTF-8", null);
            m_csXmlDocument.AppendChild(xmlDecl);

        }

         
        /// <summary><para>method outline:</para>
        /// <para>コンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySXmlWriter csXMLWriter = HySXmlWriter( csXmlFileNameWithPath ) </para>
        /// </example>
        /// <param name="csXmlFileNameWithPath">XMLファイル名称(フルパス)</param>
        /// <returns>生成されたインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySXmlWriter(HySString csXmlFileNameWithPath)
        {
            m_sFileNameWithPath = csXmlFileNameWithPath.ToString();
            /*
            if (File.Exists(m_sFileNameWithPath) == true)
            {
                File.Delete(m_sFileNameWithPath);
            }
            //m_csXmlDocument.Load(m_sFileNameWithPath);
            FileStream csFile = new FileStream(m_sFileNameWithPath, (FileMode)HySFile.CREATE_NEW, (FileAccess)HySFile.WRITE);
            StreamWriter csStreamWriter = new StreamWriter(csFile, System.Text.Encoding.Default);

            m_csWriter = new XmlTextWriter(csStreamWriter);

            */
            m_csXmlDocument = new XmlDocument();
            XmlDeclaration xmlDecl = m_csXmlDocument.CreateXmlDeclaration("1.0", "UTF-8", null);
            m_csXmlDocument.AppendChild(xmlDecl);
        }
        /// <summary><para>method outline:</para>
        /// <para>Xmlドキュメント取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> XmlDocument csXMLDoc = GetXmlDocument() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>ＸＭＬドキュメント</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        internal XmlDocument GetXmlDocument()
        {
            return m_csXmlDocument;
        }

        /// <summary><para>method outline:</para>
        /// <para>ルートノード生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> CreateRoot(sName) </para>
        /// </example>
        /// <param name="sName">ルート名</param>
        /// <returns>ルートノード</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySXmlNode CreateRoot(string sName)
        {
            XmlElement csRootElm = m_csXmlDocument.CreateElement(sName);
            m_csXmlDocument.AppendChild(csRootElm);
            m_csRootNode = new HySXmlNode(csRootElm);
            return m_csRootNode;
        }

        /// <summary><para>method outline:</para>
        /// <para>ＸＭＬ書き出し</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Save() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>bool true:保存成功 false:保存失敗</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public bool Save()
        {
            /*
            m_csWriter.Formatting = Formatting.Indented;
            m_csXmlDocument.WriteContentTo(m_csWriter);
            m_csWriter.Close();
            */
            if (File.Exists(m_sFileNameWithPath) == true)
            {
                try
                {
                    File.Delete(m_sFileNameWithPath);
                }
                catch(IOException csException)
                {
                   // ver1.5 エラートレース日本語対応
                    string DispStatement = Properties.HysMsgResources.STATEMENT_CATCH_EXCEPTION + "("
                        + csException.Message.ToString() + ")";
                    HySLog.LogOut(HySLog.ONLINE, "HySXmlWriter::Save", DispStatement);
                   // HySLog.LogOut(HySLog.ONLINE, "HySXmlWriter::Save", "catch IOException (" + csException.Message.ToString() + ")");
                    return false;
                }
            }

            m_csXmlDocument.Save(m_sFileNameWithPath);
            return true;

        }

        /// <summary><para>method outline:</para>
        /// <para>属性設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetAttribute(sAttribute,sVal) </para>
        /// </example>
        /// <param name="sAttribute">属性名</param>
        /// <param name="sVal">値</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetAttribute(string sAttribute, string sVal)
        {
            ((XmlElement)(m_csRootNode.GetXmlNode())).SetAttribute(sAttribute, sVal);
        }
        /// <summary><para>method outline:</para>
        /// <para>子ノード追加</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> AppendChild(csNode) </para>
        /// </example>
        /// <param name="csNode">子ノード</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void AppendChild(HySXmlNode csNode)
        {
            ((XmlElement)(m_csRootNode.GetXmlNode())).AppendChild(csNode.GetXmlNode());
        }

        /// <summary><para>method outline:</para>
        /// <para>属性値をクリア</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> RemoveAllAttributes() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void RemoveAllAttributes()
        {
            ((XmlElement)(m_csRootNode.GetXmlNode())).RemoveAllAttributes();
        }
        /// <summary><para>method outline:</para>
        /// <para>全ての属性値、子供をクリア</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> RemoveAll() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void RemoveAll()
        {
            ((XmlElement)(m_csRootNode.GetXmlNode())).RemoveAll();
        }

        /// <summary><para>method outline:</para>
        /// <para>ノード生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> CreateElement() </para>
        /// </example>
        /// <param name="sName">名称</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySXmlNode CreateElement(string sName)
        {
            return new HySXmlNode(m_csXmlDocument.CreateElement(sName));
        }

        /// <summary><para>method outline:</para>
        /// <para>ルートノードインポート</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> ImportRootNode(csRootNode, bBeep) </para>
        /// </example>
        /// <param name="csRootNode">ルートノード</param>
        /// <param name="bBeep">詳細クローンの実行</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySXmlNode ImportRootNode(HySXmlNode csRootNode, bool bBeep)
        {
            XmlElement csRootElm = (XmlElement)m_csXmlDocument.AppendChild(m_csXmlDocument.ImportNode(csRootNode.GetXmlNode(), bBeep));
            m_csRootNode = new HySXmlNode(csRootElm);
            return m_csRootNode;
        }

        /// <summary><para>method outline:</para>
        /// <para>出力ファイル名取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> GetFileName( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySString 出力ファイル名称</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySString GetFileName()
        { return new HySString(m_sFileNameWithPath); }
    }
}
