﻿// <summary>ソースコード：ＣｏｍｍｏｎＭＰスクリーンファクトリクラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.Interface.HSController;
using CommonMP.HYSSOP.Interface.HSViewer;

using CommonMP.HYSSOP.CoreImpl.HSController;

namespace CommonMP.HYSSOP.CoreImpl.HSViewer
{
    /// <summary><para>class outline:</para>
    /// <para>スクリーンファクトリクラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2009/05/01][新規作成]</para>
    /// </remarks>
    public class HySDispScreenFactory : HySFactoryMono, HySScreenFactory
    {
        /// <summary> 業務種別識別子  </summary>
        protected HySKind m_csSimKind = HySDefine.COMMON_DISP_BUSIPROCEDURE;
        
        /// <summary> <para>method outline:</para>
        /// <para>デフォルトコンストラクタ</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>HySDispScreenFactory csFactory = new HySDispScreenFactory()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySDispScreenFactory 生成されたコンストラクタ</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySDispScreenFactory()
        {
        }

        /// <summary><para>method outline:</para>
        /// <para>シミュレーター種別識別設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetSimKind(csSimKindID)</para>
        /// </example>
        /// <param name="csSimKindID">シミュレーター種別識別子</param>
        /// <returns>なし</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual public void SetSimKind(HySKind csSimKindID)
        {
            m_csSimKind = csSimKindID;
        }

        /// <summary><para>method outline:</para>
        /// <para>業務種別識別子取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySKind csKind = GetSimKind()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySKind 業務種別識別子</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual public HySKind GetSimKind()
        {
            return m_csSimKind;
        }

        /// <summary><para>method outline:</para>
        /// <para>業務種別識別子比較</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bRtn = EqualSimKind(csSimKindID)</para>
        /// </example>
        /// <param name="csSimKindID">業務種別識別子</param>
        /// <returns>Boolean true:同じ、false:異なる</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual public Boolean EqualSimKind(HySKind csSimKindID)
        {
            return m_csSimKind.Equals(csSimKindID);
        }
        

        /// <summary><para>method outline:</para>
        /// <para>スクリーンクラス生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySScreen csScreen = CreateScreen( csSimKind,csID,csScreenKind ) </para>
        /// </example>
        /// <param name="csSimKind">業務種別識別子</param>
        /// <param name="csID">識別子</param>
        /// <param name="csScreenKind">画面種別</param>
        /// <returns>HySScreen スクリーンクラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual public HySScreen CreateScreen(HySKind csSimKind, HySIdentifier csID, HySKind csScreenKind)
        {
            HySScreen csRtnScreen = null;
            if (csSimKind.Equals(m_csSimKind) == true)
            {  // 業務種別識別子の場合
                if (HySDefine.DISP_FORM_LINE_GRAPH.Equals(csScreenKind) == true)
                {  // 折れ線グラフ表示の場合
                    csRtnScreen = new HySLineGraphScreen();
                }
                else if (HySDefine.DISP_FORM_HYDRO_HYETO_GRAPH.Equals(csScreenKind) == true)
                {  // ハイドロ・ハイエトグラフ表示の場合
                    csRtnScreen = new HySHydroHyetoScreen();
                }
                else if (HySDefine.DISP_FORM_HQ_GRAPH.Equals(csScreenKind) == true)
                {  // ＨＱグラフ表示の場合
                    csRtnScreen = new HySHQScreen();
                }
                else if (HySDefine.DISP_FORM_RIVERBED_SHAPE.Equals(csScreenKind) == true)
                {  // 河床面表示の場合
                    csRtnScreen = new HySRiverbedScreen();
                }
                else if (HySDefine.DISP_FORM_RIVER_CROSSSECTION.Equals(csScreenKind) == true)
                {  // 河道横断面図表示の場合
                    csRtnScreen = new HySRiverCrossSectionScreen();
                }
                else if (HySDefine.DISP_FORM_SEARCH_CONDITION.Equals(csScreenKind) == true)
                {  // 検索条件設定表示の場合
                    csRtnScreen = new HySSearchConditionScreen();
                }
                else if (HySDefine.DISP_FORM_RESULT_SELECTION.Equals(csScreenKind) == true)
                {  // 検索結果選択表示の場合
                    csRtnScreen = new HySResultSelectionScreen();
                }
                else if (HySDefine.DISP_FORM_EXCEL.Equals(csScreenKind) == true)
                {  // Excel表示の場合
                    csRtnScreen = new HySMSExcelScreen();
                }
                else if (HySDefine.DISP_FORM_GRAPH_CUSTOMIZ.Equals(csScreenKind) == true)
                {  // グラフカスタマイズ表示の場合
                    csRtnScreen = new HySGraphCustomizScreen();
                }
                else if (HySDefine.DISP_FORM_GIS_BASEMAP.Equals(csScreenKind) == true)
                {   // 背景地図表示の場合
                    csRtnScreen = new HySGISBaseMapScreen();
                }
                else if (HySDefine.DISP_FORM_GIS2D_MESH.Equals(csScreenKind) == true)
                {   // 地図上２次元メッシュ表示の場合
                    csRtnScreen = new HySGISDim2MeshScreen();
                }
                else if (HySDefine.DISP_FORM_GIS_FIGURE.Equals(csScreenKind) == true)
                {   // 地図上自由図形表示の場合
                    csRtnScreen = new HySGISMapFigureScreen();
                }
                else if (HySDefine.DISP_FORM_MONITER.Equals(csScreenKind) == true)
                {   // 計算結果モニタ表示の場合
                    csRtnScreen = new HySMoniterScreen();
                }
                else if (HySDefine.DISP_FORM_RIVER_CROSSSECTION.Equals(csScreenKind) == true)
                {  // Ｅｘｃｅｌ検索条件設定表示の場合
                    csRtnScreen = new HySRiverCrossSectionScreen();
                }
            }
            return csRtnScreen;
        }
    }
}
