﻿// <summary>ソースコード：計算結果モニター表示フォームＩ／Ｆ</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.Interface.HSGIS;
using CommonMP.HYSSOP.Interface.HSViewer;

using CommonMP.HYSSOP.CoreImpl.HSData;

namespace CommonMP.HYSSOP.CoreImpl.HSViewer
{
    /// <summary><para>class outline:</para>
    /// <para>計算結果モニター表示フォームＩ／Ｆ</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2009/05/01][新規作成]</para>
    /// <para>Remarks</para>
    /// <para>本クラスは、計算結果モニタ画面フォーム専用のスタブです</para>
    /// <para>原則、計算結果モニタ画面フォーム以外では使用しないでください</para>
    /// </remarks>
    public interface HySMoniterFormIF : HySViewFormBaseIF
    {
        /// <summary><para>method outline:</para>
        /// <para>識別子設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetID( csID ) </para>
        /// </example>
        /// <param name="csID">識別子</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        void SetID(HySIdentifier csID);
        /// <summary><para>method outline:</para>
        /// <para>識別子取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySIdentifier csID = GetID( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>識別子</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        HySIdentifier GetID();
        /// <summary><para>method outline:</para>
        /// <para>送り元シミュレーター種別識別子設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetFromSimKind(csSimKindID)</para>
        /// </example>
        /// <param name="csSimKindID">シミュレーター種別識別子</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        void SetFromSimKind(HySKind csSimKindID);
        /// <summary><para>method outline:</para>
        /// <para>送り元シミュレーター種別識別子取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySKind csSimKind = GetFromSimKind()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySKind　シミュレーター種別識別子</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        HySKind GetFromSimKind();
        /// <summary><para>method outline:</para>
        /// <para>計算結果データの設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetDispResultData(csResultData)</para>
        /// </example>
        /// <param name="csResultData">計算結果データ</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        void SetDispResultData(HySDataRoot csResultData);
        /// <summary><para>method outline:</para>
        /// <para>画面インスタンス複製処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySViewFormBaseIF csForm = Clon()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySViewFormBaseIF 複写した画面インスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        HySViewFormBaseIF Clone();
        /// <summary><para>method outline:</para>
        /// <para>フォーム一貫番号設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetFormNumber(lNumber)</para>
        /// </example>
        /// <param name="lNumber">Form一貫番号</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        void SetFormNumber(long lNumber);
        /// <summary><para>method outline:</para>
        /// <para>フォーム一貫番号取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>long lNumber = GetFormNumber()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>long Form一貫番号</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        long GetFormNumber();
    }
}
