﻿// <summary>ソースコード：河川横断面図表示フォームＩ／Ｆ</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.Interface.HSGIS;
using CommonMP.HYSSOP.Interface.HSViewer;

using CommonMP.HYSSOP.CoreImpl.HSData;

namespace CommonMP.HYSSOP.CoreImpl.HSViewer
{
    /// <summary><para>class outline:</para>
    /// <para>河川横断面図形状表示フォームＩ／Ｆ</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2009/05/01][新規作成]</para>
    /// </remarks>
    public interface HySRiverCrossSectionFormIF : HySViewFormBaseIF
    {
        /// <summary><para>method outline:</para>
        /// <para>横断面データ一覧要求応答</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = SetCrossSectionList(result, path)</para>
        /// </example>
        /// <param name="result">bool =true:要求成功、=false:要求失敗</param>
        /// <param name="path">横断面データ一覧ファイルパス</param>
        /// <returns>bool 処理結果 =true:正常、=false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        bool SetCrossSectionList(bool result, string path);
        /// <summary><para>method outline:</para>
        /// <para>横断面データ要求応答</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = SetCrossSection(result, data)</para>
        /// </example>
        /// <param name="result">bool =true:要求成功、=false:要求失敗</param>
        /// <param name="data">河川横断面図形状データ</param>
        /// <returns>bool 処理結果 =true:正常、=false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        bool SetCrossSection(bool result, HySGeoRiverCrossSectionData data);
        /// <summary><para>method outline:</para>
        /// <para>横断面データ要求応答</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = SetCrossSection(result, datas)</para>
        /// </example>
        /// <param name="result">bool =true:要求成功、=false:要求失敗</param>
        /// <param name="data">河川横断面図形状データ配列</param>
        /// <returns>bool 処理結果 =true:正常、=false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        bool SetCrossSection(bool result, HySGeoRiverCrossSectionData[] data);
        /// <summary><para>method outline:</para>
        /// <para>横断面データ保存要求応答</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = RespondSaveCrossSection(result)</para>
        /// </example>
        /// <param name="result">bool =true:保存成功、=false:保存失敗</param>
        /// <returns>bool 処理結果 =true:正常、=false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        bool RespondSaveCrossSection(bool result);
    }
}
