﻿// <summary>ソースコード：自由図形表示クリーンクラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.Interface.HSViewer;
using CommonMP.HYSSOP.Interface.HSGIS;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSGIS;

namespace CommonMP.HYSSOP.CoreImpl.HSViewer
{
    /// <summary><para>class outline:</para>
    /// <para>自由図形表示スクリーンクラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2008/10/01][新規作成]</para>
    /// </remarks>
    /// <remarks><para>Remarks</para>
    /// <para>インスタンス複数存在有り（複数のオブジェクト情報をオーバーレイ表示する）</para>
    /// </remarks>
    public class HySGISMapFigureScreen : HySGISScreenBase
    {
        /// <summary><para>method outline:</para>
        /// <para>ビュー種別取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySKind csKind = GetViewKind()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>ＧＩＳビュー種別</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override HySKind GetViewKind()
        { return HySDefine.DISP_FORM_GIS_FIGURE; }
        /// <summary><para>method outline:</para>
        /// <para>ＧＩＳビュー種別比較</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bRtn = EqualViewKind(csViewKindID)</para>
        /// </example>
        /// <param name="csViewKindID">ビュー種別</param>
        /// <returns>true  : 同じ、false : 異なる</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override Boolean EqualViewKind(HySKind csViewKindID)
        { return HySDefine.DISP_FORM_GIS_FIGURE.Equals(csViewKindID); }

        /// <summary><para>method outline:</para>
        /// <para>イベントを受け取った時に動作するメソッド</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bRtn = EventCallback( csEvent ) </para>
        /// </example>
        /// <param name="csEvent">送られたイベント</param>
        /// <returns>true:=正常, false:=異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>各実装クラスは受け取ったイベント毎に処理を行う</para>
        /// </remarks>
        public override Boolean EventCallback(HySSysEvent csEvent)
        {
            return false;
        }

        /// <summary><para>method outline:</para>
        /// <para>表示に特別に必要なイベント情報の設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetDispEventData( csEvent ) </para>
        /// </example>
        /// <param name="csEvent">イベント情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>表示に特別に必要なイベント情報があった場合のみ発行</para>
        /// </remarks>
        public override void SetDispEventData(HySSysEvent csEvent)
        {
            // 図形表示用データを取得
            HySEventObject csHySEvent = (HySEventObject)csEvent;
            if (csHySEvent.GetSubData() is HySGeoMapFigureData)
            {   // 図形表示用データの場合
                HySGeoMapFigureData csFigureData = csHySEvent.GetSubData() as HySGeoMapFigureData;//(HySGeoMapFigureData)csHySEvent.GetData();
                ((HySGISMapFigureView)m_csGISView).SetDispFigureData(csFigureData);
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>オブジェクトセレクト通知</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> NoticeObjectSelect( bOnOffSw, csIDList) 
        /// </para>
        /// </example>
        /// <param name="bOnOffSw">=true:セレクトＯＮ／=false:セレクトＯＦＦ</param>
        /// <param name="csIDList">セレクトオブジェクトのＩＤリスト</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void NoticeObjectSelect(bool bOnOffSw, HySDataLinkedList csIDList)
        {
            // 取得したリストの情報を自オブジェクトに移し変える
            HySDataLinkedList csSelectedObjIDList = new HySDataLinkedList();
            long lNumObj = csIDList.GetCount();
            csIDList.SetCursorFirst();
            for (long lLP = 0; lLP < lNumObj; lLP++)
            {
                csSelectedObjIDList.AddLast(csIDList.GetCursorData());
                csIDList.MoveCursorNext();
            }

            HySEventObject csEvtObj = new HySEventObject(HySSysEvent.OBJID_BUSIPROCEDURE, HySEventObject.NOTICE_GIS_OK, csSelectedObjIDList);
            if (bOnOffSw == true)
            {
                csEvtObj.SetSubEventNo(HySGISDefine.OBJECT_SELECT_ON);
            }
            else
            {
                csEvtObj.SetSubEventNo(HySGISDefine.OBJECT_SELECT_OFF);
            }
            this.PutEvent(csEvtObj);
        }
    }
}
