﻿// <summary>ソースコード：GIS関連スクリーンクラスＩ／Ｆ</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.Interface.HSGIS;
using CommonMP.HYSSOP.Interface.HSViewer;

using CommonMP.HYSSOP.CoreImpl.HSData;

namespace CommonMP.HYSSOP.CoreImpl.HSViewer
{
    /// <summary><para>class outline:</para>
    /// <para>GIS関連スクリーンクラス基底（抽象クラス）</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2009/05/01][新規作成]</para>
    /// </remarks>
    public abstract class HySGISScreenBase : HySScreenBase, HySGISScreen
    {
        /// <summary>対応するＧＩＳビュー</summary>
        protected HySGISView m_csGISView = null;

        /// <summary>ＧＩＳビュー種別</summary>
        protected HySObjectKind m_csGISViewKind = null;


        /// <summary><para>method outline:</para>
        /// <para>初期処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>Initialize()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void Initialize()
        {
            if (m_csGISView != null)
            { // 画面が有効な場合
                m_csGISView.SetScreen(this); // スクリーン設定
                m_csGISView.Initialize(); // 画面の初期化
            }
        }
        /// <summary><para>method outline:</para>
        /// <para>終了処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>Terminate()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void Terminate()
        {
            if (m_csGISView != null)
            { // 画面が有効な場合
                m_csGISView.Terminate();
            }
        }
        /// <summary><para>method outline:</para>
        /// <para>画面表示</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> ShowScreen( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void ShowScreen()
        {
            if (m_csGISView != null)
            {
                m_csGISView.Show();
            }
        }
        /// <summary><para>method outline:</para>
        /// <para>画面非表示化</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HideScreen( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void HideScreen()
        {
            if (m_csGISView != null)
            {
                m_csGISView.Hide();
            }
        }
        /// <summary><para>method outline:</para>
        /// <para>画面更新</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> RenewScreen( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void RenewScreen()
        {
            if (m_csGISView != null)
            {
                m_csGISView.Renew();
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>画面消去</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> CloseScreen( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void CloseScreen()
        {
            if (m_csGISView != null)
            {
                m_csGISView.Close();
            }
        }
        /// <summary><para>method outline:</para>
        /// <para>画面初期配置表示</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> InitiateScreen( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void InitiateScreen()
        { }

        /// <summary><para>method outline:</para>
        /// <para>対となるＧＩＳビューの設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetViewForm(csGISView)</para>
        /// </example>
        /// <param name="csGISView">ＧＩＳビュー</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void SetViewForm(HySViewForm csGISView)
        {
            m_csGISView = csGISView as HySGISView;
        }
        /// <summary><para>method outline:</para>
        /// <para>ＧＩＳビュー種別取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySKind csKind = GetGISViewKind()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>ＧＩＳビュー種別</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual HySKind GetGISViewKind()
        {
            return m_csGISViewKind;
        }
        /// <summary><para>method outline:</para>
        /// <para>ＧＩＳビュー種別比較</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bRtn = EqualGISViewKind(csGISViewKindID)</para>
        /// </example>
        /// <param name="csGISViewKindID">ＧＩＳビュー種別</param>
        /// <returns>true  : 同じ、false : 異なる</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual Boolean EqualGISViewKind(HySKind csGISViewKindID)
        {
            return m_csGISViewKind.Equals(csGISViewKindID);
        }
    }
}
