﻿// <summary>ソースコード：Ｅｘｃｅｌ表示スクリーン</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Collections;
using System.Text;
using System.Data;
using System.IO;
using System.Reflection;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.Interface.HSGIS;
using CommonMP.HYSSOP.Interface.HSViewer;

using CommonMP.HYSSOP.CoreImpl;
using CommonMP.HYSSOP.CoreImpl.HSBusiProc;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;
using CommonMP.HYSSOP.CoreImpl.HSViewer;

namespace CommonMP.HYSSOP.CoreImpl.HSViewer
{
    /// <summary><para>class outline:</para>
    /// <para>Ｅｘｃｅｌ表示スクリーン</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2009/05/01][新規作成]</para>
    /// </remarks>
    public class HySMSExcelScreen : HySScreenBase
    {
        /// <summary>時系列データＣＳＶファイルパス</summary>
        static public readonly string TIMESREISTMP_PASS = "\\Temp\\TimeSreisTmp.csv";
        /// <summary>定常データＣＳＶファイルパス</summary>
        static public readonly string NUMBERTMP_PASS = "\\Temp\\NumBerTmp.csv";
        /// <summary>時刻項目タイトル</summary>
        static public readonly string TIME_ITEM_HEAD = "Time";
        /// <summary>X軸項目タイトル</summary>
        static public readonly string XAXIS_ITEM_HEAD = "Value";
        /// <summary>列項目タイトル</summary>
        static public readonly string DATA_ITEM_HEAD = "Data";

        /// <summary>データコンテナ</summary>
        protected HySContainer m_csContainer = null;

        /// <summary>データ保存クラスリスト</summary>
        protected HySStockDataList m_csStockDataList = null;

        /// <summary>データ保存クラス</summary>
        protected HySStockData m_csStockData = null;

        /// <summary>表示業務管理データ</summary>
        protected HySDispBusiProcedureCtlInfo m_csDBPCtlInfo = null;

        /// <summary>選択データ識別キー管理リスト</summary>
        protected ArrayList m_csIDList = null;

        /// <summary><para>method outline:</para>
        /// <para>ビュー種別取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySKind csKind = GetViewKind()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySKind ビュー種別</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override HySKind GetViewKind()
        { return HySDefine.DISP_FORM_EXCEL; }
        /// <summary><para>method outline:</para>
        /// <para>ビュー種別比較</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bRtn = EqualViewKind(csViewKindID)</para>
        /// </example>
        /// <param name="csViewKindID">ビュー種別</param>
        /// <returns>Boolean true:同じ、false:異なる</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override Boolean EqualViewKind(HySKind csViewKindID)
        { return HySDefine.DISP_FORM_EXCEL.Equals(csViewKindID); }

        /// <summary><para>method outline:</para>
        /// <para>初期処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>Initialize()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void Initialize()
        {
        }

        /// <summary><para>method outline:</para>
        /// <para>終了処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>Terminate()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void Terminate()
        {
        }

        /// <summary><para>method outline:</para>
        /// <para>画面表示</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> ShowScreen( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void ShowScreen()
        {
        }
        /// <summary><para>method outline:</para>
        /// <para>画面非表示化</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HideScreen( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void HideScreen()
        {
        }
        /// <summary><para>method outline:</para>
        /// <para>画面更新</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> RenewScreen( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void RenewScreen()
        {
            this.ExcelOutComs_Outdata(m_csIDList, m_csStockDataList, m_csContainer); // Excel画面表示
        }

        /// <summary><para>method outline:</para>
        /// <para>画面消去</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> CloseScreen( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void CloseScreen()
        {
            HySEventObject csEventObj = new HySEventObject(HySSysEvent.OBJID_VIEWER, HySEventObject.CMND_CLOSE_SCREEN);
            csEventObj.SetToSimKind(m_csSimKindID);
            csEventObj.SetSuppID(m_csID);
            csEventObj.SetData(this.GetViewKind());
            csEventObj.SetSubEventNo(HySDispDefine.NOTICE_SCREEN_CLOSE);
            this.PutEvent(csEventObj);
        }

        /// <summary><para>method outline:</para>
        /// <para>画面初期配置表示</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> InitiateScreen( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void InitiateScreen()
        {
        }

        /// <summary><para>method outline:</para>
        /// <para>イベントを受け取った時に動作するメソッド</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bRtn = EventCallback( csEvent ) </para>
        /// </example>
        /// <param name="csEvent">送られたイベント</param>
        /// <returns>Boolean true:=正常, false:=異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>各実装クラスは受け取ったイベント毎に処理を行う</para>
        /// </remarks>
        public override Boolean EventCallback(HySSysEvent csEvent)
        {
            Boolean bRtn = true;
            HySEventObject csHySEvent = (HySEventObject)csEvent;
            long lEventNo = csHySEvent.GetEventNo();
            HySID csID = csHySEvent.GetSuppID();
            HySObjectKind csSimKind = (HySObjectKind)csHySEvent.GetToSimKind();
            long lEventSubNo = ((HySEventObject)csEvent).GetSubEventNo();
            if (lEventNo == HySEventObject.CMND_DISP_SCREEN)
            {  // 画面表示指示の場合
                m_csContainer = ((HySEventObject)csEvent).GetSubData() as HySContainer;
                if (m_csContainer is HySDataContainer)
                {  // データコンテナが有る場合
                    m_csDBPCtlInfo = m_csContainer.GetData(HySDispDefine.DISPCTL_INFO_KEYS) as HySDispBusiProcedureCtlInfo;
                }
            }
            else if (lEventNo == HySEventObject.CMND_DISPLY_COMMON)
            {  // 画面一般指示（表示更新、検索）の場合
                if (lEventSubNo == HySDispDefine.NOTICE_SCREEN_UPDATE)
                {  // 再表示要求の場合
                    HySContainer csContainer = ((HySEventObject)csEvent).GetSubData() as HySContainer;
                    if (csContainer is HySContainer)
                    {  // データコンテナが添付されていた場合
                        m_csContainer = csContainer;
                    }
                    if (m_csContainer is HySDataContainer)
                    {  // データコンテナが有る場合
                        m_csDBPCtlInfo = m_csContainer.GetData(HySDispDefine.DISPCTL_INFO_KEYS) as HySDispBusiProcedureCtlInfo;
                        if (m_csDBPCtlInfo is HySDispBusiProcedureCtlInfo)
                        {  // 表示業務管理データが有る場合
                            m_csIDList = m_csDBPCtlInfo.GetIDList() as ArrayList;
                        }
                        m_csStockDataList = m_csContainer.GetData(HySDispDefine.STOCKDATALIST_KEYS) as HySStockDataList;
                    }
                    this.RenewScreen();
                    System.Threading.Thread.Sleep(1000); // 一定時間待ち
                    this.CloseScreen();
                }
                if (lEventSubNo == HySDispDefine.NOTICE_SCREEN_CLOSE)
                {  // 子画面終了通知の場合
                    if (m_csContainer is HySDataContainer)
                    {  // データコンテナが有る場合
                        m_csDBPCtlInfo = m_csContainer.GetData(HySDispDefine.DISPCTL_INFO_KEYS) as HySDispBusiProcedureCtlInfo;
                        if (m_csDBPCtlInfo is HySDispBusiProcedureCtlInfo)
                        {  // 表示業務管理データが有る場合
                            if (m_csDBPCtlInfo.GetChildCount() <= 0)
                            {  // 全子画面が終了した場合
                                this.CloseScreen(); // 画面を閉じる
                            }
                            else
                            {  // 子画面が有る場合
                                if (m_csDBPCtlInfo.GetChildCount() == 1)
                                {  // 子画面が1つの場合
                                    if (m_csDBPCtlInfo.GetChildScreenKind(1).Equals(HySDefine.DISP_FORM_SEARCH_CONDITION) == false)
                                    {  // 検索条件設定画面が閉じられた場合
                                        this.CloseScreen(); // 画面を閉じる
                                    }
                                }
                            }
                        }
                    }
                }
            }
            return bRtn;
        }

        /// <summary><para>method outline:</para>
        /// <para>表示に特別に必要なイベント情報の設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetDispEventData( csEvent ) </para>
        /// </example>
        /// <param name="csEvent">イベント情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>表示に特別に必要なイベント情報があった場合のみ発行</para>
        /// </remarks>
        public override void SetDispEventData(HySSysEvent csEvent)
        {
            this.EventCallback(csEvent); // 初期起動イベントを画面に渡す
            if (m_csDBPCtlInfo.GetParentsScreenMode() == HySDispDefine.NOTICE_NO_SEARCH_CONDITION_SCREEN_LATEST)
            {  // 自動検索要求の場合
                HySEventObject csEventObj = new HySEventObject(HySSysEvent.OBJID_BUSIPROCEDURE, HySEventObject.CMND_DISPLY_COMMON);
                csEventObj.SetToSimKind(m_csSimKindID);
                csEventObj.SetSuppID(m_csID);
                csEventObj.SetData(HySDefine.DISP_FORM_SEARCH_CONDITION);
                csEventObj.SetSubEventNo(HySDispDefine.NOTICE_CALC_RESULT_DATA_LIST_REQUEST);
                this.PutEvent(csEventObj);
            }
            else
            {  // 自動検索要求以外の場合
                HySEventObject csEventObj = new HySEventObject(HySSysEvent.OBJID_BUSIPROCEDURE, HySEventObject.CMND_DISP_SCREEN);
                csEventObj.SetToSimKind(m_csSimKindID);
                csEventObj.SetSuppID(m_csID);
                csEventObj.SetData(HySDefine.DISP_FORM_SEARCH_CONDITION);
                csEventObj.SetSubEventNo(HySDispDefine.NOTICE_ONLY_RESULT_SELECTION_NOTIFICATION);
                this.PutEvent(csEventObj);
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>対となる画面フォームの設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetViewForm( csViewForm )</para>
        /// </example>
        /// <param name="csViewForm">画面フォーム</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void SetViewForm(HySViewForm csViewForm)
        {
        }

        /// <summary><para>method outline:</para>
        /// <para>Ｅｘｃｅｌ出力処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>ExcelOutComs(csIDList,csStockDataList,csContainer,csSaveFileName)</para>
        /// </example>
        /// <param name="csIDList">選択データ識別キーリスト</param>
        /// <param name="csStockDataList">格納データリスト</param>
        /// <param name="csContainer">データコンテナ</param>
        /// <param name="csSaveFileName">出力ファイル名称</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void ExcelOutComs(ArrayList csIDList, HySStockDataList csStockDataList, HySContainer csContainer, HySString csSaveFileName)
        {
            ArrayList csFileName = new ArrayList();

            // ＣＳＶファイル削除
            string csFileNamePath = HySEnvInf.GetHomeDirectory().ToString() + TIMESREISTMP_PASS;
            if (File.Exists(csFileNamePath) == true)
            {  // ファイルが有る場合
                try
                {
                    File.Delete(csFileNamePath);
                }
                catch
                {
                   // ver1.5 エラートレース日本語対応
                    string DispStatement = Properties.HysMsgResources.STATEMENT_FILE_USING + "("
                        + csFileNamePath + "）";

                    HySLog.LogOut(HySLog.ONLINE, "HySMSExcelScreen", DispStatement );
                   // HySLog.LogOut(HySLog.ONLINE, "HySMSExcelScreen", "ファイルが使用中です（" + csFileNamePath + "）");
                    return;
                }
            }
            csFileNamePath = HySEnvInf.GetHomeDirectory().ToString() + NUMBERTMP_PASS;
            if (File.Exists(csFileNamePath) == true)
            {  // ファイルが有る場合
                try
                {
                    File.Delete(csFileNamePath);
                }
                catch
                {
                    // ver1.5 エラートレース日本語対応
                    string DispStatement = Properties.HysMsgResources.STATEMENT_FILE_USING + "("
                        + csFileNamePath + "）";

                    HySLog.LogOut(HySLog.ONLINE, "HySMSExcelScreen", DispStatement );
                   // HySLog.LogOut(HySLog.ONLINE, "HySMSExcelScreen", "ファイルが使用中です（" + csFileNamePath + "）");
                    return;
                }
            }

            // 汎用データＣＳＶ変換
            if (csIDList is ArrayList)
            {  // 選択データ識別が有効な場合
                if (csIDList.Count >= 2)
                {  // 登録データがある場合
                    List<string> csItemName = new List<string>();
                    DataTable csDataTbl = csIDList[0] as DataTable;
                    bool bTimeMode = (bool)csIDList[1];
                    if (csDataTbl is DataTable)
                    {  // データ取得が有効な場合
                        DataTable csTimeDataTable = new DataTable();
                        if (bTimeMode == true)
                        {  // 時系列の場合
                            csTimeDataTable.Columns.Add(TIME_ITEM_HEAD, typeof(DateTime)); // 時刻列追加
                        }
                        else
                        {  // 値の場合
                            csTimeDataTable.Columns.Add(XAXIS_ITEM_HEAD, typeof(double)); // 配列値列追加
                        }
                        // 列ヘッダ基準名設定
                        for (int iLp = 1; iLp < csDataTbl.Columns.Count; iLp++)
                        {
                            csItemName.Add(DATA_ITEM_HEAD + iLp.ToString()); // データ列追加
                        }
                        if (csIDList.Count == 3)
                        {  // 列詳細データが有る場合
                            DataTable csColDataTbl = csIDList[2] as DataTable;
                            if (csColDataTbl is DataTable)
                            {  // 列詳細データが有効な場合
                                for (int iLp = 1; iLp < csColDataTbl.Rows.Count; iLp++)
                                {
                                    csItemName[iLp - 1] = csColDataTbl.Rows[iLp]["ItemName"].ToString();
                                }
                            }
                        }
                        for (int iLp = 1; iLp < csDataTbl.Columns.Count; iLp++)
                        {
                            csTimeDataTable.Columns.Add(csItemName[iLp - 1], typeof(double)); // データ列追加
                        }
                        HySTime csTime = HySTime.DEFAULT_TIME.Clone();
                        DataRow csRows = null; 
                        for (int iLp = 0; iLp < csDataTbl.Rows.Count; iLp++)
                        {
                            csRows = csTimeDataTable.NewRow();  // 行生成
                            if (bTimeMode == true)
                            {  // 時系列の場合
                                csTime.SetTime((double)csDataTbl.Rows[iLp]["TimeData"]);
                                csRows[TIME_ITEM_HEAD] = DateTime.Parse(HySCalendar.GetString(csTime, HySCalendar.FORMAT.lSW_YEAR).ToString()); // 時刻設定
                            }
                            else
                            {  // 配列値の場合
                                csRows[XAXIS_ITEM_HEAD] = (double)csDataTbl.Rows[iLp]["TimeData"]; // 値設定
                            }
                            for (int iLp1 = 1; iLp1 < csTimeDataTable.Columns.Count; iLp1++)
                            {
                                csRows[csItemName[iLp1 - 1]] = csDataTbl.Rows[iLp][DATA_ITEM_HEAD + iLp1.ToString()]; // データ設定
                            }
                            csTimeDataTable.Rows.Add(csRows);   // 行追加
                        }
                        if (bTimeMode == true)
                        {  // 時系列の場合
                            this.CSVOutPut(csTimeDataTable, TIMESREISTMP_PASS);
                        }
                        else
                        {  // 値の場合
                            this.CSVOutPut(csTimeDataTable, NUMBERTMP_PASS);
                        }
                        csTimeDataTable = null;
                    }
                    csItemName = null;
                }
            }

            string csFileNamePath1 = HySEnvInf.GetHomeDirectory().ToString() + TIMESREISTMP_PASS;
            string csFileNamePath2 = HySEnvInf.GetHomeDirectory().ToString() + NUMBERTMP_PASS;
            int iSCnt = (File.Exists(csFileNamePath1) == true) ? 1 : 0;
            iSCnt += (File.Exists(csFileNamePath2) == true) ? 1 : 0;
            if (iSCnt > 0)
            {  // ファイルが有る場合
                // Ｅｘｃｅｌシート編集（遅延バインディングオートメーションでの実装）
                object csObjApp = null;
                object csObjBook = null;
                object csObjBooks = null;
                object csObjSheets = null;
                object csObjSheet = null;
                object[] csParameters = null;
                object csObjBookCSV = null;
                object csObjSheetsCSV = null;
                object csObjSheetCSV = null;
                try
                {
                    // Ｅｘｃｅｌクラスインスタンス取得
                    Type csObjClassType;
                    csObjClassType = Type.GetTypeFromProgID("Excel.Application");
                    csObjApp = Activator.CreateInstance(csObjClassType);
                    // Workbooks枚数設定
                    csParameters = new Object[1];
                    csParameters[0] = 1;
                    csObjApp.GetType().InvokeMember("SheetsInNewWorkBook",
                                        BindingFlags.SetProperty, null, csObjApp, csParameters);
                    csParameters = null;
                    // Workbooksコレクションプロパティ取得
                    csObjBooks = csObjApp.GetType().InvokeMember("Workbooks",
                                        BindingFlags.GetProperty, null, csObjApp, null);
                    // WorkSheetの追加
                    csObjBook = csObjBooks.GetType().InvokeMember("Add",
                                    BindingFlags.InvokeMethod, null, csObjBooks, null);
                    // Worksheetコレクションプロパティ取得
                    csObjSheets = csObjBook.GetType().InvokeMember("Worksheets",
                                    BindingFlags.GetProperty, null, csObjBook, null);
                    iSCnt = 1; // シートカウンタ設定
                    if (File.Exists(csFileNamePath1) == true)
                    {  // 時系列ＣＳＶが有る場合
                        try
                        {
                            // 先頭のSheetプロパティ取得
                            csParameters = new Object[1];
                            csParameters[0] = iSCnt;
                            csObjSheet = csObjSheets.GetType().InvokeMember("Item",
                                            BindingFlags.GetProperty, null, csObjSheets, csParameters);
                            csParameters = null;
                            // 時系列ＣＳＶファイルを開く
                            object[] args = { csFileNamePath1 };
                            csObjBookCSV = csObjBooks.GetType().InvokeMember("Open",
                                              BindingFlags.InvokeMethod, null, csObjBooks, args);
                            // Worksheetコレクションプロパティ取得
                            csObjSheetsCSV = csObjBookCSV.GetType().InvokeMember("Worksheets",
                                             BindingFlags.GetProperty, null, csObjBookCSV, null);
                            // 先頭のSheetプロパティ取得
                            csParameters = new Object[1];
                            csParameters[0] = 1;
                            csObjSheetCSV = csObjSheetsCSV.GetType().InvokeMember("Item",
                                            BindingFlags.GetProperty, null, csObjSheetsCSV, csParameters);
                            csParameters = null;
                            // 時系列ＣＳＶの内容を複写する
                            csParameters = new Object[2];
                            csParameters[0] = csObjSheet;
                            csParameters[1] = Missing.Value;
                            csObjSheetCSV.GetType().InvokeMember("Copy",
                                            BindingFlags.InvokeMethod, null, csObjSheetCSV, csParameters);
                            csParameters = null;
                            // 変更保存確認メッセージの抑止
                            csParameters = new object[] { false };
                            csObjApp.GetType().InvokeMember("DisplayAlerts",
                                            BindingFlags.SetProperty, null, csObjApp, csParameters);
                            csParameters = null;
                            // 時系列ＣＳＶファイルを閉じる
                            csObjBookCSV.GetType().InvokeMember("Close",
                                     BindingFlags.InvokeMethod, null, csObjBookCSV, args);
                            // 変更保存確認メッセージの抑止解除
                            csParameters = new object[] { true };
                            csObjApp.GetType().InvokeMember("DisplayAlerts",
                                            BindingFlags.SetProperty, null, csObjApp, csParameters);
                            csParameters = null;
                            iSCnt++; // 複写先シート数更新
                        }
                        finally
                        {  // ＣＯＭ参照カウンタを開放
                            if (csObjSheetCSV != null)
                            {  // オブジェクト有効な場合はＣＯＭ参照カウンタを開放する
                                System.Runtime.InteropServices.Marshal.ReleaseComObject(csObjSheetCSV);
                                csObjSheetCSV = null;
                            }
                            if (csObjSheetsCSV != null)
                            {  // オブジェクト有効な場合はＣＯＭ参照カウンタを開放する
                                System.Runtime.InteropServices.Marshal.ReleaseComObject(csObjSheetsCSV);
                                csObjSheetsCSV = null;
                            }
                            if (csObjBookCSV != null)
                            {  // オブジェクト有効な場合はＣＯＭ参照カウンタを開放する
                                System.Runtime.InteropServices.Marshal.ReleaseComObject(csObjBookCSV);
                                csObjBookCSV = null;
                            }
                            if (csObjSheet != null)
                            {  // オブジェクト有効な場合はＣＯＭ参照カウンタを開放する
                                System.Runtime.InteropServices.Marshal.ReleaseComObject(csObjSheet);
                                csObjSheet = null;
                            }
                        }
                    }
                    if (File.Exists(csFileNamePath2) == true)
                    {  // 定常ＣＳＶが有る場合
                        try
                        {
                            // 先頭のSheetプロパティ取得
                            csParameters = new Object[1];
                            csParameters[0] = iSCnt;
                            csObjSheet = csObjSheets.GetType().InvokeMember("Item",
                                            BindingFlags.GetProperty, null, csObjSheets, csParameters);
                            csParameters = null;
                            // 定常ＣＳＶファイルを開く
                            object[] args = { csFileNamePath2 };
                            csObjBookCSV = csObjBooks.GetType().InvokeMember("Open",
                                              BindingFlags.InvokeMethod, null, csObjBooks, args);
                            // Worksheetコレクションプロパティ取得
                            csObjSheetsCSV = csObjBookCSV.GetType().InvokeMember("Worksheets",
                                             BindingFlags.GetProperty, null, csObjBookCSV, null);
                            // 先頭のSheetプロパティ取得
                            csParameters = new Object[1];
                            csParameters[0] = 1;
                            csObjSheetCSV = csObjSheetsCSV.GetType().InvokeMember("Item",
                                            BindingFlags.GetProperty, null, csObjSheetsCSV, csParameters);
                            csParameters = null;
                            // 定常ＣＳＶの内容を複写する
                            csParameters = new Object[2];
                            csParameters[0] = csObjSheet;
                            csParameters[1] = Missing.Value;
                            csObjSheetCSV.GetType().InvokeMember("Copy",
                                            BindingFlags.InvokeMethod, null, csObjSheetCSV, csParameters);
                            csParameters = null;
                            // 変更保存確認メッセージの抑止
                            csParameters = new object[] { false };
                            csObjApp.GetType().InvokeMember("DisplayAlerts",
                                            BindingFlags.SetProperty, null, csObjApp, csParameters);
                            csParameters = null;
                            // 定常ＣＳＶファイルを閉じる
                            csObjBookCSV.GetType().InvokeMember("Close",
                                     BindingFlags.InvokeMethod, null, csObjBookCSV, args);
                            // 変更保存確認メッセージの抑止解除
                            csParameters = new object[] { true };
                            csObjApp.GetType().InvokeMember("DisplayAlerts",
                                            BindingFlags.SetProperty, null, csObjApp, csParameters);
                            csParameters = null;
                        }
                        finally
                        {  // ＣＯＭ参照カウンタを開放
                            if (csObjSheetCSV != null)
                            {  // オブジェクト有効な場合はＣＯＭ参照カウンタを開放する
                                System.Runtime.InteropServices.Marshal.ReleaseComObject(csObjSheetCSV);
                                csObjSheetCSV = null;
                            }
                            if (csObjSheetsCSV != null)
                            {  // オブジェクト有効な場合はＣＯＭ参照カウンタを開放する
                                System.Runtime.InteropServices.Marshal.ReleaseComObject(csObjSheetsCSV);
                                csObjSheetsCSV = null;
                            }
                            if (csObjBookCSV != null)
                            {  // オブジェクト有効な場合はＣＯＭ参照カウンタを開放する
                                System.Runtime.InteropServices.Marshal.ReleaseComObject(csObjBookCSV);
                                csObjBookCSV = null;
                            }
                            if (csObjSheet != null)
                            {  // オブジェクト有効な場合はＣＯＭ参照カウンタを開放する
                                System.Runtime.InteropServices.Marshal.ReleaseComObject(csObjSheet);
                                csObjSheet = null;
                            }
                        }
                    }
                    // Excelの保存
                    if (File.Exists(csSaveFileName.ToString()) == true)
                    {  // ファイルが有る場合
                        File.Delete(csSaveFileName.ToString());
                    }
                    csParameters = new Object[1];
                    csParameters[0] = csSaveFileName.ToString();
                    csObjBook.GetType().InvokeMember("SaveAs",
                                       BindingFlags.InvokeMethod, null, csObjBook, csParameters);
                    csParameters = null;
                    // Excelを閉じる
                    csParameters = new Object[1];
                    csParameters[0] = false;
                    csObjBook.GetType().InvokeMember("Close",
                                       BindingFlags.InvokeMethod, null, csObjBook, csParameters);
                    csParameters = null;
                    // Ｅｘｃｅｌ終了
                    csObjApp.GetType().InvokeMember("Quit",
                                       BindingFlags.InvokeMethod, null, csObjApp, null);
                }
                catch
                {  // エラー発生の場合
                    if (csObjApp != null)
                    {  // インスタンスが残っている場合
                        csObjApp.GetType().InvokeMember("Quit",
                                           BindingFlags.InvokeMethod, null, csObjApp, null); // Ｅｘｃｅｌ終了
                    }
                }
                finally
                {  // ＣＯＭ参照カウンタを開放
                    if (csObjSheets != null)
                    {  // オブジェクト有効な場合はＣＯＭ参照カウンタを開放する
                        System.Runtime.InteropServices.Marshal.ReleaseComObject(csObjSheets);
                        csObjSheets = null;
                    }
                    if (csObjBook != null)
                    {  // オブジェクト有効な場合はＣＯＭ参照カウンタを開放する
                        System.Runtime.InteropServices.Marshal.ReleaseComObject(csObjBook);
                        csObjBook = null;
                    }
                    if (csObjBooks != null)
                    {  // オブジェクト有効な場合はＣＯＭ参照カウンタを開放する
                        System.Runtime.InteropServices.Marshal.ReleaseComObject(csObjBooks);
                        csObjBooks = null;
                    }
                    if (csObjApp != null)
                    {  // オブジェクト有効な場合はＣＯＭ参照カウンタを開放する
                        System.Runtime.InteropServices.Marshal.ReleaseComObject(csObjApp);
                        csObjApp = null;
                    }
                }
            }
        }
        /// <summary><para>method outline:</para>
        /// <para>Ｅｘｃｅｌ表示処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>ExcelOutComs_Outdata(csIDList,csStockDataList,csContainer)</para>
        /// </example>
        /// <param name="csIDList">選択データ識別キーリスト</param>
        /// <param name="csStockDataList">格納データリスト</param>
        /// <param name="csContainer">データコンテナ</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void ExcelOutComs_Outdata(ArrayList csIDList, HySStockDataList csStockDataList, HySContainer csContainer)
        {
            HySString csTrue = new HySString("true");
            ArrayList csFileName = new ArrayList();
            ArrayList csIDList_New = new ArrayList();
            HySStockDataList csStockDataList_New = new HySStockDataList();

            for (long lP = 0; lP < csStockDataList.GetCount(); lP++)
            {
                if (((HySString)csIDList[(int)lP]).Equals(csTrue) == true)
                {  // 選択データの場合

                    // 初期化設定
                    csFileName.Clear();
                    csIDList_New.Clear();
                    csStockDataList_New.Clear();

                    // データを1件づつ設定
                    csIDList_New.Add(csIDList[(int)lP]);
                    csStockDataList_New.AddLast(csStockDataList.GetData(lP));

                    // 汎用データＣＳＶ変換
                    this.CreateDataTable(csIDList_New, csStockDataList_New, csContainer, csFileName);
                    string csFileNamePath = HySEnvInf.GetHomeDirectory().ToString() + TIMESREISTMP_PASS;
                    if (File.Exists(csFileNamePath) == true)
                    {  // 時系列データが有る場合
                        csFileName.Add(csFileNamePath.Clone());
                    }
                    csFileNamePath = HySEnvInf.GetHomeDirectory().ToString() + NUMBERTMP_PASS;
                    if (File.Exists(csFileNamePath) == true)
                    {  // 値データが有る場合
                        csFileName.Add(csFileNamePath.Clone());
                    }

                    // データＣＳＶ変換
                    int iSCnt = csFileName.Count;
                    if (iSCnt > 0)
                    {  // ファイルが有る場合
                        // Ｅｘｃｅｌシート編集（遅延バインディングオートメーションでの実装）
                        for (int iLp = 0; iLp < iSCnt; iLp++)
                        {
                            object csObjApp = null;
                            object csObjBook = null;
                            object csObjBooks = null;
                            object csObjSheets = null;
                            object csObjSheet = null;
                            object[] csParameters = null;
                            object csObjBookCSV = null;
                            object csObjSheetsCSV = null;
                            object csObjSheetCSV = null;
                            if (File.Exists((string)csFileName[iLp]) == true)
                            {  // 時系列ＣＳＶが有る場合
                                try
                                {
                                    // Ｅｘｃｅｌクラスインスタンス取得
                                    Type csObjClassType;
                                    csObjClassType = Type.GetTypeFromProgID("Excel.Application");
                                    csObjApp = Activator.CreateInstance(csObjClassType);
                                    // Workbooks枚数設定
                                    csParameters = new Object[1];
                                    csParameters[0] = 1;
                                    csObjApp.GetType().InvokeMember("SheetsInNewWorkBook",
                                                        BindingFlags.SetProperty, null, csObjApp, csParameters);
                                    csParameters = null;
                                    // Workbooksコレクションプロパティ取得
                                    csObjBooks = csObjApp.GetType().InvokeMember("Workbooks",
                                                        BindingFlags.GetProperty, null, csObjApp, null);
                                    // WorkSheetの追加
                                    csObjBook = csObjBooks.GetType().InvokeMember("Add",
                                                    BindingFlags.InvokeMethod, null, csObjBooks, null);
                                    // Worksheetコレクションプロパティ取得
                                    csObjSheets = csObjBook.GetType().InvokeMember("Worksheets",
                                                    BindingFlags.GetProperty, null, csObjBook, null);
                                    try
                                    {
                                        // 先頭のSheetプロパティ取得
                                        csParameters = new Object[1];
                                        csParameters[0] = iSCnt;
                                        csObjSheet = csObjSheets.GetType().InvokeMember("Item",
                                                        BindingFlags.GetProperty, null, csObjSheets, csParameters);
                                        csParameters = null;
                                        // 時系列ＣＳＶファイルを開く
                                        object[] args = { (string)csFileName[iLp] };
                                        csObjBookCSV = csObjBooks.GetType().InvokeMember("Open",
                                                          BindingFlags.InvokeMethod, null, csObjBooks, args);
                                        // Worksheetコレクションプロパティ取得
                                        csObjSheetsCSV = csObjBookCSV.GetType().InvokeMember("Worksheets",
                                                         BindingFlags.GetProperty, null, csObjBookCSV, null);
                                        // 先頭のSheetプロパティ取得
                                        csParameters = new Object[1];
                                        csParameters[0] = 1;
                                        csObjSheetCSV = csObjSheetsCSV.GetType().InvokeMember("Item",
                                                        BindingFlags.GetProperty, null, csObjSheetsCSV, csParameters);
                                        csParameters = null;
                                        // 時系列ＣＳＶの内容を複写する
                                        csParameters = new Object[2];
                                        csParameters[0] = csObjSheet;
                                        csParameters[1] = Missing.Value;
                                        csObjSheetCSV.GetType().InvokeMember("Copy",
                                                        BindingFlags.InvokeMethod, null, csObjSheetCSV, csParameters);
                                        csParameters = null;
                                        // 変更保存確認メッセージの抑止
                                        csParameters = new object[] { false };
                                        csObjApp.GetType().InvokeMember("DisplayAlerts",
                                                        BindingFlags.SetProperty, null, csObjApp, csParameters);
                                        csParameters = null;
                                        // 時系列ＣＳＶファイルを閉じる
                                        csObjBookCSV.GetType().InvokeMember("Close",
                                                 BindingFlags.InvokeMethod, null, csObjBookCSV, args);
                                        // 変更保存確認メッセージの抑止解除
                                        csParameters = new object[] { true };
                                        csObjApp.GetType().InvokeMember("DisplayAlerts",
                                                        BindingFlags.SetProperty, null, csObjApp, csParameters);
                                        csParameters = null;
                                        // Ｅｘｃｅｌの可視化
                                        csParameters = new Object[1];
                                        csParameters[0] = true;
                                        csObjApp.GetType().InvokeMember("Visible",
                                                              BindingFlags.SetProperty, null, csObjApp, csParameters);
                                        // 先頭のSheetプロパティ取得
                                        csParameters = new Object[1];
                                        csParameters[0] = 1;
                                        csObjSheet = csObjSheets.GetType().InvokeMember("Item",
                                                        BindingFlags.GetProperty, null, csObjSheets, csParameters);
                                        // Sheet1をActiveにする
                                        csObjSheet.GetType().InvokeMember("Activate",
                                                              BindingFlags.InvokeMethod, null, csObjSheet, null);
                                        // グラフウイザードの起動
                                        csParameters = new Object[1];
                                        csParameters[0] = "%IH";
                                        csObjApp.GetType().InvokeMember("SendKeys",
                                                              BindingFlags.InvokeMethod, null, csObjApp, csParameters);
                                        csParameters = null;
                                    }
                                    finally
                                    {  // ＣＯＭ参照カウンタを開放
                                        if (csObjSheetCSV != null)
                                        {  // オブジェクト有効な場合はＣＯＭ参照カウンタを開放する
                                            System.Runtime.InteropServices.Marshal.ReleaseComObject(csObjSheetCSV);
                                            csObjSheetCSV = null;
                                        }
                                        if (csObjSheetsCSV != null)
                                        {  // オブジェクト有効な場合はＣＯＭ参照カウンタを開放する
                                            System.Runtime.InteropServices.Marshal.ReleaseComObject(csObjSheetsCSV);
                                            csObjSheetsCSV = null;
                                        }
                                        if (csObjBookCSV != null)
                                        {  // オブジェクト有効な場合はＣＯＭ参照カウンタを開放する
                                            System.Runtime.InteropServices.Marshal.ReleaseComObject(csObjBookCSV);
                                            csObjBookCSV = null;
                                        }
                                        if (csObjSheet != null)
                                        {  // オブジェクト有効な場合はＣＯＭ参照カウンタを開放する
                                            System.Runtime.InteropServices.Marshal.ReleaseComObject(csObjSheet);
                                            csObjSheet = null;
                                        }
                                    }
                                }
                                catch
                                {  // エラー発生の場合
                                    if (csObjApp != null)
                                    {  // インスタンスが残っている場合
                                        csObjApp.GetType().InvokeMember("Quit",
                                                           BindingFlags.InvokeMethod, null, csObjApp, null); // Ｅｘｃｅｌ終了
                                    }
                                }
                                finally
                                {  // ＣＯＭ参照カウンタを開放
                                    if (csObjSheets != null)
                                    {  // オブジェクト有効な場合はＣＯＭ参照カウンタを開放する
                                        System.Runtime.InteropServices.Marshal.ReleaseComObject(csObjSheets);
                                        csObjSheets = null;
                                    }
                                    if (csObjBook != null)
                                    {  // オブジェクト有効な場合はＣＯＭ参照カウンタを開放する
                                        System.Runtime.InteropServices.Marshal.ReleaseComObject(csObjBook);
                                        csObjBook = null;
                                    }
                                    if (csObjBooks != null)
                                    {  // オブジェクト有効な場合はＣＯＭ参照カウンタを開放する
                                        System.Runtime.InteropServices.Marshal.ReleaseComObject(csObjBooks);
                                        csObjBooks = null;
                                    }
                                    if (csObjApp != null)
                                    {  // オブジェクト有効な場合はＣＯＭ参照カウンタを開放する
                                        System.Runtime.InteropServices.Marshal.ReleaseComObject(csObjApp);
                                        csObjApp = null;
                                    }
                                }
                            }
                        }
                    }
                }
            }
            // スタック解放
            csStockDataList_New = null;
            csIDList_New = null;
            csFileName = null;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>表示対象データ生成処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>CreateDataTable(csIDList,csStockDataList,csContainer,csFileName)</para>
        /// </example>
        /// <param name="csIDList">選択データ識別キーリスト</param>
        /// <param name="csStockDataList">格納データリスト</param>
        /// <param name="csContainer">データコンテナ</param>
        /// <param name="csFileName">ＣＳＶファイル名称</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void CreateDataTable(ArrayList csIDList,HySStockDataList csStockDataList, HySContainer csContainer, ArrayList csFileName)
        {
            // 初期化
            HySString csTrue = new HySString("true");
            int iLp1 = 0;
            int iLp2 = 0;
            int iRow = 0;
            int iColumn = 0;
            DataRow csRows = null;
            String csTimeKey = "";
            DataRow[] csSelectedRows = null;
            DataTable csEditionDataTable = null;           // データテーブル管理生成
            DataTable csTimeDataTable = new DataTable();   // 時系列データテーブル管理生成
            Hashtable csTimeDataKeys = new Hashtable();    // 時系列データテーブルキー情報生成
            DataTable csNumberDataTable = new DataTable(); // 定常データテーブル管理生成
            Hashtable csNumberDataKeys = new Hashtable();  // 定常データテーブルキー情報生成

            // ＣＳＶファイル削除
            string csFileNamePath = HySEnvInf.GetHomeDirectory().ToString() + TIMESREISTMP_PASS;
            if (File.Exists(csFileNamePath) == true)
            {  // ファイルが有る場合
                try
                {
                    File.Delete(csFileNamePath);
                }
                catch
                {
                    // ver1.5 エラートレース日本語対応
                    string DispStatement = Properties.HysMsgResources.STATEMENT_FILE_USING + "("
                        + csFileNamePath + "）";

                    HySLog.LogOut(HySLog.ONLINE, "HySMSExcelScreen", DispStatement );
                   // HySLog.LogOut(HySLog.ONLINE, "HySMSExcelScreen", "ファイルが使用中です（" + csFileNamePath + "）");
                    return;
                }
            }
            csFileNamePath = HySEnvInf.GetHomeDirectory().ToString() + NUMBERTMP_PASS;
            if (File.Exists(csFileNamePath) == true)
            {  // ファイルが有る場合
                try
                {
                    File.Delete(csFileNamePath);
                }
                catch
                {
                    // ver1.5 エラートレース日本語対応
                    string DispStatement = Properties.HysMsgResources.STATEMENT_FILE_USING + "("
                        + csFileNamePath + "）";

                    HySLog.LogOut(HySLog.ONLINE, "HySMSExcelScreen", DispStatement );
                   // HySLog.LogOut(HySLog.ONLINE, "HySMSExcelScreen", "ファイルが使用中です（" + csFileNamePath + "）");
                    return;
                }
            }
            if (csStockDataList is HySStockDataList)
            {  // データ保存クラスリストが有る場合
                long lCnt = csStockDataList.GetCount();
                csStockDataList.SetCursorFirst();
                for (iLp1 = 0; iLp1 < (int)lCnt; iLp1++)
                {  // リスト数分繰り返す
                    m_csStockData = csStockDataList.GetCursorData() as HySStockData;
                    if (m_csStockData is HySStockData)
                    {  // データ保存クラスの場合
                        if (csIDList is ArrayList)
                        {  // 選択データ識別キーリストが有る場合
                            if (((HySString)csIDList[iLp1]).Equal(csTrue) == true)
                            {  // 対象データの場合
                                if (m_csStockData.GetDataKind().Equals(HySDispDefine.STOCKDATA_KIND_EXTERNAL) == true)
                                {  // 外部データの場合
                                    if (m_csStockData.GetSaveName().GetLength() > 0)
                                    {  // ファイル名称が有る場合
                                        csFileName.Add(m_csStockData.GetSaveName().ToString());
                                    }
                                }
                                else
                                {
                                    HySDispCell1DataDevelopment csConvReportData = new HySDispCell1DataDevelopment(); // セルデータ変換クラス生成
                                    HySDataLinkedList csCellList = csConvReportData.CellDataConversion
                                                              (this.GetViewKind(), m_csStockData, null); // セルデータ変換
                                    if (csCellList is HySDataLinkedList)
                                    {  // セル展開データが有効な場合
                                        for (long lLp = 0; lLp < csCellList.GetCount(); lLp++)
                                        {  // 展開件数繰り返す
                                            HySDataRoot csDataRoot = csCellList.GetData(lLp);
                                            if (csDataRoot is HySGraphLineTimeSeries)
                                            {  // 時系列グラフデータの場合
                                                HySGraphLineTimeSeries csGraphLineTimeSeries = (HySGraphLineTimeSeries)csDataRoot;
                                                HySObjectKind csDataKind = csGraphLineTimeSeries.GetDataMeaning();
                                                if (csDataKind is HySObjectKind)
                                                {  // データの種別が有る場合
                                                    if (csTimeDataTable.Columns.Count <= 0)
                                                    {  // 初回設定の場合
                                                        csTimeDataTable.Columns.Add(TIME_ITEM_HEAD, typeof(DateTime)); // 時刻列追加
                                                    }
                                                    iColumn = csTimeDataTable.Columns.Count; // データ列数取得
                                                    csTimeDataTable.Columns.Add(DATA_ITEM_HEAD + iColumn.ToString(), typeof(double)); // データ列追加
                                                    long lDataCnt = csGraphLineTimeSeries.GetCount(); // データ件数取得
                                                    csGraphLineTimeSeries.SetCursorFirst(); // カーソル先頭
                                                    double dDt = new double();
                                                    for (iLp2 = 0; iLp2 < lDataCnt; iLp2++)
                                                    {  // データ件数分繰り返す
                                                        HySTime csTime = csGraphLineTimeSeries.GetCursorTime(); // 時刻取得
                                                        dDt = csGraphLineTimeSeries.GetCursorData(); // データ取得
                                                        csTimeKey = csTime.GetTime().ToString();     // ハッシュキー生成
                                                        iRow = 0;
                                                        if (csTimeDataKeys[csTimeKey] is int)
                                                        {  // 該当ハッシュキーの行が有る場合
                                                            iRow = (int)csTimeDataKeys[csTimeKey];   // 行番号取得
                                                        }
                                                        if (iRow > 0)
                                                        {  // 既存時系行が有る場合
                                                            csTimeDataTable.Rows[iRow - 1][DATA_ITEM_HEAD + iColumn.ToString()] = dDt; // データ追加
                                                        }
                                                        else
                                                        {  // 既存時系列行が無い場合
                                                            csRows = csTimeDataTable.NewRow();  // 行生成
                                                            csRows[TIME_ITEM_HEAD] = DateTime.Parse(HySCalendar.GetString(csTime, HySCalendar.FORMAT.lSW_YEAR).ToString()); // 時刻設定
                                                            csRows[DATA_ITEM_HEAD + iColumn.ToString()] = dDt; // データ設定
                                                            csTimeDataTable.Rows.Add(csRows);   // 行追加
                                                            iRow = csTimeDataTable.Rows.Count;
                                                            csTimeDataKeys[csTimeKey] = iRow;   // 挿入位置記憶
                                                        }
                                                        csGraphLineTimeSeries.MoveCursorNext(); // 次へ
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                    csStockDataList.MoveCursorNext(); // 次へ
                }

                // 検索データＣＳＶ出力
                if (csTimeDataTable.Rows.Count > 0)
                {  // 時系列編集データが有る場合はソートする
                    csSelectedRows = csTimeDataTable.Select("", TIME_ITEM_HEAD);
                    csEditionDataTable = csTimeDataTable.Clone();
                    for (iLp1 = 0; iLp1 < csTimeDataTable.Rows.Count; iLp1++)
                    {
                        csEditionDataTable.ImportRow(csSelectedRows[iLp1]);
                    }
                    this.CSVOutPut(csEditionDataTable, TIMESREISTMP_PASS);
                    csEditionDataTable = null;
                }
                if (csNumberDataTable.Rows.Count > 0)
                {  // 時系列編集データが有る場合はソートする
                    csSelectedRows = csNumberDataTable.Select("", XAXIS_ITEM_HEAD);
                    csEditionDataTable = csNumberDataTable.Clone();
                    for (iLp1 = 0; iLp1 < csNumberDataTable.Rows.Count; iLp1++)
                    {
                        csEditionDataTable.ImportRow(csSelectedRows[iLp1]);
                    }
                    this.CSVOutPut(csEditionDataTable, NUMBERTMP_PASS);
                    csEditionDataTable = null;
                }
            }
            // エリア解放
            csTimeDataKeys = null;
            csTimeDataTable = null;
            csNumberDataKeys = null;
            csNumberDataTable = null;
        }
        /// <summary><para>method outline:</para>
        /// <para>ＣＳＶ出力</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>CSVOutPut(csDataTable,sFileName)</para>
        /// </example>
        /// <param name="csDataTable">選択データテーブル</param>
        /// <param name="sFileName">ＣＳＶファイル名パス</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void CSVOutPut(DataTable csDataTable, string sFileName)
        {
            int iLp = 0;
            int iColCount = csDataTable.Columns.Count;
            int iLastColIndex = iColCount - 1;
            string sOut = "";

            string csFileNamePath = HySEnvInf.GetHomeDirectory().ToString() + sFileName; //保存先のCSVファイルのパス生成
            HySFile csOutFile = new HySFile(csFileNamePath); // ファイル新規作成
            if (csOutFile != null)
            {  // ファイルインスタンス生成が正常な場合
                if (csOutFile.Open(HySFile.OPEN_MODE.CREATE_NEW, HySFile.READ_WRITE_MODE.WRITE, HySFile.DIRECTORY_MODE.MK_DIR) == 0)
                {  // 正常にファイルオープンできた場合
                    for (iLp = 0; iLp < iColCount; iLp++)
                    {  // 列数分繰り返す
                        string sField = csDataTable.Columns[iLp].Caption; //ヘッダの取得
                        if (sField.IndexOf('"') > -1 || sField.IndexOf(',') > -1 ||
                            sField.IndexOf('\r') > -1 || sField.IndexOf('\n') > -1 ||
                            sField.StartsWith(" ") || sField.StartsWith("\t") ||
                            sField.EndsWith(" ") || sField.EndsWith("\t"))
                        {  // コード変換要の場合
                            if (sField.IndexOf('"') > -1)
                            {  // "の変更の場合
                                sField = sField.Replace("\"", "\"\"");
                            }
                            sField = "\"" + sField + "\"";
                        }
                        //フィールドを書き込む
                        sOut += sField;
                        //カンマを書き込む
                        if (iLastColIndex > iLp)
                        {
                            sOut += ",";
                        }
                    }
                    csOutFile.WriteText(sOut); // １行書込む
                    sOut = "";
                    //レコード生成
                    foreach (DataRow csRow in csDataTable.Rows)
                    {
                        for (iLp = 0; iLp < iColCount; iLp++)
                        {  // 列数分繰り返す
                            string sField = csRow[iLp].ToString(); // 列取得
                            if (sField.IndexOf('"') > -1 || sField.IndexOf(',') > -1 ||
                                sField.IndexOf('\r') > -1 || sField.IndexOf('\n') > -1 ||
                                sField.StartsWith(" ") || sField.StartsWith("\t") ||
                                sField.EndsWith(" ") || sField.EndsWith("\t"))
                            {  // コード変換要の場合
                                if (sField.IndexOf('"') > -1)
                                {  // "の変更の場合
                                    sField = sField.Replace("\"", "\"\"");
                                }
                                sField = "\"" + sField + "\"";
                            }
                            //フィールドを書き込む
                            sOut += sField;
                            //カンマを書き込む
                            if (iLastColIndex > iLp)
                            {
                                sOut += ",";
                            }
                        }
                        csOutFile.WriteText(sOut); // １行書込む
                        sOut = "";
                    }
                    csOutFile.Close(); //閉じる
                }
            }
        }
        /// <summary><para>method outline:</para>
        /// <para>引き渡された画像を挿入したＥｘｃｅｌシートの新規作成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> ExcelImegePut(csImageFile,csExcelFile ) </para>
        /// </example>
        /// <param name="csImageFile">画像ファイルフルパス名</param>
        /// <param name="csExcelFile">Excelファイルフルパス名</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void ExcelImegePut(HySString csImageFile, HySString csExcelFile)
        {
            string csFileNamePath1 = csImageFile.ToString();
            string csFileNamePath2 = csExcelFile.ToString();
            if (File.Exists(csFileNamePath1) == true)
            {  // Imageファイルが有る場合
                // Ｅｘｃｅｌシート編集（遅延バインディングオートメーションでの実装）
                object csObjApp = null;
                object csObjBook = null;
                object csObjBooks = null;
                object csObjSheets = null;
                object csObjSheet = null;
                object csObjShapes = null;
                object csObjShape = null;
                object[] csParameters = null;
                try
                {
                    // Ｅｘｃｅｌクラスインスタンス取得
                    Type csObjClassType;
                    csObjClassType = Type.GetTypeFromProgID("Excel.Application");
                    csObjApp = Activator.CreateInstance(csObjClassType);
                    // Workbooks枚数設定
                    csParameters = new Object[1];
                    csParameters[0] = 1;
                    csObjApp.GetType().InvokeMember("SheetsInNewWorkBook",
                                        BindingFlags.SetProperty, null, csObjApp, csParameters);
                    csParameters = null;
                    // Workbooksコレクションプロパティ取得
                    csObjBooks = csObjApp.GetType().InvokeMember("Workbooks",
                                        BindingFlags.GetProperty, null, csObjApp, null);
                    // Excelシート新規作成
                    csObjBook = csObjBooks.GetType().InvokeMember("Add",
                                      BindingFlags.InvokeMethod, null, csObjBooks, null);
                    // Worksheetコレクションプロパティ取得
                    csObjSheets = csObjBook.GetType().InvokeMember("Worksheets",
                                    BindingFlags.GetProperty, null, csObjBook, null);
                    // 先頭のSheetプロパティ取得
                    csParameters = new Object[1];
                    csParameters[0] = 1;
                    csObjSheet = csObjSheets.GetType().InvokeMember("Item",
                                    BindingFlags.GetProperty, null, csObjSheets, csParameters);
                    csParameters = null;
                    // 図形シートプロパティ取得
                    csObjShapes = csObjSheet.GetType().InvokeMember("Shapes",
                                    BindingFlags.GetProperty, null, csObjSheet, null);
                    // 画像を挿入する
                    csParameters = new Object[7];
                    csParameters[0] = csFileNamePath1.ToString();
                    csParameters[1] = false;
                    csParameters[2] = true;
                    csParameters[3] = 0;
                    csParameters[4] = 0;
                    csParameters[5] = 665;
                    csParameters[6] = 454;
                    csObjShape = csObjShapes.GetType().InvokeMember("AddPicture",
                                    BindingFlags.InvokeMethod, null, csObjShapes, csParameters);
                    csParameters = null;
                    // 先頭のSheet名の変更
                    csParameters = new Object[1];
                    csParameters[0] = "シート1";
                    csObjSheet.GetType().InvokeMember("Name",
                                    BindingFlags.SetProperty, null, csObjSheet, csParameters);
                    csParameters = null;
                    // Excelの保存
                    if (File.Exists(csFileNamePath2.ToString()) == true)
                    {  // ファイルが有る場合
                        File.Delete(csFileNamePath2.ToString());
                    }
                    csParameters = new Object[1];
                    csParameters[0] = csFileNamePath2.ToString();
                    csObjBook.GetType().InvokeMember("SaveAs",
                                       BindingFlags.InvokeMethod, null, csObjBook, csParameters);
                    csParameters = null;
                    // Excelを閉じる
                    csParameters = new Object[1];
                    csParameters[0] = false;
                    csObjBook.GetType().InvokeMember("Close",
                                       BindingFlags.InvokeMethod, null, csObjBook, csParameters);
                    csParameters = null;
                    // Ｅｘｃｅｌ終了
                    csObjApp.GetType().InvokeMember("Quit",
                                       BindingFlags.InvokeMethod, null, csObjApp, null);
                }
                catch
                {  // エラー発生の場合
                    if (csObjApp != null)
                    {  // インスタンスが残っている場合
                        csObjApp.GetType().InvokeMember("Quit",
                                           BindingFlags.InvokeMethod, null, csObjApp, null); // Ｅｘｃｅｌ終了
                    }
                }
                finally
                {  // ＣＯＭ参照カウンタを開放
                    if (csObjShape != null)
                    {  // オブジェクト有効な場合はＣＯＭ参照カウンタを開放する
                        System.Runtime.InteropServices.Marshal.ReleaseComObject(csObjShape);
                        csObjShape = null;
                    }
                    if (csObjShapes != null)
                    {  // オブジェクト有効な場合はＣＯＭ参照カウンタを開放する
                        System.Runtime.InteropServices.Marshal.ReleaseComObject(csObjShapes);
                        csObjShapes = null;
                    }
                    if (csObjSheet != null)
                    {  // オブジェクト有効な場合はＣＯＭ参照カウンタを開放する
                        System.Runtime.InteropServices.Marshal.ReleaseComObject(csObjSheet);
                        csObjSheet = null;
                    }
                    if (csObjSheets != null)
                    {  // オブジェクト有効な場合はＣＯＭ参照カウンタを開放する
                        System.Runtime.InteropServices.Marshal.ReleaseComObject(csObjSheets);
                        csObjSheets = null;
                    }
                    if (csObjBook != null)
                    {  // オブジェクト有効な場合はＣＯＭ参照カウンタを開放する
                        System.Runtime.InteropServices.Marshal.ReleaseComObject(csObjBook);
                        csObjBook = null;
                    }
                    if (csObjBooks != null)
                    {  // オブジェクト有効な場合はＣＯＭ参照カウンタを開放する
                        System.Runtime.InteropServices.Marshal.ReleaseComObject(csObjBooks);
                        csObjBooks = null;
                    }
                    if (csObjApp != null)
                    {  // オブジェクト有効な場合はＣＯＭ参照カウンタを開放する
                        System.Runtime.InteropServices.Marshal.ReleaseComObject(csObjApp);
                        csObjApp = null;
                    }
                }
            }
        }
    }
}
