﻿// <summary>ソースコード：計算結果モニタースクリーン</summary>
// <author>CommonMP</author>

using System;
using System.Collections;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.Interface.HSViewer;
using CommonMP.HYSSOP.Interface.HSData;

using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSBusiProc;

namespace CommonMP.HYSSOP.CoreImpl.HSViewer
{
    /// <summary><para>class outline:</para>
    /// <para>計算結果モニタースクリーン</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2009/05/01][新規作成]</para>
    /// </remarks>
    public class HySMoniterScreen : HySScreenBase
    {
        //--------------------------------
        // モデル毎画面種別定数
        //--------------------------------
        /// <summary>ポイント時系列汎用グラフ互換識別子</summary>
        public static readonly HySID LINE_GRAPH_SINGLE_CELL_ANY = new HySID("ANY");
        /// <summary>ポイント時系列汎用グラフ識別子</summary>
        public static readonly HySID LINE_GRAPH_SINGLE_CELL_SERIAL = new HySID("TimeSeriesSingleCellLineGraph" + HySDefine.DISP_FORM_MONITER.ToString());
        /// <summary>1次元配列時系列汎用グラフ識別子</summary>
        public static readonly HySID LINE_GRAPH_D1_CELL_SERIAL = new HySID("TimeSeriesD1CellLineGraph" + HySDefine.DISP_FORM_MONITER.ToString());
        /// <summary>ポイント時系列ハイエトグラフ識別子(雨量)</summary>
        public static readonly HySID HYETO_GRAPH_RAIN_SERIAL = new HySID("TimeSeriesSingleRainCellHyetoGraph" + HySDefine.DISP_FORM_MONITER.ToString());
        /// <summary>ポイント時系列ハイエトグラフ識別子(流量)</summary>
        public static readonly HySID HYETO_GRAPH_SINGLE_CELL_SERIAL = new HySID("TimeSeriesSingleCellHyetoGraph" + HySDefine.DISP_FORM_MONITER.ToString());
        /// <summary>1次元配列時系列ハイエトグラフ識別子(流量)</summary>
        public static readonly HySID HYETO_GRAPH_D1_CELL_SERIAL = new HySID("TimeSeriesD1CellHyetoGraph" + HySDefine.DISP_FORM_MONITER.ToString());
        /// <summary>ポイント時系列縦断データグラフ識別子</summary>
        public static readonly HySID RIVERBED_SHAPE_SINGLE_CELL_SERIAL = new HySID("TimeSeriesSingleCellRiverbedShape" + HySDefine.DISP_FORM_MONITER.ToString());
        /// <summary>１次元配列時系列縦断データグラフ識別子</summary>
        public static readonly HySID RIVERBED_SHAPE_D1_CELL_SERIAL = new HySID("TimeSeriesD1CellRiverbedShape" + HySDefine.DISP_FORM_MONITER.ToString());

        //---------------------------------------
        // 対象メンバ定義
        //---------------------------------------
        /// <summary>対応する表示フォーム</summary>
        HySMoniterFormIF m_csForm = null;
        /// <summary>一時保管表示フォーム</summary>
        HySMoniterFormIF m_csForm_Hold = null;

        /// <summary>対応する表示フォーム管理テーブル</summary>
        Hashtable m_csFormTbl = null;

        /// <summary>データコンテナ</summary>
        protected HySContainer m_csContainer = null;

        /// <summary>表示業務管理データ</summary>
        protected HySDispBusiProcedureCtlInfo m_csDBPCtlInfo = null;

        /// <summary><para>method outline:</para>
        /// <para>ビュー種別取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySKind csKind = GetViewKind()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySKind ビュー種別</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override HySKind GetViewKind()
        {
            return HySDefine.DISP_FORM_MONITER;
        }

        /// <summary><para>method outline:</para>
        /// <para>ビュー種別比較</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bRtn = EqualViewKind(csViewKindID)</para>
        /// </example>
        /// <param name="csViewKindID">ビュー種別</param>
        /// <returns>Boolean true:同じ、false:異なる</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override Boolean EqualViewKind(HySKind csViewKindID)
        {
            return HySDefine.DISP_FORM_MONITER.Equals(csViewKindID);
        }

        /// <summary><para>method outline:</para>
        /// <para>初期処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>Initialize()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void Initialize()
        {
            if (m_csForm != null)
            { // 画面が有効な場合
                m_csForm.SetScreen(this); // スクリーン設定
                m_csForm.Initialize(); // 画面の初期化
            }
        }
        /// <summary><para>method outline:</para>
        /// <para>初期処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>Initialize(csElementID)</para>
        /// </example>
        /// <param name="csElementID">要素ＩＤ</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void Initialize(HySID csElementID)
        {
            if (m_csFormTbl is Hashtable)
            {  // Form管理情報が有効な場合
                string csKey = csElementID.ToString();
                if (m_csFormTbl[csKey] != null)
                {  // 画面が有効な場合
                    ((HySMoniterFormIF)m_csFormTbl[csKey]).SetScreen(this); // スクリーン設定
                    ((HySMoniterFormIF)m_csFormTbl[csKey]).Initialize(); // 画面の初期化
                }
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>終了処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>Terminate()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void Terminate()
        {
            if (m_csForm != null)
            { // 画面が有効な場合
                if (m_csFormTbl is Hashtable)
                {  // Form管理情報が有効な場合
                    try
                    {
                        if (m_csFormTbl.Count > 0)
                        {  // Formが有る場合
                            foreach (string csKey in m_csFormTbl.Keys)
                            {  // ハッシュテーブル件数繰り返す
                                ((HySMoniterFormIF)m_csFormTbl[csKey]).Terminate();
                            }
                        }
                        m_csForm.Terminate();
                    }
                    catch
                    {
                    }
                }
            }
            m_csFormTbl = null;
        }

        /// <summary><para>method outline:</para>
        /// <para>画面表示</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> ShowScreen( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void ShowScreen()
        {
        }
        /// <summary><para>method outline:</para>
        /// <para>画面表示</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> ShowScreen(csElementID) </para>
        /// </example>
        /// <param name="csElementID">要素ＩＤ</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void ShowScreen(HySID csElementID)
        {
            if (m_csFormTbl is Hashtable)
            {  // Form管理情報が有効な場合
                string csKey = csElementID.ToString();
                if (m_csFormTbl[csKey] != null)
                {  // 画面が有効な場合
                    ((HySMoniterFormIF)m_csFormTbl[csKey]).Show();
                }
                csKey = null;
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>画面非表示化</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HideScreen( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void HideScreen()
        {
            if (m_csForm != null)
            {  // 画面が有効な場合
                if (m_csFormTbl is Hashtable)
                {  // Form管理情報が有効な場合
                    if (m_csFormTbl.Count > 0)
                    {  // Formが有る場合
                        try
                        {
                            foreach (string csKey in m_csFormTbl.Keys)
                            {  // ハッシュテーブル件数繰り返す
                                ((HySMoniterFormIF)m_csFormTbl[csKey]).Hide();
                            }
                        }
                        catch
                        {
                        }
                    }
                }
            }
        }
        /// <summary><para>method outline:</para>
        /// <para>画面非表示化</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HideScreen(csElementID) </para>
        /// </example>
        /// <param name="csElementID">要素ＩＤ</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void HideScreen(HySID csElementID)
        {
            if (m_csFormTbl is Hashtable)
            {  // Form管理情報が有効な場合
                string csKey = csElementID.ToString();
                if (m_csFormTbl[csKey] != null)
                {  // 画面が有効な場合
                    ((HySMoniterFormIF)m_csFormTbl[csKey]).Hide();
                }
                csKey = null;
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>画面更新</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> RenewScreen( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void RenewScreen()
        {
            if (m_csForm != null)
            {  // 画面が有効な場合
                if (m_csFormTbl is Hashtable)
                {  // Form管理情報が有効な場合
                    if (m_csFormTbl.Count > 0)
                    {  // Formが有る場合
                        try
                        {
                            foreach (string csKey in m_csFormTbl.Keys)
                            {  // ハッシュテーブル件数繰り返す
                                ((HySMoniterFormIF)m_csFormTbl[csKey]).Renew();
                            }
                        }
                        catch
                        {
                        }
                    }
                }
            }
        }
        /// <summary><para>method outline:</para>
        /// <para>画面更新</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> RenewScreen(csElementID) </para>
        /// </example>
        /// <param name="csElementID">要素ＩＤ</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void RenewScreen(HySID csElementID)
        {
            if (m_csFormTbl is Hashtable)
            {  // Form管理情報が有効な場合
                string csKey = csElementID.ToString();
                if (m_csFormTbl[csKey] != null)
                {  // 画面が有効な場合
                    ((HySMoniterFormIF)m_csFormTbl[csKey]).Renew();
                }
                csKey = null;
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>画面消去</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> CloseScreen( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void CloseScreen()
        {
            if (m_csForm != null)
            {  // 画面が有効な場合
                if (m_csFormTbl is Hashtable)
                {  // Form管理情報が有効な場合
                    if (m_csFormTbl.Count > 0)
                    {  // Formが有る場合
                        try
                        {
                            foreach (string csKey in m_csFormTbl.Keys)
                            {  // ハッシュテーブル件数繰り返す
                                HySKind csFromSimKind = ((HySMoniterFormIF)m_csFormTbl[csKey]).GetFromSimKind();
                                HySID csToID = ((HySMoniterFormIF)m_csFormTbl[csKey]).GetID() as HySID;
                                ((HySMoniterFormIF)m_csFormTbl[csKey]).Close();
                                PutScreenCloseNotification(csFromSimKind, csToID);
                            }
                            m_csFormTbl.Clear();
                        }
                        catch
                        {
                        }
                    }
                }
            }
        }
        /// <summary><para>method outline:</para>
        /// <para>画面消去</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> CloseScreen(csElementID) </para>
        /// </example>
        /// <param name="csElementID">要素ＩＤ</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void CloseScreen(HySID csElementID)
        {
            if (m_csFormTbl is Hashtable)
            {  // Form管理情報が有効な場合
                string csKey = csElementID.ToString();
                if (m_csFormTbl[csKey] != null)
                {  // 画面が有効な場合
                    HySKind csFromSimKind = ((HySMoniterFormIF)m_csFormTbl[csKey]).GetFromSimKind();
                    HySID csToID = ((HySMoniterFormIF)m_csFormTbl[csKey]).GetID() as HySID;
                    ((HySMoniterFormIF)m_csFormTbl[csKey]).Close();
                    PutScreenCloseNotification(csFromSimKind, csToID);
                    m_csFormTbl.Remove(csKey);
                }
                csKey = null;
            }
        }
        /// <summary><para>method outline:</para>
        /// <para>画面消去完了イベント送信</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> PutScreenCloseNotification(csFromSimKind,cElementID) </para>
        /// </example>
        /// <param name="csFromSimKind">送り元シミュレーター種別識別子</param>
        /// <param name="csElementID">要素ＩＤ</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void PutScreenCloseNotification(HySKind csFromSimKind, HySID csElementID)
        {
            // 画面消去完了イベント送信
            HySEventObject csEventObj = new HySEventObject(HySSysEvent.OBJID_VIEWER, HySEventObject.NOTICE_DISPLY_OK);
            csEventObj.SetFromSimKind(HySDefine.COMMON_DISP_BUSIPROCEDURE);
            csEventObj.SetToSimKind(csFromSimKind);
            csEventObj.SetSuppID(csElementID);
            csEventObj.SetSubEventNo(HySDispDefine.NOTICE_SCREEN_CLOSE);
            this.PutEvent(csEventObj);
        }

        /// <summary><para>method outline:</para>
        /// <para>画面初期配置表示</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> InitiateScreen( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void InitiateScreen()
        {
            if (m_csForm != null)
            {  // 画面が有効な場合
                if (m_csFormTbl is Hashtable)
                {  // Form管理情報が有効な場合
                    if (m_csFormTbl.Count > 0)
                    {  // Formが有る場合
                        try
                        {
                            foreach (string csKey in m_csFormTbl.Keys)
                            {  // ハッシュテーブル件数繰り返す
                                ((HySMoniterFormIF)m_csFormTbl[csKey]).InitiateScreen();
                            }
                        }
                        catch
                        {
                        }
                    }
                }
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>イベントを受け取った時に動作するメソッド</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bRtn = EventCallback( csEvent ) </para>
        /// </example>
        /// <param name="csEvent">送られたイベント</param>
        /// <returns>Boolean true:=正常, false:=異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>各実装クラスは受け取ったイベント毎に処理を行う</para>
        /// </remarks>
        public override Boolean EventCallback(HySSysEvent csEvent)
        {
            Boolean bRtn = true;

            HySEventObject csHySEvent = (HySEventObject)csEvent;
            long lEventNo = csHySEvent.GetEventNo();
            HySID csID = csHySEvent.GetSuppID();
            HySObjectKind csSimKind = (HySObjectKind)csHySEvent.GetToSimKind();
            HySID csResponseInfoID = (HySID)csHySEvent.GetResponseInfo(); // 要素ＩＤ
            long lEventSubNo = csHySEvent.GetSubEventNo();

            if (lEventNo == HySEventObject.CMND_DISP_SCREEN)
            {  // 画面表示指示の場合
                m_csContainer = ((HySEventObject)csEvent).GetSubData() as HySContainer; // データコンテナ取得
                if (m_csContainer is HySDataContainer)
                {  // データコンテナが有る場合
                    m_csDBPCtlInfo = m_csContainer.GetData(HySDispDefine.DISPCTL_INFO_KEYS) as HySDispBusiProcedureCtlInfo;
                }
            }
            else if (lEventNo == HySEventObject.CMND_DISPLY_COMMON)
            {  // 画面への指示／応答の場合
                if (lEventSubNo == HySDispDefine.NOTICE_FROM_DISPLAY)
                {  // 子画面表示指示の場合
                    if (csResponseInfoID is HySID)
                    {  // 要素ＩＤが有る場合
                        if (m_csFormTbl[csResponseInfoID.ToString()] == null)
                        {  // 画面フォームが無い場合
                            HySMoniterFormIF csForm = null;
                            if (m_csForm_Hold is HySMoniterFormIF)
                            {  // 一時保管フォームが有る場合
                                csForm = m_csForm_Hold; // 一時保管フォーム設定
                                m_csForm_Hold = null;   // 初期化
                                csForm.SetFormNumber(this.GetFormNumber());          // フォーム一貫番号設定
                            }
                            else
                            {  // 一時保管フォームが無い場合
                                csForm = (HySMoniterFormIF)m_csForm.Clone(); // 標準画面フォーム設定
                            }
                            csForm.SetID(csResponseInfoID);                          // 要素ＩＤ設定
                            csForm.SetFromSimKind((HySKind)csHySEvent.GetSubData()); // 送り元シミュレータ識別子設定
                            m_csFormTbl.Add(csResponseInfoID.ToString(), csForm);    // 管理テーブル登録
                            this.Initialize(csResponseInfoID);                       // 画面初期化
                            csForm.SetDispResultData(m_csContainer);                 // データコンテナの設定
                        }
                        this.ShowScreen(csResponseInfoID); // 画面可視化
                    }
                    else
                    {  // 全フォームの可視化
                        this.ShowScreen();
                    }
                }
                else if (lEventSubNo == HySDispDefine.NOTICE_SCREEN_HIDE)
                {  // 子画面表示指示の場合
                    if (csResponseInfoID is HySID)
                    {  // 要素ＩＤが有る場合
                        if (m_csFormTbl[csResponseInfoID.ToString()] is HySMoniterFormIF)
                        {  // 画面フォームが有る場合
                            this.HideScreen(csResponseInfoID); // 画面不可視化
                        }
                    }
                    else
                    {  // 全フォームの不可視化
                        this.HideScreen();
                    }
                }
                else if (lEventSubNo == HySDispDefine.NOTICE_SCREEN_CLOSE)
                {  // 子画面クローズの場合
                    if (csResponseInfoID is HySID)
                    {  // 要素ＩＤが有る場合
                        if (csResponseInfoID.ToString().Length > 0)
                        {  // 要素ＩＤの指定が有る場合
                            if (m_csFormTbl[csResponseInfoID.ToString()] is HySMoniterFormIF)
                            {  // 画面フォームが有る場合
                                this.CloseScreen(csResponseInfoID); // 画面クローズ
                            }
                        }
                        else
                        {  // 全フォームのクローズ
                            this.CloseScreen();
                        }
                    }
                    else
                    {  // 全フォームのクローズ
                        this.CloseScreen();
                    }
                }
                else if (lEventSubNo == HySDispDefine.NOTICE_ACTIVE_EVENT)
                {  // アクティブイベントの場合
                    if (m_csID.Equals(csID) == true)
                    {  // 全フォームの可視化
                        if (csResponseInfoID is HySIdentifier)
                        {
                            this.ShowScreen(csResponseInfoID); // 画面可視化
                        }
                        else
                        {
                            this.RenewScreen();
                        }
                    }
                    else
                    {  // 全フォームの不可視化
                        this.HideScreen();
                    }
                }
                else if (lEventSubNo == HySDispDefine.NOTICE_MODEL_CLOSE)
                {  // モデル画面クローズイベントの場合
                    if (m_csID.Equals(csID) == true)
                    {  // 演算シミュレータ識別子が一致した場合
                        this.CloseScreen(); // 全フォームのクローズ
                        m_csForm.Close();   // 親フォームのクローズ
                        m_csFormTbl = null; // 対応する表示フォーム管理テーブル解放
                        // ビューアショブにスクリーン削除を依頼
                        HySEventObject csEventObj = new HySEventObject(HySSysEvent.OBJID_VIEWER, HySEventObject.CMND_CLOSE_SCREEN);
                        csEventObj.SetToSimKind(m_csSimKindID);
                        csEventObj.SetSuppID(m_csID);
                        csEventObj.SetData(this.GetViewKind());
                        csEventObj.SetSubEventNo(HySDispDefine.NOTICE_SCREEN_CLOSE);
                        this.PutEvent(csEventObj);
                    }
                }
                else if (m_csForm != null)
                {  // 画面が有効な場合
                    bRtn = m_csForm.EventCallback(csEvent);
                }
            }
            else if (lEventNo == HySEventObject.CMND_CLOSE_SCREEN)
            {  // モニタスクリーンクローズ指示の場合
                this.CloseScreen(); // 全フォームのクローズ
                m_csForm.Close();   // 親フォームのクローズ
                m_csFormTbl = null; // 対応する表示フォーム管理テーブル解放
                // ビューアショブにスクリーン削除を依頼
                HySEventObject csEventObj = new HySEventObject(HySSysEvent.OBJID_VIEWER, HySEventObject.CMND_CLOSE_SCREEN);
                csEventObj.SetToSimKind(m_csSimKindID);
                csEventObj.SetSuppID(m_csID);
                csEventObj.SetData(this.GetViewKind());
                csEventObj.SetSubEventNo(HySDispDefine.NOTICE_SCREEN_CLOSE);
                this.PutEvent(csEventObj);
            }
            else
            {  // その他の場合
                bRtn = m_csForm.EventCallback(csEvent);
            }
            return bRtn;
        }

        /// <summary><para>method outline:</para>
        /// <para>表示に特別に必要なイベント情報の設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetDispEventData( csEvent ) </para>
        /// </example>
        /// <param name="csEvent">イベント情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>表示に特別に必要なイベント情報があった場合のみ発行</para>
        /// </remarks>
        public override void SetDispEventData(HySSysEvent csEvent)
        {
            m_csFormTbl = new Hashtable(); // フォーム管理生成
            if (m_csForm != null)
            {  // 画面が有効な場合
                Boolean bRtn = this.EventCallback(csEvent);
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>対となる画面フォームの設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetViewForm( csViewForm )</para>
        /// </example>
        /// <param name="csViewForm">画面フォーム</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void SetViewForm(HySViewForm csViewForm)
        {
            if (m_csForm == null)
            {  // 画面フォームが無い場合
                m_csForm = csViewForm as HySMoniterFormIF;
            }
            else
            {  // 画面フォームが既に有る場合
                m_csForm_Hold = csViewForm as HySMoniterFormIF;
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>フォーム一貫番号取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>long lNumber = GetFormNumber()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>long Form一貫番号</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private long GetFormNumber()
        {
            long lNumber = 1;

            if (m_csFormTbl is Hashtable)
            {  // Form管理情報が有効な場合
                if (m_csFormTbl.Count > 0)
                {  // Formが有る場合
                    List<long> lSeqNo = new List<long>();
                    foreach (string csKey in m_csFormTbl.Keys)
                    {  // ハッシュテーブル件数繰り返す
                        long lNum = ((HySMoniterFormIF)m_csFormTbl[csKey]).GetFormNumber();
                        if (lNum > 0)
                        {  // Form一貫番号が有効な場合
                            lSeqNo.Add(lNum);
                        }
                    }
                    lSeqNo.Sort();
                    for (int iLp = 0; iLp < lSeqNo.Count; iLp++)
                    {
                        if (lSeqNo[iLp] != (iLp + 1))
                        {  // 一貫番号に歯抜けが有る場合
                            lNumber = (iLp + 1); // 歯抜け番号を設定
                            break;
                        }
                        lNumber = lSeqNo[iLp] + 1; // 次番号を設定
                    }
                    lSeqNo = null;
                }
            }
            return lNumber;
        }

        /// <summary><para>method outline:</para>
        /// <para>対となる画面フォーム識別子取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>GetViewFormID(csPatternID)</para>
        /// </example>
        /// <param name="csPatternID">モデル種別リスト</param>
        /// <returns>HySID 対となる画面フォーム識別子</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>
        /// 接続要素（伝送データ）の組合せが表示可の場合のみ該当の識別子を返し、
        /// 表示否の場合はＮＵＬＬを返す。
        /// </para>
        /// </remarks>
        public static HySID GetViewFormID(HySDataLinkedList csPatternID)
        {
            HySID csFormID = null;

            if (csPatternID is HySDataLinkedList)
            {  // 接続要素モデル情報が有る場合
                if (csPatternID.GetCount() == 1)
                {  // 接続要素数が１つの場合
                    csFormID = csPatternID.GetFirstData() as HySID;
                    if (csFormID.Equals(LINE_GRAPH_SINGLE_CELL_ANY) == true)
                    {  // 互換モードの場合
                        csFormID = LINE_GRAPH_SINGLE_CELL_SERIAL; // ポイント時系列汎用グラフ識別子設定
                    }
                    if (csFormID.ToString().Length <= 0)
                    {  // 有効な接続要素が無い場合
                        csFormID = null;
                    }
                }
                else if (csPatternID.GetCount() > 2)
                {  // 接続要素数が２つ以上の場合
                    // 現状２つ以上の接続要素は未サポート
                }
                else if (csPatternID.GetCount() == 2)
                {  // 接続要素数が２つの場合
                    bool bRainSetFlg = false; // 雨量指定有無フラグ
                    bool bLineSetFlg = false; // 任意指定有無フラグ
                    for (long lP = 0; lP < csPatternID.GetCount(); lP++)
                    {
                        HySID csID = csPatternID.GetData(lP) as HySID;
                        if (csID is HySID)
                        {  // 識別子が有効な場合
                            if (HYETO_GRAPH_SINGLE_CELL_SERIAL.Equals(csID) == true ||
                                HYETO_GRAPH_D1_CELL_SERIAL.Equals(csID) == true)
                            {  // ポイント時系列任意入力または１次元配列任意入力の場合
                                bLineSetFlg = true;
                            }
                            else if (HYETO_GRAPH_RAIN_SERIAL.Equals(csID) == true)
                            {  // ポイント時系列雨量入力の場合
                                bRainSetFlg = true;
                            }
                        }
                    }
                    if (bRainSetFlg == true && bLineSetFlg == true)
                    {  // ハイドロ／ハイエトグラフ指定の場合
                        csFormID = HYETO_GRAPH_RAIN_SERIAL;
                    }
                }
            }
            return csFormID;
        }
    }
}
