﻿// <summary>ソースコード：検索結果選択画面スクリーン</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.Interface.HSViewer;
using CommonMP.HYSSOP.Interface.HSData;

using CommonMP.HYSSOP.CoreImpl.HSData;

namespace CommonMP.HYSSOP.CoreImpl.HSViewer
{
    /// <summary><para>class outline:</para>
    /// <para>検索結果選択画面スクリーン</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2009/05/01][新規作成]</para>
    /// </remarks>
    public class HySResultSelectionScreen : HySScreenBase
    {
        //--------------------------------
        // モデル毎画面種別定数
        //--------------------------------
        /// <summary>基本画面識別子</summary>
        public static readonly HySID LINE_GRAPH_REPORT = new HySID("ReportViewLineGraph" + HySDefine.DISP_FORM_RESULT_SELECTION.ToString());
        /// <summary>ハイエト／ハイドログラフ識別子</summary>
        public static readonly HySID HYDRO_HYETO_GRAPH_REPORT = new HySID("ReportViewHydroHyetoGraph" + HySDefine.DISP_FORM_RESULT_SELECTION.ToString());
        /// <summary>１次元配列縦断データ表示識別子</summary>
        public static readonly HySID RIVERBED_SHAPE_REPORT = new HySID("ReportViewRiverbedShape" + HySDefine.DISP_FORM_RESULT_SELECTION.ToString());
        /// <summary>Ｈ－Ｑ曲線図識別子</summary>
        public static readonly HySID HQ_GRAPH_REPORT = new HySID("ReportViewHQGraph" + HySDefine.DISP_FORM_RESULT_SELECTION.ToString());
        /// <summary>Ｅｘｃｅｌ識別子</summary>
        public static readonly HySID EXCEL_REPORT = new HySID("ReportViewExcel" + HySDefine.DISP_FORM_RESULT_SELECTION.ToString());
        /// <summary>地図上２次元メッシュ表示識別子</summary>
        public static readonly HySID GIS2D_MESH_REPORT = new HySID("ReportViewGIS2DMesh" + HySDefine.DISP_FORM_RESULT_SELECTION.ToString());

        //---------------------------------------
        // 対象メンバ定義
        //---------------------------------------
        /// <summary>対応する表示フォーム</summary>
        HySViewFormBaseIF m_csForm = null;

        /// <summary><para>method outline:</para>
        /// <para>ビュー種別取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySKind csKind = GetViewKind()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySKind ビュー種別</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override HySKind GetViewKind()
        {
            return HySDefine.DISP_FORM_RESULT_SELECTION;
        }

        /// <summary><para>method outline:</para>
        /// <para>ビュー種別比較</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bRtn = EqualViewKind(csViewKindID)</para>
        /// </example>
        /// <param name="csViewKindID">ビュー種別</param>
        /// <returns>Boolean true:同じ、false:異なる</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override Boolean EqualViewKind(HySKind csViewKindID)
        {
            return HySDefine.DISP_FORM_RESULT_SELECTION.Equals(csViewKindID);
        }

        /// <summary><para>method outline:</para>
        /// <para>初期処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>Initialize()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void Initialize()
        {
            if (m_csForm != null)
            { // 画面が有効な場合
                m_csForm.SetScreen(this); // スクリーン設定
                m_csForm.Initialize(); // 画面の初期化
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>終了処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>Terminate()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void Terminate()
        {
            if (m_csForm != null)
            { // 画面が有効な場合
                m_csForm.Terminate();
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>画面表示</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> ShowScreen( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void ShowScreen()
        {
            if (m_csForm != null)
            {  // 画面が有効な場合
                m_csForm.Show();
            }
        }
        /// <summary><para>method outline:</para>
        /// <para>画面非表示化</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HideScreen( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void HideScreen()
        {
            if (m_csForm != null)
            {
                m_csForm.Hide();
            }
        }
        /// <summary><para>method outline:</para>
        /// <para>画面更新</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> RenewScreen( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void RenewScreen()
        {
            if (m_csForm != null)
            {  // 画面が有効な場合
                m_csForm.Renew();
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>画面消去</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> CloseScreen( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void CloseScreen()
        {
            if (m_csForm != null)
            {  // 画面が有効な場合
                m_csForm.Close();
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>画面初期配置表示</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> InitiateScreen( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void InitiateScreen()
        {
            if (m_csForm != null)
            {  // 画面が有効な場合
                m_csForm.InitiateScreen();
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>イベントを受け取った時に動作するメソッド</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bRtn = EventCallback( csEvent ) </para>
        /// </example>
        /// <param name="csEvent">送られたイベント</param>
        /// <returns>Boolean true:=正常, false:=異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>各実装クラスは受け取ったイベント毎に処理を行う</para>
        /// </remarks>
        public override Boolean EventCallback(HySSysEvent csEvent)
        {
            Boolean bRtn = true;

            HySEventObject csHySEvent = (HySEventObject)csEvent;
            long lEventNo = csHySEvent.GetEventNo();
            HySID csID = csHySEvent.GetSuppID();
            HySObjectKind csSimKind = (HySObjectKind)csHySEvent.GetToSimKind();
            if (lEventNo == HySEventObject.CMND_DISPLY_COMMON ||
                lEventNo == HySEventObject.CMND_DISP_SCREEN ||
                lEventNo == HySEventObject.NOTICE_DISPLY_OK ||
                lEventNo == HySEventObject.NOTICE_DISPLY_NG)
            {  // 画面への指示／応答の場合
                if (m_csForm != null)
                {  // 画面が有効な場合
                    m_csForm.EventCallback(csEvent);
                }
            }
            else
            {  // その他の場合
            }
            return bRtn;
        }

        /// <summary><para>method outline:</para>
        /// <para>表示に特別に必要なイベント情報の設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetDispEventData( csEvent ) </para>
        /// </example>
        /// <param name="csEvent">イベント情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>表示に特別に必要なイベント情報があった場合のみ発行</para>
        /// </remarks>
        public override void SetDispEventData(HySSysEvent csEvent)
        {
            HySEventObject csHySEvent = (HySEventObject)csEvent;
            long lEventNo = csHySEvent.GetEventNo();
            if (lEventNo == HySEventObject.CMND_DISP_SCREEN)
            {  // 画面表示指示の場合
                this.EventCallback(csEvent);
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>対となる画面フォームの設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetViewForm( csViewForm )</para>
        /// </example>
        /// <param name="csViewForm">画面フォーム</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void SetViewForm(HySViewForm csViewForm)
        {
            m_csForm = csViewForm as HySViewFormBaseIF;
        }

        /// <summary><para>method outline:</para>
        /// <para>対となる画面フォーム識別子の設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>HySID csFormKind = GetFormKind( csScreenKind )</para>
        /// </example>
        /// <param name="csScreenKind">画面識別子</param>
        /// <returns>HySID 対となる画面フォーム識別子</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public static HySID GetFormKind(HySKind csScreenKind)
        {
            HySID csFormKind = null;

            if (csScreenKind.Equals(HySDefine.DISP_FORM_LINE_GRAPH) == true)
            {  // 基本設定の場合
                csFormKind = LINE_GRAPH_REPORT.Clone();
            }
            else if (csScreenKind.Equals(HySDefine.DISP_FORM_HYDRO_HYETO_GRAPH) == true)
            {  // ハイドロ／ハイエトグラフの場合
                csFormKind = HYDRO_HYETO_GRAPH_REPORT.Clone();
            }
            else if (csScreenKind.Equals(HySDefine.DISP_FORM_RIVERBED_SHAPE) == true)
            {  // １次元配列縦断データ表示の場合
                csFormKind = RIVERBED_SHAPE_REPORT.Clone();
            }
            else if (csScreenKind.Equals(HySDefine.DISP_FORM_HQ_GRAPH) == true)
            {  // Ｈ－Ｑ曲線図の場合
                csFormKind = HQ_GRAPH_REPORT.Clone();
            }
            else if (csScreenKind.Equals(HySDefine.DISP_FORM_EXCEL) == true)
            {  // Ｅｘｃｅｌの場合
                csFormKind = EXCEL_REPORT.Clone();
            }
            else if (csScreenKind.Equals(HySDefine.DISP_FORM_GIS2D_MESH) == true)
            {  // 地図上２次元メッシュ表示の場合
                csFormKind = GIS2D_MESH_REPORT.Clone();
            }
            return csFormKind;
        }
    }
}
