﻿// <summary>ソースコード：ビューア基盤クラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.Interface.HSViewer;
using CommonMP.HYSSOP.Interface.HSController;
using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.Interface.HSTools;
using CommonMP.HYSSOP.CoreImpl;
using CommonMP.HYSSOP.CoreImpl.HSController;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;


namespace CommonMP.HYSSOP.CoreImpl.HSViewer
{
    /// <summary><para>class outline:</para>
    /// <para>ビューア基盤クラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2008/10/01][新規作成]</para>
    /// </remarks>
    public abstract class HySViewerBase : HySViewer
    {
        /// <summary>ビューア制御</summary>
        protected HySViewerController m_csViewerCtl;
        /// <summary>ファクトリ管理</summary>
        protected HySFactoryManager m_csFactoryManager;
        
        /// <summary>ビューア内部処理管理用ハッシュテーブル</summary>
        protected Hashtable m_csViewerJobTbl = new Hashtable();
        /// <summary>ビューア内部処理識別キー管理リスト</summary>
        protected IList m_csViewerJobKeyList = new ArrayList();

        /// <summary>終了フラグ</summary>
        protected bool m_bExitFlg = false;

        /// <summary>ビューア動作中フラグ</summary>
        protected bool m_bWorkFlg = false;


        /// <summary><para>method outline:</para>
        /// <para>デフォルトコンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>HySViewerBase csViewer = new HySViewerBase( )</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>生成したインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySViewerBase()
        {
        }

        /// <summary><para>method outline:</para>
        /// <para>制御クラスを設定する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetController( csCtl ) </para>
        /// </example>
        /// <param name="csCtl">制御クラス</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual public void SetController(HySControllerRoot csCtl)
        {
            m_csViewerCtl = (HySViewerController)csCtl;
        }
 
        /// <summary><para>method outline:</para>
        /// <para>ファクトリ管理クラス設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetFactoryManager( csFactoryManager ) </para>
        /// </example>
        /// <param name="csFactoryManager">ファクトリ管理クラス</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual public void SetFactoryManager(HySFactoryMng csFactoryManager)
        {
            m_csFactoryManager = (HySFactoryManager)csFactoryManager;
        }

        /// <summary><para>method outline:</para>
        /// <para>ファクトリ管理クラス取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySFactoryManager csFactoryManager = GetFactoryManager( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySFactoryManager ファクトリ管理クラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual public HySFactoryManager GetFactoryManager()
        {
            return m_csFactoryManager;
        }

        /// <summary><para>method outline:</para>
        /// <para>ビューア内部処理クラス追加</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> AddViewerJob( csViewerJob ) </para>
        /// </example>
        /// <param name="csViewerJob">ビューア内部処理クラス</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual public void AddViewerJob(HySViewerJob csViewerJob)
        {
            csViewerJob.SetViewer(this);
            HySString csJobKey = (HySString)(csViewerJob.GetSimKind()).GetString(); // キー情報
            m_csViewerJobTbl.Add(csJobKey.ToString(), csViewerJob); // ハッシュへ積み込み
            m_csViewerJobKeyList.Add(csJobKey); // キー情報リスト積み込み
        }
        /// <summary><para>method outline:</para>
        /// <para>ビューア内部処理クラスの取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>HySViewerJob csJob = GetViewerJob(csKey) </para>
        /// </example>
        /// <param name="csKey">取得識別子</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual public HySViewerJob GetViewerJob(HySStringRoot csKey)
        {
            HySString csJobKey = (HySString)csKey;
            return m_csViewerJobTbl[csJobKey.ToString()] as HySViewerJob;
        }

        /// <summary><para>method outline:</para>
        /// <para>初期化処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bRtn = Initialize( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>常に true</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual public Boolean Initialize()
        {
            // システム制御Jobクラスを最後に生成しておく
            //HySViewerJob csViewrJob = new HySDotNetViewerSystemJob();// ビューア内部処理生成
            //csViewrJob.SetViewer(this);   // 各種設定
            //this.AddViewerJob(csViewrJob);    // ビューアに積む


            // 既に積み込まれたジョブも含めて、　全Jobの開始処理
            HySString csPrcKey = null;
            HySViewerJob csViewerJob = null;
            long lJobNo = m_csViewerJobKeyList.Count;
            for (long lLp = 1; lLp <= lJobNo; lLp++)
            {
                csPrcKey = (HySString)m_csViewerJobKeyList[(int)(lLp - 1)];
                csViewerJob = (HySViewerJob)m_csViewerJobTbl[csPrcKey.ToString()];
                if (csViewerJob != null)
                {
                    csViewerJob.SetScreenFactory(m_csFactoryManager.GetScreenFactorySet());
                    csViewerJob.SetViewFormFactory(m_csFactoryManager.GetViewFormFactorySet());
                    csViewerJob.Initialize();
                }
            }

            m_bWorkFlg = true;

            return true;
        }
        /// <summary><para>method outline:</para>
        /// <para>終了処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bRtn = Terminate( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>true:正常、false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual public Boolean Terminate()
        {
            // ジョブの終了処理
            HySString csPrcKey = null;
            HySViewerJob csViewerJob = null;
            long lJobNo = m_csViewerJobKeyList.Count;
            for (long lLp = 1; lLp <= lJobNo; lLp++)
            {
                csPrcKey = (HySString)m_csViewerJobKeyList[(int)(lLp - 1)];
                csViewerJob = (HySViewerJob)m_csViewerJobTbl[csPrcKey.ToString()];
                if (csViewerJob != null)
                {
                    csViewerJob.Terminate();
                }
            }
            m_bWorkFlg = false;
            return true;
        }

        /// <summary><para>method outline:</para>
        /// <para>起動処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Run( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual public void Run()
        {
            // 業務にメイン画面起動完了を通知する。
            HySEventObject csEventObject = new HySEventObject(HySSysEvent.OBJID_BUSIPROCEDURE, HySEventObject.NOTICE_MAINVIWER_RUN_COMPLETE);
            this.PutEvent(csEventObject);

            // 自己タイマーにて　他モジュールからのイベントを監視しておく
            for (; ; )
            {
                if (m_bExitFlg == true)
                {
                    break;
                }
                m_csViewerCtl.TryWatchEvent();
                System.Threading.Thread.Sleep(300);
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>イベントを受け取った時に動作するメソッド</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bRtn = EventCallback( csEvent ) </para>
        /// </example>
        /// <param name="csEvent">送られたイベント</param>
        /// <returns>true:=正常, false:=異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>各実装クラスは受け取ったイベント毎に処理を行う</para>
        /// </remarks>
        virtual public Boolean EventCallback(HySSysEvent csEvent)
        {
            Boolean bRtn = true;
            // イベントをビューアジョブに送る。
            HySObjectKind csSimKind = (HySObjectKind)((HySEventObject)csEvent).GetToSimKind();
            HySViewerJob csViewerJob = (HySViewerJob)m_csViewerJobTbl[csSimKind.ToString()];
            if (csViewerJob != null)
            {
                bRtn = csViewerJob.EventCallback(csEvent);
            }
            return bRtn;
        }
        /// <summary><para>method outline:</para>
        /// <para>イベントを送る</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bRtn = PutEvent( csEvent ) </para>
        /// </example>
        /// <param name="csEvent">送るイベント</param>
        /// <returns>true:=正常, false:=異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>ビューア側からCommonMP各コンポーネントへイベントを送信する時に使用する</para>
        /// </remarks>
        virtual public Boolean PutEvent(HySSysEvent csEvent)
        {
            return m_csViewerCtl.PutEvent(csEvent);
        }

        /// <summary><para>method outline:</para>
        /// <para>システム終了準備判定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bRtn = ExitOK( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>true : システムExit準備OK　、false : システムExit準備NG</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual public Boolean ExitOK()
        {
            // Do Nothing
            return true;
        }
        /// <summary><para>method outline:</para>
        /// <para>プロセス終了</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Exit( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual public void Exit()
        {
            m_bExitFlg = true;
        }
    }
}