// <summary>ソースコード：ＨＹＳＳＯＰ定義情報クラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;

namespace CommonMP.HYSSOP.CoreImpl
{
    /// <summary><para>class outline:</para>
    /// <para>HYSSOP系の定義情報クラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2008/10/01][新規作成]</para>
    /// </remarks>
    public static class HySDataKindDefine
    {
        // ===========================
        // シミュレーションデータ種別識別子関係（システムで準備しておくモデルのみ）
        // ===========================

        /// <summary>１次元定常情報 シミュレーションデータ</summary>
        static public readonly HySObjectKind D1_CELL = new HySObjectKind(("HySD1CellArrayData"));
        /// <summary>２次元定常情報 シミュレーションデータ</summary>
        static public readonly HySObjectKind D2_CELL = new HySObjectKind(("HySD2CellArrayData"));
        /// <summary>３次元定常情報 シミュレーションデータ</summary>
        static public readonly HySObjectKind D3_CELL = new HySObjectKind(("HySD3CellArrayData"));

        /// <summary>ＧＩＳ２次元メッシュ情報 シミュレーションデータ</summary>
        static public readonly HySObjectKind D2_GIS_MESH = new HySObjectKind(("HySGeoDim2MeshData"));
        /// <summary>ＧＩＳ３次元メッシュ情報 シミュレーションデータ</summary>
        static public readonly HySObjectKind D3_GIS_MESH = new HySObjectKind(("HySGeoDim3MeshData"));

        //// <summary>セル一つの時系列情報 シミュレーションデータ</summary>
        //static public readonly HySObjectKind SINGLE_CELL_SERIAL = new HySObjectKind(("HySTimeSeriesOneCellArrayData"));
        /// <summary>１次元時系列情報 シミュレーションデータ</summary>
        static public readonly HySObjectKind D1_CELL_SERIAL = new HySObjectKind(("HySTimeSeriesD1CellArrayData"));
        /// <summary>２次元時系列情報 シミュレーションデータ</summary>
        static public readonly HySObjectKind D2_CELL_SERIAL = new HySObjectKind(("HySTimeSeriesD2CellArrayData"));
        /// <summary>３次元時系列情報 シミュレーションデータ</summary>
        static public readonly HySObjectKind D3_CELL_SERIAL = new HySObjectKind(("HySTimeSeriesD3CellArrayData"));

        /// <summary>ＧＩＳ２次元時系列情報 シミュレーションデータ</summary>
        static public readonly HySObjectKind D2_GIS_MESH_SERIAL = new HySObjectKind(("HySGeoDim2MeshSerialData"));
        /// <summary>ＧＩＳ３次元時系列情報 シミュレーションデータ</summary>
        static public readonly HySObjectKind D3_GIS_MESH_SERIAL = new HySObjectKind(("HySGeoDim3MeshSerialData"));


        // ===========================
        // シミュレーションデータ名称関係（システムで準備しておくモデルのみ）
        // ===========================

        /// <summary>１次元定常情報 シミュレーションデータ</summary>
        static public readonly HySString NAME_D1_CELL = new HySString(Properties.HyssopImplResources.NAME_D1_CELL); //"１次元配列定常情報"
        /// <summary>２次元定常情報 シミュレーションデータ</summary>
        static public readonly HySString NAME_D2_CELL = new HySString(Properties.HyssopImplResources.NAME_D2_CELL); //"２次元配列定常情報"
        /// <summary>３次元定常情報 シミュレーションデータ</summary>
        static public readonly HySString NAME_D3_CELL = new HySString(Properties.HyssopImplResources.NAME_D3_CELL); //"３次元配列定常情報"
        /// <summary>ＧＩＳ２次元メッシュ情報 シミュレーションデータ</summary>
        static public readonly HySString NAME_D2_GIS_MESH = new HySString(Properties.HyssopImplResources.NAME_D2_GIS_MESH); //"ＧＩＳ２次元メッシュ情報"
        /// <summary>ＧＩＳ３次元メッシュ情報 シミュレーションデータ</summary>
        static public readonly HySString NAME_D3_GIS_MESH = new HySString(Properties.HyssopImplResources.NAME_D3_GIS_MESH); //"ＧＩＳ３次元メッシュ情報"

        //// <summary>セル一つの時系列情報 シミュレーションデータ</summary>
        //static public readonly HySString NAME_SINGLE_CELL_SERIAL = new HySString("ポイント時系列情報");
        /// <summary>１次元時系列情報 シミュレーションデータ</summary>
        static public readonly HySString NAME_D1_CELL_SERIAL = new HySString(Properties.HyssopImplResources.NAME_D1_CELL_SERIAL);   //"１次元配列時系列情報"
        /// <summary>２次元時系列情報 シミュレーションデータ</summary>
        static public readonly HySString NAME_D2_CELL_SERIAL = new HySString(Properties.HyssopImplResources.NAME_D2_CELL_SERIAL);   //"２次元配列時系列情報"
        /// <summary>３次元時系列情報 シミュレーションデータ</summary>
        static public readonly HySString NAME_D3_CELL_SERIAL = new HySString(Properties.HyssopImplResources.NAME_D3_CELL_SERIAL);   //"３次元配列時系列情報"

        /// <summary>ＧＩＳ２次元時系列情報 シミュレーションデータ</summary>
        static public readonly HySString NAME_D2_GIS_MESH_SERIAL = new HySString(Properties.HyssopImplResources.NAME_D2_GIS_MESH_SERIAL);   //"ＧＩＳ２次元メッシュ時系列情報"
        /// <summary>ＧＩＳ３次元時系列情報 シミュレーションデータ</summary>
        static public readonly HySString NAME_D3_GIS_MESH_SERIAL = new HySString(Properties.HyssopImplResources.NAME_D3_GIS_MESH_SERIAL);   //"ＧＩＳ３次元メッシュ時系列情報"


        // ================================
        // データの物理的意味を表す名称定義
        // ================================
        /// <summary>任意単位</summary>
        static public readonly HySString NAME_ANY_VALUE = new HySString(Properties.HyssopImplResources.MODEL_ANY_INFORMATION);  //"任意情報"
        /// <summary>任意値＿緯度方向　北向きが正、南向きが負</summary>
        static public readonly HySString NAME_ANY_VECTOR_LAT = new HySString(Properties.HyssopImplResources.MODEL_ANY_VECTOR_LAT);
        /// <summary>任意値＿経度方向　東向きが正、西向きが負</summary>
        static public readonly HySString NAME_ANY_VECTOR_LON = new HySString(Properties.HyssopImplResources.MODEL_ANY_VECTOR_LON);
        /// <summary>任意値＿高さ方向　上向きが正、下向きが負</summary>
        static public readonly HySString NAME_ANY_VECTOR_ALT = new HySString(Properties.HyssopImplResources.MODEL_ANY_VECTOR_ALT);
        /// <summary>流量：ｍ３／ｓｅｃ　quantity of flow</summary>
        static public readonly HySString NAME_QUANTITY_OF_WATER_FLOW = new HySString(Properties.HyssopImplResources.MODEL_QUANTITY_OF_WATER_FLOW);  //"流量"
        /// <summary>水位：　ｍ　water level</summary>
        static public readonly HySString NAME_WATER_LEVEL = new HySString(Properties.HyssopImplResources.MODEL_WATER_LEVEL);    //"水位"
        /// <summary>水量：　ｍ３　water volume</summary>
        static public readonly HySString NAME_WATER_VOLUME = new HySString(Properties.HyssopImplResources.MODEL_WATER_VOLUME);  //"水量"
        /// <summary>スカラー：流速：　ｍ／Ｓｅｃ　water velocity</summary>
        static public readonly HySString NAME_SCALOR_VELOCITY = new HySString(Properties.HyssopImplResources.MODEL_SCALOR_VELOCITY);    //"流速（スカラー）"
        
        /// <summary>流速:水平方向： 北をゼロ、時計回りに正、－π～＋πまで　radian　</summary>
        static public readonly HySString NAME_VELOCITY_HORIZONTAL_ANGLE = new HySString(Properties.HyssopImplResources.NAME_VELOCITY_HORIZONTAL_ANGLE); //"流速：水平方向向き"
        /// <summary>流速:垂直方向： 水平をゼロ、上向きに正、－π／２～＋π／２まで　radian　</summary>
        static public readonly HySString NAME_VELOCITY_VERTICAL_ANGLE = new HySString(Properties.HyssopImplResources.NAME_VELOCITY_VERTICAL_ANGLE); //"流速：垂直方向向き"

        /// <summary>ベクトル：ライン方向流速：　ｍ／Ｓｅｃ　water velocity</summary>
        static public readonly HySString NAME_VECTOR_L_VELOCITY = new HySString(Properties.HyssopImplResources.MODEL_VECTOR_L_VELOCITY);    //"ベクトル：ライン方向流速"
        /// <summary>ベクトル：横方向流速：　ｍ／Ｓｅｃ　water velocity</summary>
        static public readonly HySString NAME_VECTOR_W_VELOCITY = new HySString(Properties.HyssopImplResources.MODEL_VECTOR_W_VELOCITY);    //"ベクトル：横方向流速"
        /// <summary>ベクトル：深さ方流速：　ｍ／Ｓｅｃ　water velocity</summary>
        static public readonly HySString NAME_VECTOR_D_VELOCITY = new HySString(Properties.HyssopImplResources.MODEL_VECTOR_D_VELOCITY);    //"ベクトル：深さ方流速"
        /// <summary>スカラー：圧力：　ｍ／Ｓｅｃ　water velocity</summary>
        static public readonly HySString NAME_SCALOR_PRESSURE = new HySString(Properties.HyssopImplResources.MODEL_SCALOR_PRESSURE);    //"圧力（スカラー）"
        /// <summary>ベクトル：ライン方向圧力：　ｍ／Ｓｅｃ　water velocity</summary>
        static public readonly HySString NAME_VECTOR_L_PRESSURE = new HySString(Properties.HyssopImplResources.MODEL_VECTOR_L_PRESSURE);    //"ベクトル：ライン方向圧力"
        /// <summary>ベクトル：横方向圧力：　ｍ／Ｓｅｃ　water velocity</summary>
        static public readonly HySString NAME_VECTOR_W_PRESSURE = new HySString(Properties.HyssopImplResources.MODEL_VECTOR_W_PRESSURE);    //"ベクトル：横方向圧力"
        /// <summary>ベクトル：深さ方圧力：　ｍ／Ｓｅｃ　water velocity</summary>
        static public readonly HySString NAME_VECTOR_D_PRESSURE = new HySString(Properties.HyssopImplResources.MODEL_VECTOR_D_PRESSURE);    //"ベクトル：深さ方圧力"
        /// <summary>スカラー：単位時間当りの雨量：　ｍｍ／ＨＯＵＲ　Rain</summary>
        static public readonly HySString NAME_SCALOR_RAIN_FALL = new HySString(Properties.HyssopImplResources.MODEL_SCALOR_RAIN_FALL);  //"単位時間当りの雨量"
        /// <summary>スカラー：浸水深：　ｍ　flooding depth</summary>
        static public readonly HySString NAME_FLOODING_WATER_DEPTH = new HySString(Properties.HyssopImplResources.NAME_FLOODING_WATER_DEPTH);   //"浸水深さ"
        /// <summary>スカラー：温度：　℃　</summary>
        static public readonly HySString NAME_TEMPERATURE = new HySString(Properties.HyssopImplResources.MODEL_TEMPERATURE);
        /// <summary>スカラー：濃度（質量濃度）：　mg/Kg =ppm </summary>
        static public readonly HySString NAME_CONCENTRATION = new HySString(Properties.HyssopImplResources.MODEL_CONCENTRATION);
        /// <summary>スカラー：密度：　Kg/m3 </summary>
        static public readonly HySString NAME_DENSITY = new HySString(Properties.HyssopImplResources.MODEL_DENSITY);
        /// <summary>スカラー：質量：　10E3Kg </summary>
        static public readonly HySString NAME_MASS = new HySString(Properties.HyssopImplResources.MODEL_MASS);
        /// <summary>スカラー：エネルギー：　J </summary>
        static public readonly HySString NAME_ENERGY = new HySString(Properties.HyssopImplResources.MODEL_ENERGY);
// Ver1.5 追加 >>
        /// <summary>スカラー：最大水位：　m </summary>
        static public readonly HySString NAME_MAX_WATER_LEVEL = new HySString(Properties.HyssopImplResources.MODEL_MAX_WATER_LEVEL);
        /// <summary>スカラー：最大流速（横断方向）：　m/sec </summary>
        static public readonly HySString NAME_MAX_W_VELOCITY = new HySString(Properties.HyssopImplResources.MODEL_MAX_W_VELOCITY);
        /// <summary>スカラー：最大流速（下流方向）：　m/sec </summary>
        static public readonly HySString NAME_MAX_L_VELOCITY = new HySString(Properties.HyssopImplResources.MODEL_MAX_L_VELOCITY);
// Ver1.5 追加 <<

        // ================================
        // データの物理的意味を表す種別の定義
        // ================================
        /// <summary>任意値</summary>
        static public readonly HySObjectKind ANY_VALUE = new HySObjectKind("Scalar_Any");
        /// <summary>任意値＿緯度方向　北向きが正、南向きが負</summary>
        static public readonly HySObjectKind ANY_VECTOR_LAT = new HySObjectKind("Vector_Any_Lat");
        /// <summary>任意値＿経度方向　東向きが正、西向きが負</summary>
        static public readonly HySObjectKind ANY_VECTOR_LON = new HySObjectKind("Vector_Any_Lon");
        /// <summary>任意値＿高さ方向　上向きが正、下向きが負</summary>
        static public readonly HySObjectKind ANY_VECTOR_ALT = new HySObjectKind("Vector_Any_Alt");

        /// <summary>流量：ｍ３／ｓｅｃ　quantity of flow</summary>
        static public readonly HySObjectKind QUANTITY_OF_WATER_FLOW = new HySObjectKind("Scalar_m3/s_FlowRate");
        /// <summary>水位：　ｍ　water level</summary>
        static public readonly HySObjectKind WATER_LEVEL = new HySObjectKind("Scalar_m_WaterLevel");
        /// <summary>水量：　ｍ３　water volume</summary>
        static public readonly HySObjectKind WATER_VOLUME = new HySObjectKind("Scalar_m3_WaterVolume");
        /// <summary>スカラー：流速：　ｍ／Ｓｅｃ　water velocity</summary>
        static public readonly HySObjectKind SCALOR_VELOCITY = new HySObjectKind("Scalar_m/3_Velocity");
        /// <summary>流速:水平方向： 北をゼロ、時計回りに正、－π～＋πまで　radian　</summary>
        static public readonly HySObjectKind VELOCITY_HORIZONTAL_ANGLE = new HySObjectKind("Velocity_HorizontalAngle");
        /// <summary>流速:垂直方向： 水平をゼロ、上向きに正、－π／２～＋π／２まで　radian　</summary>
        static public readonly HySObjectKind VELOCITY_VERTICAL_ANGLE = new HySObjectKind("Velocity_VerticalAngle");
        /// <summary>ベクトル：ライン方向流速：　ｍ／Ｓｅｃ　water velocity</summary>
        static public readonly HySObjectKind VECTOR_L_VELOCITY = new HySObjectKind("Vector_m/3_L_Velocity");
        /// <summary>ベクトル：横方向流速：　ｍ／Ｓｅｃ　water velocity</summary>
        static public readonly HySObjectKind VECTOR_W_VELOCITY = new HySObjectKind("Vector_m/3_W_Velocity");
        /// <summary>ベクトル：深さ方流速：　ｍ／Ｓｅｃ　water velocity</summary>
        static public readonly HySObjectKind VECTOR_D_VELOCITY = new HySObjectKind("Vector_m/3_D_Velocity");
        /// <summary>スカラー：圧力：　N／ｍ２　water Presser</summary>
        static public readonly HySObjectKind SCALOR_PRESSURE = new HySObjectKind("Scalar_N/m2_Pressure");
        /// <summary>ベクトル：ライン方向圧力：　ｍ／Ｓｅｃ　water velocity</summary>
        static public readonly HySObjectKind VECTOR_L_PRESSURE = new HySObjectKind("Vector_N/m2_L_Pressure");
        /// <summary>ベクトル：横方向圧力：　ｍ／Ｓｅｃ　water velocity</summary>
        static public readonly HySObjectKind VECTOR_W_PRESSURE = new HySObjectKind("Vector_N/m2_W_Pressure");
        /// <summary>ベクトル：深さ方圧力：　ｍ／Ｓｅｃ　water velocity</summary>
        static public readonly HySObjectKind VECTOR_D_PRESSURE = new HySObjectKind("Vector_N/m2_D_Pressure");
        /// <summary>スカラー：単位時間当りの雨量：　ｍｍ／ＨＯＵＲ　Rain</summary>
        static public readonly HySObjectKind SCALOR_RAIN_FALL = new HySObjectKind("Scalar_mm/Hour_Rain");
        /// <summary>スカラー：浸水深：　ｍ　flooding depth</summary>
        static public readonly HySObjectKind FLOODING_WATER_DEPTH = new HySObjectKind("FloodingWaterDepth_m");
        /// <summary>スカラー：温度：　℃　</summary>
        static public readonly HySObjectKind TEMPERATURE = new HySObjectKind("Temperature_C");
        /// <summary>スカラー：濃度（質量濃度）：　mg/Kg =ppm </summary>
        static public readonly HySObjectKind CONCENTRATION = new HySObjectKind("Concentration_ppm");
        /// <summary>スカラー：密度：　Kg/m3 </summary>
        static public readonly HySObjectKind DENSITY = new HySObjectKind("Density_Kg/m3");
        /// <summary>スカラー：質量：　10E3Kg </summary>
        static public readonly HySObjectKind MASS = new HySObjectKind("Mass_Kg*10E3");
        /// <summary>スカラー：エネルギー：　J </summary>
        static public readonly HySObjectKind ENERGY = new HySObjectKind("Energy_J");
// Ver1.5 追加 >>
        /// <summary>スカラー：最大水位：　m </summary>
        static public readonly HySObjectKind MAX_WATER_LEVEL = new HySObjectKind("Scalar_m_MaxWaterDepth");
        /// <summary>スカラー：最大流速（横断方向）：　m/sec </summary>
        static public readonly HySObjectKind MAX_W_VELOCITY = new HySObjectKind("Vector_m/s_MaxX_Velocity");
        /// <summary>スカラー：最大流速（下流方向）：　m/sec </summary>
        static public readonly HySObjectKind MAX_L_VELOCITY = new HySObjectKind("Vector_m/s_MaxY_Velocity");
// Ver1.5 追加 <<


        /// <summary>データ種別リスト（GIS版リストと順番が対応関係にあるように設定すること） </summary>
        //static private readonly HySObjectKind[] HySDataKindDefine.m_DataKindList =
        static public readonly HySObjectKind[] m_DataKindList =
            new HySObjectKind[] {   ANY_VALUE,
                                    ANY_VECTOR_LAT,
                                    ANY_VECTOR_LON,
                                    ANY_VECTOR_ALT,
                                    QUANTITY_OF_WATER_FLOW, 
                                    WATER_LEVEL, 
                                    WATER_VOLUME,
                                    SCALOR_VELOCITY,
                                    VELOCITY_HORIZONTAL_ANGLE,
                                    VELOCITY_VERTICAL_ANGLE,
                                    VECTOR_L_VELOCITY, 
                                    VECTOR_W_VELOCITY,
                                    VECTOR_D_VELOCITY,
                                    SCALOR_PRESSURE, 
                                    VECTOR_L_PRESSURE,
                                    VECTOR_W_PRESSURE, 
                                    VECTOR_D_PRESSURE, 
                                    SCALOR_RAIN_FALL,
                                    FLOODING_WATER_DEPTH,
                                    TEMPERATURE,
                                    CONCENTRATION,
                                    DENSITY,
                                    MASS,
                                    ENERGY,
// Ver1.5 追加 >>
                                    MAX_WATER_LEVEL,
                                    MAX_W_VELOCITY,
                                    MAX_L_VELOCITY
// Ver1.5 追加 <<
                                };

        /// <summary>データ種別名称リスト（データ種別リストと順番が対応関係にあるように設定すること） </summary>
        static public readonly HySString[] m_DataKindNameList =
            new HySString[] {   NAME_ANY_VALUE,
                                NAME_ANY_VECTOR_LAT,
                                NAME_ANY_VECTOR_LON,
                                NAME_ANY_VECTOR_ALT,
                                NAME_QUANTITY_OF_WATER_FLOW, 
                                NAME_WATER_LEVEL, 
                                NAME_WATER_VOLUME,
                                NAME_SCALOR_VELOCITY, 
                                NAME_VELOCITY_HORIZONTAL_ANGLE,
                                NAME_VELOCITY_VERTICAL_ANGLE,
                                NAME_VECTOR_L_VELOCITY, 
                                NAME_VECTOR_W_VELOCITY,
                                NAME_VECTOR_D_VELOCITY,
                                NAME_SCALOR_PRESSURE, 
                                NAME_VECTOR_L_PRESSURE,
                                NAME_VECTOR_W_PRESSURE, 
                                NAME_VECTOR_D_PRESSURE, 
                                NAME_SCALOR_RAIN_FALL,
                                NAME_FLOODING_WATER_DEPTH,
                                NAME_TEMPERATURE,
                                NAME_CONCENTRATION,
                                NAME_DENSITY,
                                NAME_MASS,
                                NAME_ENERGY,
// Ver1.5 追加 >>
                                NAME_MAX_WATER_LEVEL,
                                NAME_MAX_W_VELOCITY, 
                                NAME_MAX_L_VELOCITY 
// Ver1.5 追加 <<
                             };

        // ↓　モデル間を連結したとき、物理量が一致するかが重要であり、モデルの意味は不要
        //// <summary>河川：水位　ｍ　water level</summary>
        //static public readonly HySObjectKind RIVER_WATER_LEVEL = new HySObjectKind("m_RiverWaterLevel");
        //// <summary>ダム：貯水位　ｍ　Dam water level</summary>
        //static public readonly HySObjectKind DAM_WATER_LEVEL = new HySObjectKind("m_DamWaterLevel");
        //// <summary>ダム：方水量　ｍ３／ｓｅｃ　water discharge</summary>
        //static public readonly HySObjectKind DAM_DISCHARGE = new HySObjectKind("m3/s_DamDischarge");

        // ==========================================================================================
        // データの物理的意味を表す種別の定義(GISに表示する／GIS側で使用する情報は　分離して定義しておく) 
        //   旧互換性を保つため、　使用しない事
        // ==========================================================================================
        /// <summary>＜ＧＩＳ利用＞任意単位  *旧ﾊﾞｰｼﾞｮﾝと互換性を残すため。使用不可</summary>
        static public readonly HySObjectKind GIS_ANY_VALUE = new HySObjectKind("GIS_Scalar_Any");
        /// <summary>＜ＧＩＳ利用＞任意値＿緯度方向　北向きが正、南向きが負  *旧ﾊﾞｰｼﾞｮﾝと互換性を残すため。使用不可</summary>
        static public readonly HySObjectKind GIS_ANY_VECTOR_LAT = new HySObjectKind("GIS_Scalar_Any_Lat");
        /// <summary>＜ＧＩＳ利用＞任意値＿経度方向　東向きが正、西向きが負  *旧ﾊﾞｰｼﾞｮﾝと互換性を残すため。使用不可</summary>
        static public readonly HySObjectKind GIS_ANY_VECTOR_LON = new HySObjectKind("GIS_Scalar_Any_Lon");
        /// <summary>＜ＧＩＳ利用＞任意値＿高さ方向　上向きが正、下向きが負  *旧ﾊﾞｰｼﾞｮﾝと互換性を残すため。使用不可</summary>
        static public readonly HySObjectKind GIS_ANY_VECTOR_ALT = new HySObjectKind("GIS_Scalar_Any_Alt");

        /// <summary>＜ＧＩＳ利用＞流量：ｍ３／ｓｅｃ　quantity of flow  *旧ﾊﾞｰｼﾞｮﾝと互換性を残すため。使用不可</summary>
        //static public readonly HySObjectKind GIS_QUANTITY_OF_WATER_FLOW = new HySObjectKind("SGIS_calar_m3/s_FlowRate");
        static public readonly HySObjectKind GIS_QUANTITY_OF_WATER_FLOW = new HySObjectKind("GIS_Scalar_m3/s_FlowRate");
        /// <summary>＜ＧＩＳ利用＞水位：　ｍ　water level  *旧ﾊﾞｰｼﾞｮﾝと互換性を残すため。使用不可</summary>
        static public readonly HySObjectKind GIS_WATER_LEVEL = new HySObjectKind("GIS_Scalar_m_WaterLevel");
        /// <summary>＜ＧＩＳ利用＞水量：　ｍ３　water volume  *旧ﾊﾞｰｼﾞｮﾝと互換性を残すため。使用不可</summary>
        static public readonly HySObjectKind GIS_WATER_VOLUME = new HySObjectKind("GIS_Scalar_m3_SWaterVolume");
        /// <summary>＜ＧＩＳ利用＞スカラー：流速：　ｍ／Ｓｅｃ　water velocity  *旧ﾊﾞｰｼﾞｮﾝと互換性を残すため。使用不可</summary>
        static public readonly HySObjectKind GIS_SCALOR_VELOCITY = new HySObjectKind("GIS_Scalar_m/3_Velocity");
        /// <summary>＜ＧＩＳ利用＞流速:水平方向： 北をゼロ、時計回りに正、－π～＋πまで　radian　  *旧ﾊﾞｰｼﾞｮﾝと互換性を残すため。使用不可</summary>
        static public readonly HySObjectKind GIS_VELOCITY_HORIZONTAL_ANGLE = new HySObjectKind("GIS_Velocity_HorizontalAngle");
        /// <summary>＜ＧＩＳ利用＞流速:垂直方向： 水平をゼロ、上向きに正、－π／２～＋π／２まで　radian　  *旧ﾊﾞｰｼﾞｮﾝと互換性を残すため。使用不可</summary>
        static public readonly HySObjectKind GIS_VELOCITY_VERTICAL_ANGLE = new HySObjectKind("GIS_Velocity_VerticalAngle");
        /// <summary>＜ＧＩＳ利用＞ベクトル：ライン方向流速：　ｍ／Ｓｅｃ　water velocity  *旧ﾊﾞｰｼﾞｮﾝと互換性を残すため。使用不可</summary>
        static public readonly HySObjectKind GIS_VECTOR_L_VELOCITY = new HySObjectKind("GIS_Vector_m/3_L_Velocity");
        /// <summary>＜ＧＩＳ利用＞ベクトル：横方向流速：　ｍ／Ｓｅｃ　water velocity  *旧ﾊﾞｰｼﾞｮﾝと互換性を残すため。使用不可</summary>
        static public readonly HySObjectKind GIS_VECTOR_W_VELOCITY = new HySObjectKind("GIS_Vector_m/3_W_Velocity");
        /// <summary>＜ＧＩＳ利用＞ベクトル：深さ方流速：　ｍ／Ｓｅｃ　water velocity  *旧ﾊﾞｰｼﾞｮﾝと互換性を残すため。使用不可</summary>
        static public readonly HySObjectKind GIS_VECTOR_D_VELOCITY = new HySObjectKind("GIS_Vector_m/3_D_Velocity");
        /// <summary>＜ＧＩＳ利用＞スカラー：圧力：　ｍ／Ｓｅｃ　water velocity  *旧ﾊﾞｰｼﾞｮﾝと互換性を残すため。使用不可</summary>
        static public readonly HySObjectKind GIS_SCALOR_PRESSURE = new HySObjectKind("GIS_Scalar_N/m2_Pressure");
        /// <summary>＜ＧＩＳ利用＞ベクトル：ライン方向圧力：　ｍ／Ｓｅｃ　water velocity  *旧ﾊﾞｰｼﾞｮﾝと互換性を残すため。使用不可</summary>
        static public readonly HySObjectKind GIS_VECTOR_L_PRESSURE = new HySObjectKind("GIS_Vector_N/m2_L_Pressure");
        /// <summary>＜ＧＩＳ利用＞ベクトル：横方向圧力：　ｍ／Ｓｅｃ　water velocity  *旧ﾊﾞｰｼﾞｮﾝと互換性を残すため。使用不可</summary>
        static public readonly HySObjectKind GIS_VECTOR_W_PRESSURE = new HySObjectKind("GIS_Vector_N/m2_W_Pressure");
        /// <summary>＜ＧＩＳ利用＞ベクトル：深さ方圧力：　ｍ／Ｓｅｃ　water velocity  *旧ﾊﾞｰｼﾞｮﾝと互換性を残すため。使用不可</summary>
        static public readonly HySObjectKind GIS_VECTOR_D_PRESSURE = new HySObjectKind("GIS_Vector_N/m2_D_Pressure");
        /// <summary>＜ＧＩＳ利用＞スカラー：単位時間当りの雨量：　ｍｍ／ＨＯＵＲ　Rain  *旧ﾊﾞｰｼﾞｮﾝと互換性を残すため。使用不可</summary>
        static public readonly HySObjectKind GIS_SCALOR_RAIN_FALL = new HySObjectKind("GIS_Scalar_mm/Hour_Rain");
        /// <summary>＜ＧＩＳ利用＞スカラー：浸水深：　ｍ　flooding depth  *旧ﾊﾞｰｼﾞｮﾝと互換性を残すため。使用不可</summary>
        static public readonly HySObjectKind GIS_FLOODING_WATER_DEPTH = new HySObjectKind("GIS_FloodingWaterDepth");
        /// <summary>スカラー：温度：　℃　  *旧ﾊﾞｰｼﾞｮﾝと互換性を残すため。使用不可</summary>
        static public readonly HySObjectKind GIS_TEMPERATURE = new HySObjectKind("GIS_temperature_C");
        /// <summary>スカラー：濃度（質量濃度）：　mg/Kg =ppm   *旧ﾊﾞｰｼﾞｮﾝと互換性を残すため。使用不可</summary>
        static public readonly HySObjectKind GIS_CONCENTRATION = new HySObjectKind("GIS_concentration_ppm");
        /// <summary>スカラー：密度：　Kg/m3   *旧ﾊﾞｰｼﾞｮﾝと互換性を残すため。使用不可</summary>
        static public readonly HySObjectKind GIS_DENSITY = new HySObjectKind("GIS_density_Kg/m3");
        /// <summary>スカラー：質量：　10E3Kg   *旧ﾊﾞｰｼﾞｮﾝと互換性を残すため。使用不可</summary>
        static public readonly HySObjectKind GIS_MASS = new HySObjectKind("GIS_mass_Kg");
        /// <summary>スカラー：エネルギー：　J   *旧ﾊﾞｰｼﾞｮﾝと互換性を残すため。使用不可</summary>
        static public readonly HySObjectKind GIS_ENERGY = new HySObjectKind("GIS_energy_J");
// Ver1.5 追加 >>
        /// <summary>スカラー：最大水位：　m </summary>
        static public readonly HySObjectKind GIS_MAX_WATER_LEVEL = new HySObjectKind("GIS_Scalar_m_MaxWaterDepth");
        /// <summary>スカラー：最大流速：　m/sec </summary>
        static public readonly HySObjectKind GIS_MAX_W_VELOCITY = new HySObjectKind("GIS_Vector_m/s_MaxX_Velocity");
        /// <summary>スカラー：最大流速：　m/sec </summary>
        static public readonly HySObjectKind GIS_MAX_L_VELOCITY = new HySObjectKind("GIS_Vector_m/s_MaxY_Velocity");
// Ver1.5 追加 <<

        /// <summary>＜ＧＩＳ利用＞データ種別リスト（通常版リストと順番が対応関係にあるように設定すること）   *旧ﾊﾞｰｼﾞｮﾝと互換性を残すため。使用不可</summary>
        //static private readonly HySObjectKind[] m_GISDataKindList =
        static public readonly HySObjectKind[] m_GISDataKindList =
            //new HySObjectKind[] {   ANY_VALUE,
            new HySObjectKind[] {   GIS_ANY_VALUE,
                                    GIS_ANY_VECTOR_LAT,
                                    GIS_ANY_VECTOR_LON,
                                    GIS_ANY_VECTOR_ALT,
                                    GIS_QUANTITY_OF_WATER_FLOW, 
                                    GIS_WATER_LEVEL, 
                                    GIS_WATER_VOLUME,
                                    GIS_SCALOR_VELOCITY,
                                    GIS_VELOCITY_HORIZONTAL_ANGLE,
                                    GIS_VELOCITY_VERTICAL_ANGLE,
                                    GIS_VECTOR_L_VELOCITY, 
                                    GIS_VECTOR_W_VELOCITY,
                                    GIS_VECTOR_D_VELOCITY, 
                                    GIS_SCALOR_PRESSURE, 
                                    GIS_VECTOR_L_PRESSURE,
                                    GIS_VECTOR_W_PRESSURE, 
                                    GIS_VECTOR_D_PRESSURE, 
                                    GIS_SCALOR_RAIN_FALL,
                                    GIS_FLOODING_WATER_DEPTH,
                                    GIS_TEMPERATURE,
                                    GIS_CONCENTRATION,
                                    GIS_DENSITY,
                                    GIS_MASS,
                                    GIS_ENERGY,
// Ver1.5 追加 >>
                                    GIS_MAX_WATER_LEVEL,
                                    GIS_MAX_W_VELOCITY, 
                                    GIS_MAX_L_VELOCITY 
// Ver1.5 追加 <<
                                };

        /// <summary><para>method outline:</para>
        /// <para>GISデータ種別識別子取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>HySObjectKind csGISDataKind = HySDataKindDefine.GetGISDataKind(csDataKind)</para>
        /// </example>
        /// <param name="csDataKind">データ種別識別子</param>
        /// <returns>HySObjectKind データ種別識別子</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>
        /// 指定されたデータ種別識別子のGIS版識別子を取得する。
        /// 対応する定義がない場合はnullを返す。
        /// </para>
        /// </remarks>
        public static HySObjectKind GetGISDataKind(HySObjectKind csDataKind)
        {
            HySObjectKind csRtn = null;

            for (long i = 0; i < m_DataKindList.Length; i++)
            {
                if (csDataKind.Equals(m_DataKindList[i]))
                {
                    csRtn = m_GISDataKindList[i];
                }
            }
            return csRtn;
        }
    }
}
