﻿// <summary>ソースコード：ＨＹＳＳＯＰ定義情報クラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;

namespace CommonMP.HYSSOP.CoreImpl
{
    /// <summary><para>class outline:</para>
    /// <para>HYSSOP系の定義情報クラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2008/10/01][新規作成]</para>
    /// </remarks>
    public static class HySDefine
    {
        // ==================
        // ファクトリ種別定義
        // ==================
        /// <summary>業務処理ファクトリー</summary>
        static public readonly HySKind FACTORY_KIND_BUSIPROCEDURE = new HySObjectKind("BusiProcFactory");
        /// <summary>シミュレーションファクトリー</summary>
        static public readonly HySKind FACTORY_KIND_SIMULATION = new HySObjectKind("SimulatorFactory");
        /// <summary>ライブラリーマネージャーファクトリー</summary>
        static public readonly HySKind FACTORY_KIND_LIBRARY_MNG = new HySObjectKind("LibraryMngFactory");
        /// <summary>GISファクトリー</summary>
        static public readonly HySKind FACTORY_KIND_GIS = new HySObjectKind("GISFactory");
        /// <summary>ビューアファクトリー</summary>
        static public readonly HySKind FACTORY_KIND_VIEWR = new HySObjectKind("ViewerFactory");
        /// <summary>画面ファクトリー</summary>
        static public readonly HySKind FACTORY_KIND_SCREEN = new HySObjectKind("ScreenFactory");
        /// <summary>ビューア内処理ファクトリー</summary>
        static public readonly HySKind FACTORY_KIND_VIEWRJOB = new HySObjectKind("ViewerJobFactory");
        /// <summary>フォームファクトリー</summary>
        static public readonly HySKind FACTORY_KIND_VIEWRFORM = new HySObjectKind("ViewerFormFactory");



        // ===================================================
        // CommonMP構成要素種別識別名 (CommonMP.dicon 内で使用)
        // ===================================================
        /// <summary>業務処理</summary>
        static public readonly String COMMONMP_BUSIPROCEDURE = "BusiProc";
        /// <summary>シミュレーション</summary>
        static public readonly String COMMONMP_SIMULATION = "Simulator";
        /// <summary>ライブラリーマネージャ</summary>
        static public readonly String COMMONMP_LIBRARY_MNG = "LibraryManager";
        /// <summary>GIS</summary>
        static public readonly String COMMONMP_GIS = "GIS";
        /// <summary>ビューア</summary>
        static public readonly String COMMONMP_VIEWER = "Viewer";
        /// <summary>画面</summary>
        static public readonly String COMMONMP_SCREEN = "Screen";
        /// <summary>ビューア内処理</summary>
        static public readonly String COMMONMP_VIEWRJOB = "ViewerJob";
        /// <summary>フォーム</summary>
        static public readonly String COMMONMP_VIEWRFORM = "ViewerForm";

        // =====================================
        // CommonMPシステム構成要素種別識別識別子
        // =====================================
        /// <summary>業務処理</summary>
        static public readonly HySIdentifier COMPONENT_ID_BUSIPROCEDURE = new HySID("SYSTEM" + "Component" + "BusiProc");
        /// <summary>シミュレーション</summary>
        static public readonly HySIdentifier COMPONENT_ID_SIMULATION = new HySID("SYSTEM" + "Component" + "Simulator");
        /// <summary>ライブラリーマネージャー</summary>
        static public readonly HySIdentifier COMPONENT_ID_LIBRARY_MNG = new HySID("SYSTEM" + "Component" + "LibraryMng");
        /// <summary>GIS</summary>
        static public readonly HySIdentifier COMPONENT_ID_GIS = new HySID("SYSTEM" + "Component" + "GIS");
        /// <summary>ビューア</summary>
        static public readonly HySIdentifier COMPONENT_ID_VIEWR = new HySID("SYSTEM" + "Component" + "Viewer");
        /// <summary>画面</summary>
        static public readonly HySIdentifier COMPONENT_ID_SCREEN = new HySID("SYSTEM" + "Component" + "Screen");
        /// <summary>ビューア内処理</summary>
        static public readonly HySIdentifier COMPONENT_ID_VIEWRJOB = new HySID("SYSTEM" + "Component" + "ViewerJob");
        /// <summary>フォーム</summary>
        static public readonly HySIdentifier COMPONENT_ID_VIEWRFORM = new HySID("SYSTEM" + "Component" + "ViewerForm");

        // ===================================
        // CommonMP共通表示フォーマット種別識別
        // ===================================
        /// <summary>折れ線グラフ表示</summary>
        static public readonly HySKind DISP_FORM_LINE_GRAPH = new HySObjectKind("DispFormLineGraph");
        /// <summary>ハイドロ・ハイエトグラフ表示</summary>
        static public readonly HySKind DISP_FORM_HYDRO_HYETO_GRAPH = new HySObjectKind("DispFormHydroHyetoGraph");
        /// <summary>ＨＱグラフ表示</summary>
        static public readonly HySKind DISP_FORM_HQ_GRAPH = new HySObjectKind("DispFormHQGraph");
        /// <summary>河床面表示</summary>
        static public readonly HySKind DISP_FORM_RIVERBED_SHAPE = new HySObjectKind("DispFormRiverbedShape");
        /// <summary>河道横断面図表示</summary>
        static public readonly HySKind DISP_FORM_RIVER_CROSSSECTION = new HySObjectKind("DispFormRiverCrossSection");

        /// <summary>背景地図表示</summary>
        static public readonly HySKind DISP_FORM_GIS_BASEMAP = new HySObjectKind("DispFormGISBaseMap");
        /// <summary>地図上２次元メッシュ表示</summary>
        static public readonly HySKind DISP_FORM_GIS2D_MESH = new HySObjectKind("DispFormGIS2DMesh");
        /// <summary>地図上３次元メッシュ表示</summary>
        static public readonly HySKind DISP_FORM_GIS3D_MESH = new HySObjectKind("DispFormGIS3DMesh");
        /// <summary>地図上自由図形表示</summary>
        static public readonly HySKind DISP_FORM_GIS_FIGURE = new HySObjectKind("DispFormGISFigure");
        /// <summary>地図上３次元図形表示（球等）</summary>
        static public readonly HySKind DISP_FORM_GIS3D_FIGURE = new HySObjectKind("DispFormGIS3Figure");
        /// <summary>水理／水門関係情報地図表示</summary>
        static public readonly HySKind DISP_FORM_GIS_HYDRLGCL_OBJ = new HySObjectKind("DispFormGISHydrlgclObj");

        /// <summary>検索条件設定表示</summary>
        static public readonly HySKind DISP_FORM_SEARCH_CONDITION = new HySObjectKind("DispFormSearchCondition");
        /// <summary>検索結果選択表示</summary>
        static public readonly HySKind DISP_FORM_RESULT_SELECTION = new HySObjectKind("DispFormResultSelection");
        /// <summary>グラフカスタマイズ表示</summary>
        static public readonly HySKind DISP_FORM_GRAPH_CUSTOMIZ = new HySObjectKind("DispFormGraphCustomiz");

        /// <summary>Ｅｘｃｅｌ表示</summary>
        static public readonly HySKind DISP_FORM_EXCEL = new HySObjectKind("DispFormExcel");

        /// <summary>計算結果モニタ表示</summary>
        static public readonly HySKind DISP_FORM_MONITER = new HySObjectKind("DispFormMoniter");

        //// <summary>GIS表示選択画面</summary>
        //static public readonly HySKind GIS_DISP_CTL_SCREEN = new HySObjectKind("GISDispCtlScreen");

        // 以後　サポートする表示形式追加により　定義を追加する

        // ============================
        // CommonMP共通処理関係画面識別
        // ============================
        /// <summary>シミュレーション用データ生成制御画面表示</summary>
        static public readonly HySKind SIMULATION_DATA_GENERATOR = new HySObjectKind("SimulationDataGeneratorCtl");
        /// <summary>シミュレーション用データ生成制御画面識別</summary>
        static public readonly String SIMULATION_DATA_GENERATOR_SCREEN_ID = "SimulationDataGeneratorCtl";
        /// <summary>ラッパーモデル情報編集制御画面表示</summary>
        static public readonly HySKind WRAPPER_MODELINFO_EDIT = new HySObjectKind("WrapperModelInfoEditCtl");
        /// <summary>ラッパーモデル情報編集制御画面識別</summary>
        static public readonly String WRAPPER_MODELINFO_EDIT_SCREEN_ID = "WrapperModelInfoEditCtl";

        // ============================
        // CommonMP共通処理関係種別識別
        // ============================
        /// <summary>システム共通業務</summary>
        static public readonly HySKind COMMON_SYS_BUSIPROCEDURE = new HySObjectKind("CommonSysBusiProcedure");
        /// <summary>システム共通画面</summary>
        static public readonly HySKind COMMON_SCREEN_SET = new HySObjectKind("CommonScreenSet");
        /// <summary>システム共通フォーム</summary>
        static public readonly HySKind COMMON_VIEWRFORM_SET = new HySObjectKind("CommonViewerFormSet");

        // =================================
        // CommonMP共通画面処理関連
        // =================================
        /// <summary>システム共通表示業務</summary>
        static public readonly HySKind COMMON_DISP_BUSIPROCEDURE = new HySObjectKind("CommonDispBusiProcedure");
        /// <summary>共通画面表示業務処理ファクトリー</summary>
        static public readonly HySIdentifier FACTORY_ID_DISP_BUSIPROCEDURE = new HySID("DISP" + "Factory" + "BusiProc");
        /// <summary>共通画面表示業務対応ビューア内処理ファクトリー</summary>
        static public readonly HySIdentifier FACTORY_ID_DISP_BUSI_VIEWRJOB = new HySID("DISP" + "Factory" + "ViewerJob");
        /// <summary>システム標準評価画面表示業務</summary>
        static public readonly HySKind COMMON_EVALUATION_BUSIPROCEDURE = new HySObjectKind("CommonEvaluationBusiProcedure");
        

        // ========================
        // CommonMP 共通 enum 定義
        // ========================
        /// <summary>ファイルの型定義(将来拡張用)</summary>
        public enum FileType
        {
            /// <summary>CSV形式</summary>
            CSV_TYPE = 1,
            /// <summary>XML形式</summary>
            XML_TYPE,
            /// <summary>任意Text形式</summary>
            TEXT_TYPE,
            /// <summary>バイナリ－形式</summary>
            BINARY_TYPE
        }

        /// <summary>内挿処理種別定義</summary>
        public enum InterpolateType
        {
            /// <summary>内挿無し(同一時刻と一致しなければ直前の値を取得する）</summary>
            NO_INTERPOLATE = 0,
            /// <summary>線形補間linear</summary>
            LINEAR  ,
            /// <summary>内挿無し(同一時刻と一致しなければ直後（もしあれば）の値を取得する。無ければ、NULL を返す）</summary>
            GET_NEXT_DATA   //, 
            ///// <summary>多項式補間polynomial </summary>
            //POLYNOMIAL
        }

        /// <summary>内挿処理種別名称（上記　InterpolateTypeと順番が対応関係にあるように設定すること） </summary>
        static public readonly HySString[] m_InterpolateTypeName =
            new HySString[]
            {   new HySString(Properties.HyssopImplResources.NAME_INTERPOLATE_TYPE_NONE ),// new HySString("内挿無し"),
                new HySString(Properties.HyssopImplResources.NAME_INTERPOLATE_TYPE_LINEAR ), //new HySString("線形補間") 
                new HySString(Properties.HyssopImplResources.NAME_INTERPOLATE_TYPE_GET_NEXT ) //new HySString("直後データ取得") 
            };
        /// <summary>内挿処理種別名称：内挿無し</summary>
        static public readonly string sNO_INTERPOLATE = "NON";
        /// <summary>内挿処理種別名称：線形補間linear</summary>
        static public readonly string sLINEAR_INTERPOLATE = "LINEAR";
        /// <summary>内挿無し(同一時刻と一致しなければ直後の値を取得する。該当データが無ければ、NULL を返す）</summary>
        static public readonly string sGET_NEXT_DATA_INTERPOLATE = "GET_NEXT_DATA";
        /// <summary>内挿処理種別名称：多項式補間polynomial</summary>
        static public readonly string sPOLYNOMIAL_INTERPOLATE = "POLYNOMIAL";

        /// <summary>欠損時データ</summary>
        static public readonly double dINVALID_VALUE = -9.999999E20;


        // ==========================
        // CommonMP 共通 XMLタグ 定義
        // ==========================
        /// <summary>セル内のデータの特性管理 Characteristic</summary>
        static public readonly string xml_DATA_CHARACTERISTIC_IN_CELL = "DataCharacteristicInCell";
        //// <summary>数</summary>
        //static public readonly string xml_DATA_NUMBER = "Number";
        /// <summary>データの特性 Characteristic</summary>
        static public readonly string xml_DATA_CHARACTERISTIC = "Characteristic";
        /// <summary>データのラベル名</summary>
        static public readonly string xml_DATA_LABEL = "Label";
        /// <summary>データの単位</summary>
        static public readonly string xml_DATA_UNIT = "Unit";
        /// <summary>データの種別</summary>
        static public readonly string xml_DATA_TYPE = "DataType";
        /// <summary>セル型データの取得クラス情報</summary>
        static public readonly string xml_CELL_DATA_GETTER = "CellDataGetter";
        /// <summary>インデックス情報</summary>
        static public readonly string xml_INDEX = "Index";
        /// <summary>インデックス順序</summary>
        static public readonly string xml_INDEX_NO = "Order";
        /// <summary>インデックス値</summary>
        static public readonly string xml_INDEX_VALUE = "Value";
        /// <summary>セル型データ</summary>
        static public readonly string xml_CELL_DATA = "CellData";

        // ===========================
        // シミュレーター種別識別子関係
        // ===========================
        /// <summary>ＨＹＳＳＯＰシミュレーター種別識別子関係</summary>
        static public readonly HySObjectKind SIMULATOR_KIND = new HySObjectKind("HYSSOP");

        // =======================
        // ファクトリ識別子
        // =======================
        /// <summary>ライブラリーマネージャーファクトリー</summary>
        static public readonly HySIdentifier FACTORY_ID_LIBRARY_MNG = new HySID("HYSSOP" + "Factory" + "LibraryManager");

    }
}
