﻿// <summary>ソースコード：システム内イベント制御I/Fクラス</summary>
// <author>CommonMP</author>using System;

using System;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.Interface.HSData;

namespace CommonMP.HYSSOP.Interface.HSController
{
    /// <summary><para>class outline:</para>
    /// <para>システム内イベント制御I/Fクラス</para>
    /// </summary>
    /// <remarks><para>remarks:</para>
    /// <para>無し</para>
    /// </remarks>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2008/10/01][新規作成]</para>
    /// </remarks>
    public interface HySEventMngRoot : HySRoot
    {
        /// <summary><para>method outline:</para>
        /// <para>イベントを宛先に従ってシステム制御クラスにポストする</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bRtn = PutEvent( csEvent ) </para>
        /// </example>
        /// <param name="csEvent">送るイベント</param>
        /// <returns>true:=正常, false:=異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        Boolean PutEvent(HySSysEvent csEvent);

        /// <summary><para>method outline:</para>
        /// <para>システム終了準備完了判別</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bRtn = ExitOK( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>true : システムExit準備OK　、false : システムExit準備NG</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        Boolean ExitOK();

        /// <summary><para>method outline:</para>
        /// <para>システム制御クラスを設定する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> AddSysController( csController ) </para>
        /// </example>
        /// <param name="csController">システム制御クラス</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        void AddSysController(HySControllerRoot csController );
    }
}
