﻿// <summary>ソースコード：ファクトリクラスＩ／Ｆ</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.Interface.HSData;

namespace CommonMP.HYSSOP.Interface.HSController
{
    /// <summary><para>class outline:</para>
    /// <para>ファクトリクラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2008/10/01][新規作成]</para>
    /// </remarks>
    public interface HySFactory : HySRoot
    {
        /// <summary><para>method outline:</para>
        /// <para>初期処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Init(csFactoryMng) </para>
        /// </example>
        /// <param name="csFactoryMng">ファクトリ管理</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        void Init(HySFactoryMng csFactoryMng);
        /// <summary><para>method outline:</para>
        /// <para>終了処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Term() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        void Term();

        /// <summary><para>method outline:</para>
        /// <para>ファクトリー識別子設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetFactoryID( csID ) </para>
        /// </example>
        /// <param name="csID">ファクトリー識別子</param>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        void SetFactoryID(HySIdentifier csID);

        /// <summary><para>method outline:</para>
        /// <para>識別子取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySIdentifier csID = GetFactoryID( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>識別子</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        HySIdentifier GetFactoryID();

        /// <summary><para>method outline:</para>
        /// <para>識別子比較</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bRtn = EqualFactory( csID ) </para>
        /// </example>
        /// <param name="csID">ファクトリー識別子</param>
        /// <returns>true  : ＝、false : ≠</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        Boolean EqualFactory(HySIdentifier csID);
    }
}
