﻿// <summary>ソースコード：ファクトリ管理Ｉ／Ｆクラス</summary>
// <author>CommonMP</author>using System;

using System;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.Interface.HSViewer;
using CommonMP.HYSSOP.Interface.HSGIS;

namespace CommonMP.HYSSOP.Interface.HSController
{
    /// <summary><para>class outline:</para>
    /// <para>ファクトリ管理Ｉ／Ｆクラス</para>
    /// </summary>
    /// <remarks><para>remarks:</para>
    /// <para>無し</para>
    /// </remarks>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2008/10/01][新規作成]</para>
    /// </remarks>
    public interface HySFactoryMng : HySRoot
    {
        /// <summary><para>method outline:</para>
        /// <para>ファクトリクラス追加</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> AddFactory( csEvent ) </para>
        /// </example>
        /// <param name="csFactory">ファクトリクラス</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        void AddFactory(HySFactory csFactory);

        /// <summary><para>method outline:</para>
        /// <para>ファクトリ数取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> long lFactoryNum = GetFactoryNum( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>ファクトリ数</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        long GetFactoryNum();

        /// <summary><para>method outline:</para>
        /// <para>ファクトリクラス取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySFactory csFactory = GetFactory( lOrderNo ) </para>
        /// </example>
        /// <param name="lOrderNo">位置（０相対）</param>
        /// <returns>ファクトリクラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        HySFactory GetFactory(long lOrderNo);

        /// <summary><para>method outline:</para>
        /// <para>キー指定ファクトリクラス取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySFactory csFactory = GetFactory( csKey ) </para>
        /// </example>
        /// <param name="csKey">キー</param>
        /// <returns>ファクトリクラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        HySFactory GetFactory(HySIdentifier csKey);
   
        /// <summary><para>method outline:</para>
        /// <para>終了処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> ShutDown( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        void ShutDown();
    }
}
