﻿// <summary>ソースコード：データコンテナ基底クラス</summary>
// <author>CommonMP</author>
using System;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.Interface.HSTools;

namespace CommonMP.HYSSOP.Interface.HSData
{
    /// <summary><para>class outline:</para>
    /// <para>コンテナ抽象化クラス</para>
    /// </summary>
    /// <remarks><para>remarks:</para>
    /// <para>本クラスの派生クラスは全て[Serializable]であること</para>
    /// </remarks>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2008/10/01][新規作成]</para>
    /// </remarks>

    [Serializable]
    public abstract class HySContainer : HySSysEvent // , HySVersionManagement  <-- メンバー変数を持たないため不要
    {
        /// <summary><para>method outline:</para>
        /// <para>識別子設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetID( csID ) </para>
        /// </example>
        /// <param name="csID">識別子</param>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public abstract void SetID(HySIdentifier csID);
        /// <summary><para>method outline:</para>
        /// <para>識別子取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySIdentifier csID = GetID( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>識別子</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public abstract HySIdentifier GetID();
        /// <summary><para>method outline:</para>
        /// <para>識別子比較</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bRtn = Equal( csID ) </para>
        /// </example>
        /// <param name="csID">比較する種別識別子</param>
        /// <returns>  true :＝ , false:≠</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public abstract Boolean Equal(HySIdentifier csID);

        /// <summary><para>method outline:</para>
        /// <para>ＩＯ出力</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>long lRtn = IOOut( csIO ) </para>
        /// </example>
        /// <param name="csIO">ＩＯ</param>
        /// <returns>＝0:正常、＜0：異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public abstract long IOOut(HySIOStream csIO);
        /// <summary><para>method outline:</para>
        /// <para>ＩＯ入力</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>long lRtn = IOIn( csIO ) </para>
        /// </example>
        /// <param name="csIO">ＩＯ</param>
        /// <returns>＝0:正常、＜0：異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public abstract long IOIn(HySIOStream csIO);

        /// <summary><para>method outline:</para>
        /// <para>データ設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetData( csKey,csDt )</para>
        /// </example>
        /// <param name="cskey">キー</param>
        /// <param name="csDt">データ</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public abstract void SetData(HySStringRoot cskey, HySDataRoot csDt);

        /// <summary><para>method outline:</para>
        /// <para>データ取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>HysDataRoot csDt = GetData( csKey )</para>
        /// </example>
        /// <param name="cskey">キー</param>
        /// <returns>データ</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public abstract HySDataRoot GetData(HySStringRoot cskey);
        /// <summary><para>method outline:</para>
        /// <para>データ削除</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> DeleteData(csKey) </para>
        /// </example>
        /// <param name="csKey">キー</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public abstract void DeleteData(HySStringRoot csKey);

        /*
        // ＝＝　シミュレーション時間関係管理　＝＝
        /// <summary><para>method outline:</para>
        /// <para>シミュレーション計算初期時刻設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetStartTime( csTm )</para>
        /// </example>
        /// <param name="csTm">時刻</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public abstract void SetStartTime(HySDate csTm);
        /// <summary><para>method outline:</para>
        /// <para>シミュレーション計算初期時刻取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>HySDate csTm = csDataCnt.GetSStartTime()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>時刻</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public abstract HySDate GetStartTime();
        /// <summary><para>method outline:</para>
        /// <para>目標時間設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetGoalTime( csTm )</para>
        /// </example>
        /// <param name="csTm">時刻</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public abstract void SetGoalTime(HySDate csTm);
        /// <summary><para>method outline:</para>
        /// <para>目標時間取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>HySDate csTm = GetGoalTime( )</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>時刻</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public abstract HySDate GetGoalTime();

        /// <summary><para>method outline:</para>
        /// <para>シミュレーション計算時刻設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetSimuTIme( csTm )</para>
        /// </example>
        /// <param name="csTm">時刻</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public abstract void SetSimuTime(HySDate csTm);
        /// <summary><para>method outline:</para>
        /// <para>シミュレーション計算時刻取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>HySDate csTm = GetSimuTime()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>時刻</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public abstract HySDate GetSimuTime();

        /// <summary><para>method outline:</para>
        /// <para>シミュレーション計算刻み時間設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetDeltaTime( csDltTm )</para>
        /// </example>
        /// <param name="csDltTm">刻み時間</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public abstract void SetDeltaTime(HySDate csDltTm);
        /// <summary><para>method outline:</para>
        /// <para>シミュレーション計算刻み時間取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>HySDate csTm = GetDeltaTime()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>刻み時間</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public abstract HySDate GetDeltaTime();

        /// <summary><para>method outline:</para>
        /// <para>シミュレーション目標時刻到達</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>Boolean bRtn = IsTimeUp()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>true  : 到達、false : 未到達</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>シミュレーション時刻が目標時刻と同じまたは過ぎたならば true を返す</para>
        /// </remarks>
        public abstract Boolean IsTimeUp();
                // ================================================
        //   バージョンアップ時の下位互換性を保つ為の処理
        // ================================================
        /// <summary>保存バージョン情報</summary>
        private string m_sDecodedVersion;
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> string sDecodedVersion = GetDecodedVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>string 保存バージョン情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>メンバー変数に設定されているバージョン情報を返す</para>
        /// </remarks>
        public new string GetDecodedVersion()
        {
            return m_sDecodedVersion;
        }
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> string sVersion = GetNowVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>string 現在のバージョン情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public new string GetNowVersion()
        {
            return "1.00";
        }
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetNowVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>現在のバージョン情報をメンバー変数に設定する</para>
        /// </remarks>
        public new void SetNowVersion()
        {
            m_sDecodedVersion = GetNowVersion();
        }
        /// <summary><para>method outline:</para>
        /// <para>復元後の整合性確保処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> PostDeserialize( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>シリアライズされた旧バージョン情報を復元する際、過去の整合性をとる時に使用する
        /// バージョンによって変数等追加がない場合には、実装の必要がない
        /// </para>
        /// </remarks>
        public override void PostDeserialize()
        {
            base.PostDeserialize();

            if (GetDecodedVersion() != GetNowVersion())
            {
                if (GetDecodedVersion() == null)
                {
                    // 旧バージョンからの移行処理を入れる
                }
                else
                {
                    //旧バージョンから順にバージョンを上げて行く
                    switch (GetDecodedVersion())
                    {
                        case "1.00":
                            {
                                // 旧バージョンからの移行処理を入れる
                                break;
                            }
                        //case "2.00": << 以後バージョンアップに伴って処理追加
                        //{
                        //    break;
                        //}
                    }
                }
                SetNowVersion();
            }
        }
        /// <summary><para>method outline:</para>
        /// <para>逆シリアル化時追加処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> IDeserializationCallback.OnDeserialization(csObj)</para>
        /// </example>
        /// <param name="csObj">ダミー</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>予約処理</para>
        /// </remarks>
        void IDeserializationCallback.OnDeserialization(Object csObj)
        {
            PostDeserialize();
        }
        */
    }
}
