﻿// <summary>ソースコード：日付操作インターフェース</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.Interface.HSData;

namespace CommonMP.HYSSOP.Interface.HSData
{
    /// <summary><para>class outline:</para>
    /// <para>日付操作インターフェース</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2008/10/01][新規作成]</para>
    /// </remarks>
    public interface HySDate : HySDataRoot
    {
        /// <summary><para>method outline:</para>
        /// <para>時間比較</para>
        /// </summary>
        /// <remarks>
        /// この HySDate の現在時刻が 引数：HySDate Date と同じ場合は true、そうでない場合は false
        /// </remarks>
        /// <example><para>usage:</para>
        /// <para> Boolean bRtn = Equals(csDate)</para>
        /// </example>
        /// <param name="csDate">比較時間</param>
        /// <returns>true  : ＝、false : ≠</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        Boolean Equals(HySDate csDate);

        /// <summary><para>method outline:</para>
        /// <para>時間比較</para>
        /// </summary>
        /// <remarks>
        /// この HySDate の現在時刻が 引数：HySDate Date の時刻よりあとの場合は true、そうでない場合は false
        /// </remarks>
        /// <example><para>usage:</para>
        /// <para> Boolean bRtn = After(csDate)</para>
        /// </example>
        /// <param name="csDate">比較時間</param>
        /// <returns>true  : ＝、false : ≠</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        Boolean After(HySDate csDate);

        /// <summary><para>method outline:</para>
        /// <para>時間比較</para>
        /// </summary>
        /// <remarks>
        /// この HySDate の現在時刻が 引数：HySDate Date の時刻より前の場合は true、そうでない場合は false
        /// </remarks>
        /// <example><para>usage:</para>
        /// <para> Boolean bRtn = Before(csDate)</para>
        /// </example>
        /// <param name="csDate">比較時間</param>
        /// <returns>true  : ＝、false : ≠</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        Boolean Before(HySDate csDate);
    }
}
