﻿// <summary>ソースコード：データ識別子基底クラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.Interface.HSTools;

namespace CommonMP.HYSSOP.Interface.HSData
{
    /// <summary><para>class outline:</para>
    /// <para>データ識別子Ｉ／Ｆ</para>
    /// </summary>
    /// <remarks><para>remarks:</para>
    /// <para>本クラスの派生クラスは全て[Serializable]であること</para>
    /// </remarks>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2008/10/01][新規作成]</para>
    /// </remarks>
    [Serializable]
    public abstract class HySIdentifier : HySDataRoot
    {
        /// <summary><para>method outline:</para>
        /// <para>識別子比較</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>Boolean bRtn = Equal( csID )</para>
        /// </example>
        /// <param name="csId">データ識別子 </param>
        /// <returns>true :＝ , false:≠</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public abstract Boolean Equals(HySIdentifier csId);

        /// <summary><para>method outline:</para>
        /// <para>識別子の文字列変換</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySString csStr = GetString( )</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>文字列</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public abstract HySStringRoot GetString();
   
        /// <summary><para>method outline:</para>
        /// <para>識別子の文字列変換</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> String sStr = ToString( )</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>文字列</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        new public abstract String ToString();
        ///// <summary><para>method outline:</para>
        ///// <para>復元後の整合性確保処理</para>
        ///// </summary>
        ///// <example><para>usage:</para>
        ///// <para> PostDeserialize( ) </para>
        ///// </example>
        ///// <param name="">無し</param>
        ///// <returns>無し</returns>
        ///// <exception cref="">無し</exception>
        ///// <remarks><para>remarks:</para>
        ///// <para>シリアライズされた旧バージョン情報を復元する際、過去の整合性をとる時に使用する
        ///// バージョンによって変数等追加が発生した場合にオーバーライドして実装する。
        ///// </para>
        ///// </remarks>
        //public abstract void PostDeserialize();
    }
}
