﻿// <summary>ソースコード：システムイベント基底クラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;
using System.Runtime.Serialization;

namespace CommonMP.HYSSOP.Interface.HSData
{
    /// <summary><para>class outline:</para>
    /// <para>システムイベントＩ／Ｆ</para>
    /// </summary>
    /// <remarks><para>remarks:</para>
    /// <para>本クラスの派生クラスは全て[Serializable]であること</para>
    /// </remarks>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2008/10/01][新規作成]</para>
    /// </remarks>
    [Serializable]
    public abstract class HySSysEvent : HySDataRoot, HySVersionManagement
    {

        /// <summary>送信元識別番号</summary>
        protected long m_lFrom = HySSysEvent.OBJID_DEFAULT;
        /// <summary>送信先識別番号</summary>
        protected long m_lTo = HySSysEvent.OBJID_DEFAULT;

        /// <summary><para>method outline:</para>
        /// <para>デフォルトコンストラクター</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySSysEvent csSysEvent = new HySSysEvent( )</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>生成オブジェクト</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>        
        public HySSysEvent()
        {
            //バージョン情報設定
            SetNowVersion();
        }
       
        /// <summary><para>method outline:</para>
        /// <para>コンストラクター</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySSysEvent csSysEvent = new HySSysEvent( lTo )</para>
        /// </example>
        /// <param name="lTo">送信先</param>
        /// <returns>生成オブジェクト</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>        
        public HySSysEvent(long lTo)
        {
            //m_lFrom = lFrom;
            m_lTo = lTo;
            //バージョン情報設定
            SetNowVersion();
        }

        /// <summary><para>method outline:</para>
        /// <para>宛先識別番号を取得する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> long lTo = To() </para>
        /// </example>
        /// <returns>宛先識別番号</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public long To()
        {
            return m_lTo;
        }

        /// <summary><para>method outline:</para>
        /// <para>差出元識別番号を取得する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> long lFrom = From() </para>
        /// </example>
        /// <returns>差出元識別番号</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public long From()
        {
            return m_lFrom;
        }

        /// <summary><para>method outline:</para>
        /// <para>送信先識別番号を設定する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetTo( lTo ) </para>
        /// </example>
        /// <param name="lTo">送信先</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetTo(long lTo)
        {
            m_lTo = lTo;
        }
        /// <summary><para>method outline:</para>
        /// <para>差出元識別番号を設定する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetFrom( lFrom ) </para>
        /// </example>
        /// <param name="lFrom">送信元</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetFrom( long lFrom )
        {
            m_lFrom = lFrom;
        }

        // =====================================
        // start of 宛先等識別子定義
        // =====================================
        /// <summary>デフォルト値</summary>
        public static readonly long OBJID_DEFAULT = -1;
        /// <summary>システム全体制御部</summary>
        public static readonly long OBJID_SYSCONTROLLER = 0;
        /// <summary>業務処理部</summary>
        public static readonly long OBJID_BUSIPROCEDURE = 1;
        /// <summary>ビューア部</summary>
        public static readonly long OBJID_VIEWER = 2;
        /// <summary>演算部</summary>
        public static readonly long OBJID_SIMULATOR = 3;
        /// <summary>ライブラリ等管理部</summary>
        public static readonly long OBJID_LIBMANAGER = 4;
        /// <summary>GIS制御部</summary>
        public static readonly long OBJID_GISCONTROLLER = 5;
        /// <summary>イベント制御部</summary>
        public static readonly long OBJID_EVENTMANAGER = 6;
        // =====================================
        // end of 宛先等識別定義
        // =====================================

        // ================================================
        //   バージョンアップ時の下位互換性を保つ為の処理
        // ================================================
        /// <summary>保存バージョン情報</summary>
        private string m_sDecodedVersion;
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> string sDecodedVersion = GetDecodedVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>string 保存バージョン情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>メンバー変数に設定されているバージョン情報を返す</para>
        /// </remarks>
        public string GetDecodedVersion()
        {
            return m_sDecodedVersion;
        }
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> string sVersion = GetNowVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>string 現在のバージョン情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public string GetNowVersion()
        {
            return "1.00";
        }
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetNowVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>現在のバージョン情報をメンバー変数に設定する</para>
        /// </remarks>
        public void SetNowVersion()
        {
            m_sDecodedVersion = GetNowVersion();
        }
        /// <summary><para>method outline:</para>
        /// <para>復元後の整合性確保処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> PostDeserialize( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>シリアライズされた旧バージョン情報を復元する際、過去の整合性をとる時に使用する
        /// バージョンによって変数等追加がない場合には、実装の必要がない
        /// </para>
        /// </remarks>
        public virtual void PostDeserialize()
        {
            if (GetDecodedVersion() != GetNowVersion())
            {
                //旧バージョンから順にバージョンを上げて行く
                switch (GetDecodedVersion())
                {
                    case "1.00":
                        break;
                }
                SetNowVersion();
            }
        }
        /// <summary><para>method outline:</para>
        /// <para>逆シリアル化時追加処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> IDeserializationCallback.OnDeserialization(csObj)</para>
        /// </example>
        /// <param name="csObj">ダミー</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>予約処理</para>
        /// </remarks>
        void IDeserializationCallback.OnDeserialization(Object csObj)
        {
            PostDeserialize();
        }
    }
}
