﻿// <summary>ソースコード：バージョン管理用基底Ｉ／Ｆクラス</summary>
// <author>CommonMP</author>
using System;
using System.Collections.Generic;
using System.Text;
using System.Runtime.Serialization;

namespace CommonMP.HYSSOP.Interface.HSData
{
    /// <summary><para>class outline:</para>
    /// <para>バージョン管理用基底Ｉ／Ｆクラス</para>
    /// </summary>
    /// <remarks><para>remarks:</para>
    /// <para>バージョン管理が必要なデータクラスの基底Ｉ／Ｆクラス</para>
    /// </remarks>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2009/08/06][新規作成]</para>
    /// </remarks>
    public interface HySVersionManagement : HySRoot, IDeserializationCallback
    {
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> string sDecodedVersion = GetDecodedVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>string 保存バージョン情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>メンバー変数に設定されているバージョン情報を返す</para>
        /// </remarks>
        string GetDecodedVersion();

        /// <summary><para>method outline:</para>
        /// <para>バージョン情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> string dVersion = GetNowVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>string 現在のバージョン情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        string GetNowVersion();

        /// <summary><para>method outline:</para>
        /// <para>バージョン情報設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetNowVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>現在のバージョン情報をメンバー変数に設定する</para>
        /// </remarks>
        void SetNowVersion();

        /// <summary><para>method outline:</para>
        /// <para>復元後の整合性確保処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> PostDeserialize( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>シリアライズされた旧バージョン情報を復元する際、過去の整合性をとる時に使用する
        /// バージョンによって変数等追加がない場合には、実装の必要がない
        /// </para>
        /// </remarks>
        void PostDeserialize();

        //---------------------------------------------------
        //各データクラス実装例
        //---------------------------------------------------
        /* ******************   実装例　 *******************
        // using System.Runtime.Serialization; が必要
        //クラス宣言部に　HySVersionManagement　継承宣言追加　下記参考例
        public class McProjectInfData : HySDataRoot, HySVersionManagement

        //コンストラクタに　SetNowVersion()　追加　下記参考例
        /// <summary><para>method outline:</para>
        /// <para>デフォルトコンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>McProjectInfData csProjectInfData = new McProjectInfData();</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>McProjectInfData 生成されたインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public McProjectInfData()
        {
            m_csProjectName = new HySString("");
        
            // default 
            DateTime csDatatime = DateTime.Now;
            m_csStartSimuTime = HySCalendar.CreateTime(csDatatime.Year, csDatatime.Month, csDatatime.Day, csDatatime.Hour, 0, 0);
            m_csDeltaTime = new HySTime(1, 0, 0);
            m_csEndSimuTime = m_csStartSimuTime + 5.0*m_csDeltaTime;
        
            //バージョン情報設定
            SetNowVersion();
        }

        //定数定義
        ///// <summary>保存バージョン情報</summary>
        private string m_sDecodedVersion;    //本データクラス生成時のバージョン情報（コンストラクタにて SetNowVersion() 実行のこと）

        //実装メソッド
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> string sDecodedVersion = GetDecodedVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>string 保存バージョン情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>メンバー変数に設定されているバージョン情報を返す</para>
        /// </remarks>
        public string GetDecodedVersion()
        {
            return m_sDecodedVersion;  //メンバー変数のバージョン情報
        }

        /// <summary><para>method outline:</para>
        /// <para>バージョン情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> string sVersion = GetNowVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>string 現在のバージョン情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public string GetNowVersion()
        {
            return "1.00";
        }

        /// <summary><para>method outline:</para>
        /// <para>バージョン情報設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetNowVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>現在のバージョン情報をメンバー変数に設定する</para>
        /// </remarks>
        public void SetNowVersion()
        {
            m_sDecodedVersion = GetNowVersion();
        }

        /// <summary><para>method outline:</para>
        /// <para>復元後の整合性確保処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> PostDeserialize( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>シリアライズされた旧バージョン情報を復元する際、過去の整合性をとる時に使用する
        /// バージョンによって変数等追加がない場合には、実装の必要がない
        /// </para>
        /// </remarks>
        public virtual void PostDeserialize()
        //public override void PostDeserialize()   //バージョン管理されているデータクラスを継承している場合
        {
            //base.PostDeserialize();   //バージョン管理されているデータクラスを継承している場合
        
            if(GetDecodedVersion() != GetNowVersion())
            {
                //旧バージョンから順にバージョンを上げて行く
                switch (GetDecodedVersion())
                {
                    case "XXXX1":
                        //バージョンアップ処理(XXXX1 -> XXXX2)
                    case "XXXX2":
                        //バージョンアップ処理(XXXX2 -> XXXX3)
                    case "XXXX3":
                        //バージョンアップ処理(XXXX3 -> 最新)
                        SetNowVersion();
                        break;
                }
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>逆シリアル化時追加処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> IDeserializationCallback.OnDeserialization(csObj)</para>
        /// </example>
        /// <param name="csObj">ダミー</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>予約処理</para>
        /// </remarks>
        void IDeserializationCallback.OnDeserialization(Object csObj)
        {
            //シリアル化時にもコールされている？？ようなので注意すること
            PostDeserialize();
        }
        **************************** */
    }
}
