﻿// <summary>ソースコード：ＧＩＳエンジンＩ／Ｆ</summary>
// <author>CommonMP</author>
using System;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.Interface.HSController;
using CommonMP.HYSSOP.Interface.HSData;

namespace CommonMP.HYSSOP.Interface.HSGIS
{
    /// <summary><para>class outline:</para>
    /// <para>ＧＩＳエンジンＩ／Ｆ</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2008/10/01][新規作成]</para>
    /// </remarks>
    public interface HySGISEngine : HySSysUnit
    {
        /// <summary><para>method outline:</para>
        /// <para>初期化処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bRtn = Initialize( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>true:正常、false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        Boolean Initialize();
        /// <summary><para>method outline:</para>
        /// <para>終了処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bRtn = Terminate( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>true:正常、false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        Boolean Terminate();

        /// <summary><para>method outline:</para>
        /// <para>ＧＩＳ種別識別子取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySKind csKind = GetGISKind()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>ＧＩＳ種別識別子</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        HySKind GetGISKind();
        /// <summary><para>method outline:</para>
        /// <para>ＧＩＳ種別識別子比較</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bRtn = EqualGISKind(csGISKindID)</para>
        /// </example>
        /// <param name="csGISKindID">ＧＩＳ種別識別子</param>
        /// <returns>true  : 同じ、false : 異なる</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        Boolean EqualGISKind(HySKind csGISKindID);

        /*
        /// <summary><para>method outline:</para>
        /// <para>ＧＩＳＣＯＴＳ立ち上がり報告通知</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> NoticeGISCOTSStart()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        void NoticeGISCOTSStart();
        /// <summary><para>method outline:</para>
        /// <para>ＧＩＳＣＯＴＳ終了処理開始通知</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> NoticeGISCOTSGoToStop()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        void NoticeGISCOTSGoToStop();
        */

        /// <summary><para>method outline:</para>
        /// <para>ＧＩＳ情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bRtn = GetGISInfo(ref csGISInfo)</para>
        /// </example>
        /// <param name="csGISInfo">ＧＩＳ情報</param>
        /// <returns>true  : 正常、false : 異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>
        /// 引数で要求されたＧＩＳ関連情報を取得する
        /// （通常は、指定ファイルに出力する）</para>
        /// </remarks>
        Boolean GetGISInfo(ref HySGISInfo csGISInfo);
        /// <summary><para>method outline:</para>
        /// <para>ＧＩＳ情報設定通知</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bRtn = PutGISInfo( csGISInfo,bOkNgFlg)</para>
        /// </example>
        /// <param name="csGISInfo">ＧＩＳ情報</param>
        /// <param name="bOkNgFlg">=true:情報取得OK,=false:情報取得NG</param>
        /// <returns>true  : 正常、false : 異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>
        /// ＧＩＳ側で設定した情報をCommonMPへ通知する
        /// （通常は、指定ファイルに出力する）</para>
        /// </remarks>
        Boolean PutGISInfo(HySGISInfo csGISInfo,Boolean bOkNgFlg);
    }
}
