﻿// <summary>ソースコード：ＧＩＳファクトリクラスＩ／Ｆ</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.Interface.HSController;
using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.Interface.HSViewer;

namespace CommonMP.HYSSOP.Interface.HSGIS
{
    /// <summary><para>class outline:</para>
    /// <para>ＧＩＳファクトリクラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2008/10/01][新規作成]</para>
    /// </remarks>
    public interface HySGISFactory : HySFactory
    {
        /// <summary><para>method outline:</para>
        /// <para>ＧＩＳ種別識別子取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySKind csKind = GetGISKind()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>ＧＩＳ種別識別子</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        HySKind GetGISKind();
        /// <summary><para>method outline:</para>
        /// <para>GIS種別識別子比較</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bRtn = EqualGISKind(csGISKindID)</para>
        /// </example>
        /// <param name="csGISKindID">GIS種別識別子</param>
        /// <returns>true  : 同じ、false : 異なる</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        Boolean EqualGISKind(HySKind csGISKindID);

        /// <summary><para>method outline:</para>
        /// <para>ＧＩＳエンジンクラス生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySGISEngine csGISEngine = CreateGIS( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>ＧＩＳエンジンクラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        HySGISEngine CreateGIS();

        /*
        /// <summary><para>method outline:</para>
        /// <para>スクリーンクラス生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySGISView csView = CreateGISView( csGISViewKind,csID ) </para>
        /// </example>
        /// <param name="csGISViewKind">ＧＩＳビュー種別</param>
        /// <param name="csID">識別子</param>
        /// <returns>ＧＩＳビュー</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        //HySGISView CreateGISView(HySKind csGISViewKind, HySIdentifier csID);
        */
        /*
        /// <summary><para>method outline:</para>
        /// <para>ＧＩＳ情報クラス生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySGISInfo csGISInfo = CreateGISInfo( csGISInfoKind,csID ) </para>
        /// </example>
        /// <param name="csGISInfoKind">ＧＩＳ情報種別</param>
        /// <param name="csID">識別子</param>
        /// <returns>ＧＩＳビュー</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        HySGISInfo CreateGISInfo(HySKind csGISInfoKind, HySIdentifier csID);
        */
    }
}
