// <summary>ソースコード：シミュレーション用データ生成Ｉ／Ｆ</summary>
// <author>CommonMP</author>
using System;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.Interface;
using CommonMP.HYSSOP.Interface.HSController;
using CommonMP.HYSSOP.Interface.HSData;

namespace CommonMP.HYSSOP.Interface.HSSimulator
{
    /// <summary><para>class outline:</para>
    /// <para>シミュレーション用データ生成Ｉ／Ｆ</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2009/12/01][新規作成]</para>
    /// </remarks>
    public interface HySSimulationDataGenerator : HySRoot
    {
        /// <summary><para>method outline:</para>
        /// <para>シミュレーション用情報生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bRtn = CreateSimulationInfo(ref csEvent)</para>
        /// </example>
        /// <param name="csEvent">送られたイベント（必要ならば使用する）</param>
        /// <returns>true  : 正常、false : 異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>
        /// 引数で要求されたシミュレーション用情報を生成する
        /// （通常は、指定ファイルに出力する）</para>
        /// </remarks>
        Boolean CreateSimulationInfo(ref HySSysEvent csEvent);

        /// <summary><para>method outline:</para>
        /// <para>シミュレーション用情報生成中止</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bRtn = BreakCreation(ref csEvent)</para>
        /// </example>
        /// <param name="csEvent">送られたイベント（必要ならば使用する）</param>
        /// <returns>true  : 正常、false : 異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>
        /// 引数で要求された情報でシミュレーション内部を構築する
        /// </para>
        /// </remarks>
        Boolean BreakCreation(ref HySSysEvent csEvent);
    }
}
