﻿// <summary>ソースコード：シミュレーターファクトリクラスＩ／Ｆ</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.Interface.HSController;
using CommonMP.HYSSOP.Interface.HSData;

namespace CommonMP.HYSSOP.Interface.HSSimulator
{
    /// <summary><para>class outline:</para>
    /// <para>シミュレーターファクトリクラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2008/10/01][新規作成]</para>
    /// </remarks>
    public interface HySSimulatorFactory : HySFactory //HySWithMngFactory
    {
        /// <summary><para>method outline:</para>
        /// <para>シミュレーター種別識別子取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySKind csKind = GetSimKind()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>シミュレーター種別識別子</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        HySKind GetSimKind();
        /// <summary><para>method outline:</para>
        /// <para>シミュレーター種別識別子比較</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bRtn = HySSimulator.EqualSimKind(csSimKindID)</para>
        /// </example>
        /// <param name="csSimKindID">シミュレーター種別識別子</param>
        /// <returns>
        /// <returns>true  : 同じ、false : 異なる</returns>
        /// </returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        Boolean EqualSimKind(HySKind csSimKindID);

        /// <summary><para>method outline:</para>
        /// <para>シミュレータークラス生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySSimulator csSimulator = CreateSimulator( csSimulatorKind,csID ) </para>
        /// </example>
        /// <param name="csSimulatorKind">シミュレーター種別識別子</param>
        /// <param name="csID">識別子</param>
        /// <returns>シミュレータークラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        HySSimulatorRoot CreateSimulator(HySKind csSimulatorKind, HySIdentifier csID);

        /// <summary><para>method outline:</para>
        /// <para>データコンテナクラス生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySContainer csDataCont = CreateDataContainer( csSimulatorKind, csID ) </para>
        /// </example>
        /// <param name="csSimulatorKind">シミュレーター種別識別子</param>
        /// <param name="csID">識別子</param>
        /// <returns>データコンテナクラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        HySContainer CreateDataContainer(HySKind csSimulatorKind, HySIdentifier csID);

        /// <summary><para>method outline:</para>
        /// <para>シミュレーション用データ生成クラス生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySSimulationDataGenerator csDataGenerator = CreateSimulationDataGenerator( csSimulatorKind,csID ) </para>
        /// </example>
        /// <param name="csSimulatorKind">シミュレーター種別識別子</param>
        /// <param name="csID">識別子</param>
        /// <returns>シミュレーション用データ生成クラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        HySSimulationDataGenerator CreateSimulationDataGenerator(HySKind csSimulatorKind, HySIdentifier csID);
    }
}
