﻿// <summary>ソースコード：演算を行うクラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.Interface.HSController;
using CommonMP.HYSSOP.Interface.HSTools;

namespace CommonMP.HYSSOP.Interface.HSSimulator
{
    /// <summary><para>class outline:</para>
    /// <para>シミュレーション演算を行う</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2008/10/01][新規作成]</para>
    /// </remarks>
    public interface HySSimulatorRoot : HySRoot // HySSysUnit
    {
        // ====================================
        // 各種設定
        // ====================================
        /// <summary><para>method outline:</para>
        /// <para>シミュレーター種別識別子設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetSimKind(csSimKindID)</para>
        /// </example>
        /// <param name="csSimKindID">シミュレーター種別識別子</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        void SetSimKind(HySKind csSimKindID);
        /// <summary><para>method outline:</para>
        /// <para>シミュレーター種別識別子取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySKind csKind = GetSimKind()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>シミュレーター種別識別子</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        HySKind GetSimKind();
        /// <summary><para>method outline:</para>
        /// <para>シミュレーター種別識別子比較</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bRtn = HySSimulator.EqualSimKind(csSimKindID)</para>
        /// </example>
        /// <param name="csSimKindID">シミュレーター種別識別子</param>
        /// <returns>
        /// <returns>true  : 同じ、false : 異なる</returns>
        /// </returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        Boolean EqualSimKind(HySKind csSimKindID);

        /// <summary><para>method outline:</para>
        /// <para>識別子設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetID( csID ) </para>
        /// </example>
        /// <param name="csID">識別子</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        void SetID(HySIdentifier csID);
        /// <summary><para>method outline:</para>
        /// <para>識別子取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySIdentifier csID = GetID( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>識別子</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        HySIdentifier GetID();
        /// <summary><para>method outline:</para>
        /// <para>識別子による同一比較</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bRtn = Equal( csID ) </para>
        /// </example>
        /// <param name="csID">比較する種別識別子</param>
        /// <returns>  true :＝ , false:≠</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        Boolean Equal(HySIdentifier csID);

        // ＝＝　シミュレーション時間関係管理　＝＝

        /// <summary><para>method outline:</para>
        /// <para>シミュレーション計算初期時刻設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetSimuStartTime( csTm )</para>
        /// </example>
        /// <param name="csTm">時刻</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        void SetSimuStartTime(HySDate csTm);
        /// <summary><para>method outline:</para>
        /// <para>目標時間設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetSimuGoalTime( csTm )</para>
        /// </example>
        /// <param name="csTm">時刻</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        void SetSimuGoalTime(HySDate csTm);
        /// <summary><para>method outline:</para>
        /// <para>シミュレーション計算時刻設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetSimuTIme( csTm )</para>
        /// </example>
        /// <param name="csTm">時刻</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        void SetSimuTime(HySDate csTm);
        /// <summary><para>method outline:</para>
        /// <para>演算時刻を取得する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>HySDate csSimuTime = GetSimuTime()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>演算時刻</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        HySDate GetSimuTime();
        /// <summary><para>method outline:</para>
        /// <para>演算目標時刻を設定する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetSimuDeltaTime(csDltTime)</para>
        /// </example>
        /// <param name="csDltTime">演算刻み時間</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        void SetSimuDeltaTime(HySDate csDltTime);

        /// <summary><para>method outline:</para>
        /// <para>シミュレーターファクトリクラス設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetSimulatorFactory( csSimulatorFactory ) </para>
        /// </example>
        /// <param name="csSimulatorFactory">シミュレーターファクトリクラス</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        void SetSimulatorFactory(HySSimulatorFactory csSimulatorFactory);
        /// <summary><para>method outline:</para>
        /// <para>コンテナ設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetContainer( csContainer ) </para>
        /// </example>
        /// <param name="csContainer">コンテナクラス</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        void SetContainer(HySSimulationContainer csContainer);
        /// <summary><para>method outline:</para>
        /// <para>コンテナ取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySContainer csCntainer = GetContainer() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>コンテナインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        HySSimulationContainer GetContainer();

        /// <summary><para>method outline:</para>
        /// <para>演算スレッド制御クラス設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetSimThreadCtl( csThrdCtl ) </para>
        /// </example>
        /// <param name="csThrdCtl">演算スレッド制御クラス</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        void SetSimThreadCtl(HySSimThreadCtl csThrdCtl);

        // ====================================
        // 立ち上がり、終了
        // ====================================
        /// <summary><para>method outline:</para>
        /// <para>初期化処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bRtn = Initialize( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>true:正常、false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        Boolean Initialize();
        /// <summary><para>method outline:</para>
        /// <para>終了処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>  bool bRtn = Terminate( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>true</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        Boolean Terminate();
 
        /// <summary><para>method outline:</para>
        /// <para>内部演算モデル作成処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bRtn = ModelConstruction(csEvent) </para>
        /// </example>
        /// <param name="csEvent">送られたイベント（必要ならば使用する）</param>
        /// <returns>true:正常、false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        Boolean ModelConstruction(HySSysEvent csEvent);

        // ====================================
        // 演算実行
        // ====================================
        /// <summary><para>method outline:</para>
        /// <para>シミュレーションの初期化</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bRtn = CmdInitializeSimulation( csEvent ) </para>
        /// </example>
        /// <param name="csEvent">送られたイベント（必要ならば使用する）</param>
        /// <returns>true:=正常, false:=異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        Boolean CmdInitializeSimulation(HySSysEvent csEvent);
        /// <summary><para>method outline:</para>
        /// <para>シミュレーション計算の開始</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bRtn = CmdStartSimulation( csEvent ) </para>
        /// </example>
        /// <param name="csEvent">送られたイベント（必要ならば使用する）</param>
        /// <returns>true:=正常, false:=異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        Boolean CmdStartSimulation(HySSysEvent csEvent);
        /// <summary><para>method outline:</para>
        /// <para>シミュレーション計算の中断</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bRtn = CmdPauseSimulation( csEvent ) </para>
        /// </example>
        /// <param name="csEvent">送られたイベント（必要ならば使用する）</param>
        /// <returns>true:=正常, false:=異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        Boolean CmdPauseSimulation(HySSysEvent csEvent);
        /// <summary><para>method outline:</para>
        /// <para>シミュレーション計算の再開</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bRtn = CmdRestartSimulation( csEvent ) </para>
        /// </example>
        /// <param name="csEvent">送られたイベント（必要ならば使用する）</param>
        /// <returns>true:=正常, false:=異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        Boolean CmdRestartSimulation(HySSysEvent csEvent);
        /// <summary><para>method outline:</para>
        /// <para>シミュレーション計算の終了</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bRtn = CmdStopSimulation( csEvent ) </para>
        /// </example>
        /// <param name="csEvent">送られたイベント（必要ならば使用する）</param>
        /// <returns>true:=正常, false:=異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        Boolean CmdStopSimulation(HySSysEvent csEvent);
        /// <summary><para>method outline:</para>
        /// <para>シミュレーション計算の進捗を取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bRtn = GetSimulationProgress( csEvent ) </para>
        /// </example>
        /// <param name="csEvent">送られたイベント（必要ならば使用する）</param>
        /// <returns>進捗（０～１００％）</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        long GetSimulationProgress(HySSysEvent csEvent);
        /// <summary><para>method outline:</para>
        /// <para>任意イベント</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bRtn = CmdArbitraryEvent( csEvent ) </para>
        /// </example>
        /// <param name="csEvent">送られたイベント（必要ならば使用する）</param>
        /// <returns>true:=正常, false:=異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        Boolean CmdArbitraryEvent(HySSysEvent csEvent);
        /// <summary><para>method outline:</para>
        /// <para>計算実行の終了</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bRtn = TerminateCalculation( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>true:正常、false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>具体的には計算を行っていたスレッドが終了する</para>
        /// </remarks>
        Boolean TerminateCalculation();

        /// <summary><para>method outline:</para>
        /// <para>シミュレーター間データ交換用コンテナに演算結果を出力する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bRtn = MediateDataOut( csDataContainer ) </para>
        /// </example>
        /// <param name="csDataContainer">シミュレーター間データ交換用コンテナ</param>
        /// <returns>true:=正常, false:=異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        Boolean OutputMediateData(HySContainer csDataContainer);
        /// <summary><para>method outline:</para>
        /// <para>シミュレーター間データ交換用コンテナから他のシミュレーターの演算結果を取り入れる</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bRtn = InputMediateData( csDataContainer ) </para>
        /// </example>
        /// <param name="csDataContainer">シミュレーター間データ交換用コンテナ</param>
        /// <returns>true:=正常, false:=異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        Boolean InputMediateData(HySContainer csDataContainer);

        /// <summary><para>method outline:</para>
        /// <para>シミュレーション計算内部情報を全て出力する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bRtn = SerializeAllInfo( csData ) </para>
        /// </example>
        /// <param name="csData">保存データ</param>
        /// <returns>true:=正常, false:=異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>計算中断した状態で内容を全て保存しておく必要がある場合等に使用する</para>
        /// </remarks>
        Boolean SerializeAllInfo(HySDataRoot csData);
        /// <summary><para>method outline:</para>
        /// <para>シミュレーション計算内部情報を全て入力・復元する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bRtn = StructureAllInfo( csData ) </para>
        /// </example>
        /// <param name="csData">保存データ</param>
        /// <returns>true:=正常, false:=異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>計算中断した状態で内容を全て保存しておく必要がある場合等に使用する</para>
        /// </remarks>
        Boolean StructureAllInfo(HySDataRoot csData);
    }
}
