﻿// <summary>ソースコード：アーカイブ機能の共通I/Fクラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.Interface;

namespace CommonMP.HYSSOP.Interface.HSTools
{
    /// <summary><para>class outline:</para>
    /// <para>アーカイブ機能の共通I/Fクラス</para>
    /// </summary>
    /// <remarks><para>remarks:</para>
    /// <para>無し</para>
    /// </remarks>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2009/12/03][新規作成]</para>
    /// </remarks>
    public interface HySArchiver : HySRoot
    {
        /// <summary><para>method outline:</para>
        /// <para>アーカイブ対象ファイルの登録</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> AddEntry( KeyValuePair entry); </para>
        /// </example>
        /// <param name="entry">エントリ情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        void AddEntry( KeyValuePair< HySStringRoot ,HySStringRoot> entry);

        /// <summary><para>method outline:</para>
        /// <para>アーカイブ対象ファイルの登録</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>AddEntry(List entries); </para>
        /// </example>
        /// <param name="entries">エントリ情報リスト</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        void AddEntry(List<KeyValuePair<HySStringRoot, HySStringRoot>> entries);

        /// <summary><para>method outline:</para>
        /// <para>登録済みエントリの返却</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> List GetEntry();</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns> List </returns>
        /// <exception cref="">エントリ情報リスト</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        List<KeyValuePair<HySStringRoot, HySStringRoot>> GetEntry();

        /// <summary><para>method outline:</para>
        /// <para>アーカイブの作成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> csArchiver = Archive(HySString archiveFileFullPath);</para>
        /// </example>
        /// <param name="archiveFileFullPath">出力するアーカイブ名フルパス</param>
        /// <returns> 無し </returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        void Archive(HySStringRoot archiveFileFullPath);

    }
}
