﻿// <summary>ソースコード：エクスパンダー機能の共通I/Fクラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.Interface;

namespace CommonMP.HYSSOP.Interface.HSTools
{
    /// <summary><para>class outline:</para>
    /// <para>エクスパンダー機能の共通I/Fクラス</para>
    /// </summary>
    /// <remarks><para>remarks:</para>
    /// <para>無し</para>
    /// </remarks>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2009/12/24][新規作成]</para>
    /// </remarks>
    public interface HySExpander  : HySRoot
    {
        /// <summary><para>method outline:</para>
        /// <para>展開対象エントリ追加</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>AddTargetEntry(targetEntry); </para>
        /// </example>
        /// <param name="targetEntry">展開対象エントリ</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        void AddTargetEntry(HySStringRoot targetEntry);

        /// <summary><para>method outline:</para>
        /// <para>展開対象エントリ追加</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>AddTargetEntry(targetEntryList); </para>
        /// </example>
        /// <param name="targetEntryList">展開対象エントリリスト</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        void AddTargetEntry(List<HySStringRoot> targetEntryList);

        /// <summary><para>method outline:</para>
        /// <para>展開対象エントリ取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> List GetTargetEntry();</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>展開対象エントリリスト</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        List<HySStringRoot> GetTargetEntry();

        /// <summary><para>method outline:</para>
        /// <para>展開実行</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>Expand(outFolderFullPath);</para>
        /// </example>
        /// <param name="outFolderFullPath">出力先フォルダフルパス</param>
        /// <returns> 無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        void Expand(HySStringRoot outFolderFullPath);
    
        /// <summary><para>method outline:</para>
        /// <para>全エントリ取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>GetAllEntryName(); </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>エントリ名リスト</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        List<HySStringRoot> GetAllEntryName();

        /// <summary><para>method outline:</para>
        /// <para>Zipファイル読込み</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>long lRnt = Read()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>0:正常　-1:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        long Read();

        /// <summary><para>method outline:</para>
        /// <para>展開実行</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> EditExpand( outFolderFullPath ); </para>
        /// </example>
        /// <param name="outFolderFullPath">出力先フォルダフルパス</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        void EditExpand(HySStringRoot outFolderFullPath);

        /// <summary><para>method outline:</para>
        /// <para>エントリーファイル名変更</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> long lRtn = ChangeFileName( csOrgFileName, csNewFileName ); </para>
        /// </example>
        /// <param name="csOrgFileName">オリジナルファイルパス</param>
        /// <param name="csNewFileName">変更ファイルパス</param>
        /// <returns>0:変更成功 -1:変更失敗</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        long ChangeFileName(HySStringRoot csOrgFileName, HySStringRoot csNewFileName);

        /// <summary><para>method outline:</para>
        /// <para>ファイル破棄処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Dispose(); </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        void Dispose();

    }
}
