﻿// <summary>ソースコード：Ｉ／Ｏインターフェース</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.Interface.HSData;

namespace CommonMP.HYSSOP.Interface.HSTools
{
    /// <summary><para>class outline:</para>
    /// <para>Ｉ／Ｏインターフェース</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2008/10/01][新規作成]</para>
    /// </remarks>
    public interface HySIOStream : HySRoot
    {
        /// <summary><para>method outline:</para>
        /// <para>データの書き込み</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> DataWrite(csData) </para>
        /// </example>
        /// <param name="csData">データクラス</param>
        /// <returns>=true:正常、=false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        bool DataWrite( HySDataRoot csData);

        /// <summary><para>method outline:</para>
        /// <para>データの読み出し</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySDataRoot csData = DataRead() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>読み出したデータクラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        HySDataRoot DataRead( );
    }
}
