﻿// <summary>ソースコード：スクリーンファクトリクラスＩ／Ｆ</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.Interface.HSController;
using CommonMP.HYSSOP.Interface.HSData;

//★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★
// Ver1.3では下記コードを追加する（diconファイルへの登録不要化） 
//★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★
using CommonMP.HYSSOP.Interface;
namespace CommonMP.HYSSOP._SYSTEM_
{
    /// <summary><para>class outline:</para>
    /// <para>HYSSOPスクリーンファクトリ生成</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2009/10/01][新規作成]</para>
    /// </remarks>
    public interface HYSSOP_USRSCREEN_FACTORY_CREATOR : HySRoot
    {
        /// <summary><para>method outline:</para>
        /// <para>ファクトリクラス生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySScreenFactory csCalModelFactory = CreateFactory( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>スクリーンファクトリクラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        CommonMP.HYSSOP.Interface.HSViewer.HySScreenFactory CreateFactory();
    }
}

namespace CommonMP.HYSSOP.Interface.HSViewer
{
    /// <summary><para>class outline:</para>
    /// <para>スクリーンファクトリクラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2008/10/01][新規作成]</para>
    /// </remarks>
    public interface HySScreenFactory : HySFactory
    {
        /// <summary><para>method outline:</para>
        /// <para>シミュレーター種別識別設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetSimKind(csSimKindID)</para>
        /// </example>
        /// <param name="csSimKindID">シミュレーター種別識別子</param>
        /// <returns>なし</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        void SetSimKind(HySKind csSimKindID);
        /// <summary><para>method outline:</para>
        /// <para>シミュレーター種別識別子取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySKind csKind = GetSimKind()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySKind シミュレーター種別識別子</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        HySKind GetSimKind();
        /// <summary><para>method outline:</para>
        /// <para>シミュレーター種別識別子比較</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bRtn = HySSimulator.EqualSimKind(csSimKindID)</para>
        /// </example>
        /// <param name="csSimKindID">シミュレーター種別識別子</param>
        /// <returns>Boolean true:同じ、false:異なる</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        Boolean EqualSimKind(HySKind csSimKindID);

        /// <summary><para>method outline:</para>
        /// <para>スクリーンクラス生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySScreen csScreen = CreateScreen( csSimulatorKind,csID,csScreenKind ) </para>
        /// </example>
        /// <param name="csSimulatorKind">シミュレーター種別識別子</param>
        /// <param name="csID">識別子</param>
        /// <param name="csScreenKind">画面種別</param>
        /// <returns>HySScreen スクリーンクラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        HySScreen CreateScreen(HySKind csSimulatorKind, HySIdentifier csID, HySKind csScreenKind);
    }
}
