﻿// <summary>ソースコード：ビューア内処理ファクトリクラスＩ／Ｆ</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.Interface.HSController;
using CommonMP.HYSSOP.Interface.HSData;

//★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★
// Ver1.3では下記コードを追加する（diconファイルへの登録不要化） 
//★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★
using CommonMP.HYSSOP.Interface;
namespace CommonMP.HYSSOP._SYSTEM_
{
    /// <summary><para>class outline:</para>
    /// <para>HYSSOPビューア内処理ファクトリ生成</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2009/10/01][新規作成]</para>
    /// </remarks>
    public interface HYSSOP_USRVIEWERJOB_FACTORY_CREATOR : HySRoot
    {
        /// <summary><para>method outline:</para>
        /// <para>ファクトリクラス生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySViewerJobFactory csCalModelFactory = CreateFactory( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>ビューア内処理ファクトリクラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        CommonMP.HYSSOP.Interface.HSViewer.HySViewerJobFactory CreateFactory();
    }
}

namespace CommonMP.HYSSOP.Interface.HSViewer
{
    /// <summary><para>class outline:</para>
    /// <para>ビューア内処理ファクトリ</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2008/10/01][新規作成]</para>
    /// </remarks>
    public interface HySViewerJobFactory : HySFactory
    {
        /// <summary><para>method outline:</para>
        /// <para>シミュレーター種別識別子取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySKind csKind = GetSimKind()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySKind シミュレーター種別識別子</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        HySKind GetSimKind();
        /// <summary><para>method outline:</para>
        /// <para>シミュレーター種別識別子比較</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bRtn = EqualSimKind(csSimKindID)</para>
        /// </example>
        /// <param name="csSimKindID">シミュレーター種別識別子</param>
        /// <returns>Boolean
        /// true  : 同じ
        /// false : 異なる
        /// </returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        Boolean EqualSimKind(HySKind csSimKindID);

        /// <summary><para>method outline:</para>
        /// <para>ビューアジョブクラス生成</para>   
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySViewrJob csViewerJob = CreateViewerJob( csID ) </para>
        /// </example>
        /// <param name="csID">識別子</param>
        /// <returns>HySViewerJob ビューアクラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        HySViewerJob CreateViewerJob(HySIdentifier csID);
    }
}
