﻿// <summary>ソースコード：ビューアクラスＩ／Ｆ</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.Interface.HSController;
using CommonMP.HYSSOP.Interface.HSData;

namespace CommonMP.HYSSOP.Interface.HSViewer
{
    /// <summary><para>class outline:</para>
    /// <para>ビューアクラスＩ／Ｆ</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2008/10/01][新規作成]</para>
    /// </remarks>
    public interface HySViewer : HySSysUnit
    {
        /// <summary><para>method outline:</para>
        /// <para>初期化処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bRtn = Initialize( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>true:正常、false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        Boolean Initialize();
        /// <summary><para>method outline:</para>
        /// <para>終了処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bRtn = Terminate( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>true:正常、false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        Boolean Terminate();

        /// <summary><para>method outline:</para>
        /// <para>ファクトリ管理クラス設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetFactoryManager( csFactoryManager ) </para>
        /// </example>
        /// <param name="csFactoryManager">ファクトリ管理クラス</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        void SetFactoryManager(HySFactoryMng csFactoryManager);

        /// <summary><para>method outline:</para>
        /// <para>ビューア内部処理クラス追加</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> AddViewerJob( csViewerJob ) </para>
        /// </example>
        /// <param name="csViewerJob">ビューア内部処理クラス</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        void AddViewerJob(HySViewerJob csViewerJob);
        /// <summary><para>method outline:</para>
        /// <para>ビューア内部処理クラスの取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>HySViewerJob csJob = GetViewerJob( ) </para>
        /// </example>
        /// <param name="csKey">取得識別子</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        HySViewerJob GetViewerJob(HySStringRoot csKey);

        /*
        /// <summary><para>method outline:</para>
        /// <para>画面へのイベント見張り（ウエイトしない）</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> TryWatchEvent( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>
        /// 画面側のタイマーからコールされて、
        /// 他の処理部から画面へのイベントを取り出し、
        /// 画面の　EventCallback() を呼ぶ</para>
        /// </remarks>
        void TryWatchEvent();
        */

        /// <summary><para>method outline:</para>
        /// <para>起動処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Run( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>通常Viewerはメインスレッド上で動作する為特別にメインループ動作開始トリガが必要</para>
        /// </remarks>
        void Run();
        /// <summary><para>method outline:</para>
        /// <para>プロセス終了</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Exit( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>通常Viewerはメインスレッド上で動作する為　特別にプロセス終了が必要</para>
        /// </remarks>
        void Exit();
    }
}
