﻿// <summary>ソースコード：GoogleEarth GISエンジン</summary>
// <author>CommonMP</author>
using System;
using System.Collections;
using System.Collections.Generic;
using System.Diagnostics;
using System.ComponentModel;
using System.Threading;

using CommonMP.HYSSOP.Interface.HSGIS;
using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.Interface.HSController;
using CommonMP.HYSSOP.Interface.HSBusiProc;

using CommonMP.HYSSOP.CoreImpl;
using CommonMP.HYSSOP.CoreImpl.HSController;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSGIS;
using CommonMP.HYSSOP.CoreImpl.HSTools;
using CommonMP.HYSSOP.CoreImpl.HSViewer;
using CommonMP.HYSSOP.CoreImpl.HSTools.Msg;

using EARTHLib;

namespace CommonMP.HYSSOP.OptionImpl.HSGIS.HySGoogleEarthGIS
{
    /// <summary><para>class outline:</para>
    /// <para>GoogleEarth GISエンジン</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.1.0][2011/05/01][新規作成]</para>
    /// <para>Remarks</para>
    /// </remarks>
    public class HySGoogleEarthGIS : HySGISEngine
    {
        /// <summary>GISエンジン制御</summary>
        protected HySGISController m_csController;

        /// <summary>応答を返すシミュレーター種別識別子関係</summary>
        protected HySObjectKind m_csAckSimKind = null;

        /// <summary> GoogleEarth API本体 </summary>
        public static IApplicationGE mg_csEarth = null;//new ApplicationGE()

        /// <summary><para>method outline:</para>
        /// <para>初期化処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bRtn = Initialize() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>true:正常、false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual Boolean Initialize()
        {
            HySLog.LogOut(HySLog.SYSTEM_DEBUG, "HySGoogleEarthGIS", "Initialize", "start"); // 必要に応じてログ出力
            // Do Nothing
            return true;           
        }

        /// <summary><para>method outline:</para>
        /// <para>終了処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bRtn = Terminate() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>true:正常、false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>Terminateが呼ばれた後は、同一インスタンスでは動作しない。</para>
        /// </remarks>
        public virtual Boolean Terminate()
        {
            HySLog.LogOut(HySLog.SYSTEM_DEBUG, "HySGoogleEarthGIS", "Terminate", "start"); // 必要に応じてログ出力
            // Do Nothing
            return true;
        }

        /// <summary><para>method outline:</para>
        /// <para>GISコントローラー設定処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetController(csCtl) </para>
        /// </example>
        /// <param name="csCtl">制御クラス</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void SetController(HySControllerRoot csCtl)
        {
            m_csController = (HySGISController)csCtl;
        }

        /// <summary><para>method outline:</para>
        /// <para>GIS種別識別子取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySKind csKind = GetGISKind( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>GIS種別識別子</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual HySKind GetGISKind()
        {
            return HySGoogleEarthDef.GIS_KIND_GOOGLE_EARTH;
        }

        /// <summary><para>method outline:</para>
        /// <para>GIS種別識別子比較</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bRtn = EqualGISKind(csGISKindID) </para>
        /// </example>
        /// <param name="csGISKindID">GIS種別識別子</param>
        /// <returns>同一の場合true、異なる場合false</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual Boolean EqualGISKind(HySKind csGISKindID)
        {
            return GetGISKind().Equals(csGISKindID);
        }

        /// <summary><para>method outline:</para>
        /// <para>イベントを送信する。</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bRtn = PutEvent(csEvent) </para>
        /// </example>
        /// <param name="csEvent">送信するイベント</param>
        /// <returns>正常時true、異常時false</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual Boolean PutEvent(HySSysEvent csEvent)
        {
            return m_csController.PutEvent(csEvent);
        }

        /// <summary><para>method outline:</para>
        /// <para>イベント受信時の処理を行う。</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bRtn = EventCallback(csEvent) </para>
        /// </example>
        /// <param name="csEvent">受信イベント</param>
        /// <returns>イベントを処理した場合true、処理しなかった場合false</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>以下のイベントを処理する。</para>
        /// <para>EventNo                        SubEventNo                        内容</para>
        /// <para>HySEventObject.CMND_GIS_COMMON HySEventObject.GIS_COTS_WAKEUP    GIS起動要求</para>
        /// <para>HySEventObject.CMND_GIS_COMMON HySEventObject.GIS_COTS_TERMINATE GIS終了要求</para>
        /// </remarks>
        public virtual Boolean EventCallback(HySSysEvent csEvent)
        {
            long event_no = ((HySEventObject)csEvent).GetEventNo();
            long sub_event_no = ((HySEventObject)csEvent).GetSubEventNo();

            if (event_no == HySEventObject.CMND_GIS_COMMON)
            {   // GIS 共通イベント
                if (sub_event_no == HySGISDefine.GIS_COTS_WAKEUP)
                {   // GIS 立ち上げならば
                    return true;
                }
                else if (sub_event_no == HySGISDefine.GIS_COTS_TERMINATE)
                {   // GIS 終了ならば
                    return true;
                }
                else if (sub_event_no == HySGISDefine.GET_GIS_INFO)
                {   // GIS 情報取得ならば
                    return true;
                }
            }
            return false;
        }

        /// <summary><para>method outline:</para>
        /// <para>システム終了準備完了判別</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bRtn = ExitOK( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>true : システムExit準備OK　、false : システムExit準備NG</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual Boolean ExitOK()
        {
            // Do Nothing
            return true;
        }


        // ★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★
        //  start of モデルジェネレーター関連メソッド
        // ★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★
        /// <summary><para>method outline:</para>
        /// <para>ＧＩＳ情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bRtn = GetGISInfo(ref csGISInfo)</para>
        /// </example>
        /// <param name="csGISInfo">ＧＩＳ情報</param>
        /// <returns>true  : 正常、false : 異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>
        /// 引数で要求されたＧＩＳ関連情報を取得する
        /// （通常は、指定ファイルに出力する）</para>
        /// </remarks>
        public bool GetGISInfo(ref HySGISInfo csGISInfo)
        {
            // Do Nothing
            return false;
        }
        /// <summary><para>method outline:</para>
        /// <para>ＧＩＳ情報設定通知</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bRtn = PutGISInfo( csGISInfo,bOkNgFlg)</para>
        /// </example>
        /// <param name="csGISInfo">ＧＩＳ情報</param>
        /// <param name="bOkNgFlg">=true:情報取得OK,=false:情報取得NG</param>
        /// <returns>true  : 正常、false : 異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>
        /// ＧＩＳ側で設定した情報をCommonMPへ通知する
        /// （通常は、指定ファイルに出力する）</para>
        /// </remarks>
        public bool PutGISInfo(HySGISInfo csGISInfo, bool bOkNgFlg)
        {
            // Do Nothing
            return false;
        }
        // ★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★
        //  end   of モデルジェネレーター関連メソッド
        // ★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★

    }
}
