﻿// <summary>ソースコード：HySGoogleEarth背景地図ビュー</summary>
// <author>CommonMP</author>
using System;
using System.IO;
using System.Collections.Generic;
using System.Threading;
using System.Text;

using CommonMP.HYSSOP.Interface.HSGIS;
using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.Interface.HSController;
using CommonMP.HYSSOP.CoreImpl.HSController;
using CommonMP.HYSSOP.CoreImpl.HSGIS;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;


using EARTHLib;

namespace CommonMP.HYSSOP.OptionImpl.HSGIS.HySGoogleEarthGIS
{
    /// <summary><para>class outline:</para>
    /// <para>HySGoogleEarth背景地図ビュー</para>
    /// </summary>
    /// <remarks>
    /// <para>History:</para>
    /// <para>[CommonMP][ver 1.1.0][2011/05/01][新規作成]</para>
    /// <para>インスタンスは一つのみ(背景地図は１画面のみ)</para>
    /// </remarks>
    public class HySGoogleEarthBaseMapView : HySGISBaseMapView
    {
        /// <summary><para>method outline:</para>
        /// <para>初期化処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Initialize( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void Initialize()
        {
            // Do Nothing
            // Google Earth の場合には処理実装せず
        }

        /// <summary><para>method outline:</para>
        /// <para>終了処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Terminate( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void Terminate()
        {
            // Do Nothing
            // Google Earth の場合には処理実装せず
        }

        /// <summary><para>method outline:</para>
        /// <para>画面表示</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Show( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>SetDispMapData()で指定された位置を表示する。</para>
        /// </remarks>
        public override void Show()
        {
            if (HySGoogleEarthGIS.mg_csEarth == null)
            {
                HySGoogleEarthGIS.mg_csEarth = new ApplicationGE();
                System.Threading.Thread.Sleep(2000);   // Google Earthの立ち上がりを待つため
            }

            // カメラ位置等
            double dRange=0.0; long lTilt=0;long lAzimuth = 0;
            m_csMapCtlData.GetCamera(ref  dRange, ref  lTilt, ref  lAzimuth);

            // 視点位置
            CameraInfoGE cam = new CameraInfoGE();
            cam.FocusPointLatitude = m_csMapCtlData.GetFocusPoint().m_dLatitude;
            cam.FocusPointLongitude = m_csMapCtlData.GetFocusPoint().m_dLongitude;
            cam.Range = dRange;
            cam.Tilt = lTilt;
            cam.Azimuth = lAzimuth;

            for (int iLp = 0; iLp < 30; iLp++)
            {   // Google Earth が立ち上がるまで、繰り返し命令を発令する
                try
                {
                    HySGoogleEarthGIS.mg_csEarth.SetCamera(cam, 0.5);
                    break;
                }
                catch (Exception e)
                {
                    System.Threading.Thread.Sleep(1000);   // 立ち上がりを待つため
                }
            }
            HySLog.LogOut(HySLog.SYSTEM_DEBUG, "HySGoogleEarthBaseMapView", "Show", "start"); // 必要に応じてログ出力
        }

        /// <summary><para>method outline:</para>
        /// <para>画面非表示化</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Hide( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>なにもしない。</para>
        /// </remarks>
        public override void Hide()
        {
            // Do Nothing
            // Google Earth の場合には処理実装せず
        }

        /// <summary><para>method outline:</para>
        /// <para>画面更新</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Renew( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>SetDispMapData()で指定された位置を表示する。</para>
        /// </remarks>
        public override void Renew()
        {
            Show();
        }

        /// <summary><para>method outline:</para>
        /// <para>画面消去</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Close( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>なにもしない。</para>
        /// </remarks>
        public override void Close()
        {
            // To Do
            // 背景地図画面を閉じる
            // Google Earth の場合には処理実装せず
        }

        /// <summary><para>method outline:</para>
        /// <para>背景地図上でのイベント時処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> NoticeMapEvent(eKind) </para>
        /// </example>
        /// <param name="eKind">イベント種別</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>なにもしない。</para>
        /// </remarks>
        public override void NoticeMapEvent(HySGISBaseMapView.EventKind eKind)
        {
            // Do Nothing
            //  ＝＝＝　将来用　＝＝＝
        }

        /// <summary><para>method outline:</para>
        /// <para>背景地図上でのイベント取得モード移行指示</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> long lRtn = CmndGetMapEventMode(eKind) </para>
        /// </example>
        /// <param name="eKind">イベント種別</param>
        /// <returns>モード移行成功：０　その他、モード移行失敗</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>なにもしない。</para>
        /// </remarks>
        public override long CmndGetMapEventMode(HySGISBaseMapView.EventKind eKind)
        {
            // To Do
            // 指示に従って、画面のモード等を変更する。
            // 例えば、eKind==EventKind.GET_POSITION ならば、
            //  画面のマウスクリック位置取得モードにして、マウスカーソルを＋にする　とか。。。
            //  ＝＝＝　将来用　＝＝＝
            return 0;
        }
    }
}
