﻿// <summary>ソースコード：HySGoogleEarth GISView ファクトリクラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.Interface;
using CommonMP.HYSSOP.Interface.HSController;
using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.Interface.HSGIS;
using CommonMP.HYSSOP.Interface.HSViewer;
using CommonMP.HYSSOP.CoreImpl;
using CommonMP.HYSSOP.CoreImpl.HSController;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;
using CommonMP.HYSSOP.CoreImpl.HSGIS;

namespace CommonMP.HYSSOP.OptionImpl.HSGIS.HySGoogleEarthGIS
{
    /// <summary><para>class outline:</para>
    /// <para>HySGoogleEarth GISViewファクトリクラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.1.0][2011/05/01][新規作成]</para>
    /// <para>Remarks</para>
    /// </remarks>
    public class HySGoogleEarthViewFactory : HySGISViewFactoryBase
    {
        /// <summary><para>method outline:</para>
        /// <para>画面フォームクラス生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySViewForm csViewFrom = CreateViewForm (csSimKind, csID, csGISViewKindID)</para>
        /// </example>
        /// <param name="csSimKind">シミュレーター種別識別子</param>
        /// <param name="csID">識別子</param>
        /// <param name="csGISViewKindID">画面種別</param>
        /// <returns>HySViewForm 画面フォームクラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        override public HySViewForm CreateViewForm(HySKind csSimKind, HySIdentifier csID, HySKind csGISViewKindID)
        {
            HySGISView csRtnView = null;

            if (csGISViewKindID.Equals(HySDefine.DISP_FORM_GIS_BASEMAP))
            {   // 背景地図ならば
                csRtnView = new HySGoogleEarthBaseMapView();
            }
            else if (csGISViewKindID.Equals(HySDefine.DISP_FORM_GIS_FIGURE))
            {   // 図形表示ならば
                //csRtnView = new HySDioVistaMapFigureView();
            }
            else if (csGISViewKindID.Equals(HySDefine.DISP_FORM_HYDRO_HYETO_GRAPH))
            {   // ハイエト・ハイドロ関連グラフ表示ならば
                //csRtnView = new HySDioVistaHydroHyetoView();
            }
            else if (csGISViewKindID.Equals(HySDefine.DISP_FORM_HQ_GRAPH))
            {   // HQグラフ表示ならば
                //csRtnView = new HySDioVistaHQGraphView();
            }
            else if (csGISViewKindID.Equals(HySDefine.DISP_FORM_GIS2D_MESH))
            {   // ２次元メッシュ表示ならば
                csRtnView = new HySGoogleEarthDim2MeshView();
            }
            else if (csGISViewKindID.Equals(HySDefine.DISP_FORM_RIVER_CROSSSECTION))
            {   // 断面表示ならば
                //csRtnView = new HySDioVistaCrossSectionView();
            }
            else if (csGISViewKindID.Equals(HySDefine.DISP_FORM_RIVERBED_SHAPE))
            {   // 河床表示ならば
                //csRtnView = new HySDioVistaRiverbedShapeView();
            }
            else
            {
                return null;
            }

            if (csRtnView != null)
            {
                csRtnView.SetID(csID);
            }
            return csRtnView;
        }

    }
}
