﻿// <summary>ソースコード：システム全体制御クラス</summary>
// <author>CommonMP</author>

using System;
using System.Threading;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.Interface.HSController;
using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.Interface.HSViewer;

using CommonMP.HYSSOP.CoreImpl;
using CommonMP.HYSSOP.CoreImpl.HSTools;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSController;
using CommonMP.HYSSOP.CoreImpl.HSController.DIContainer;

namespace CommonMP.HYSSOP.OptionImpl.HSViewer.HyssopGISController
{
    /// <summary><para>class outline:</para>
    /// <para>システム全体制御クラス</para>
    /// </summary>
    /// <remarks><para>remarks:</para>
    /// <para>無し</para>
    /// </remarks>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.1.0][2010/12/22][新規作成]</para>
    /// </remarks>
    public class HySExtGISController : HySControllerRoot
    {
        /// <summary>環境情報管理</summary>
        protected HySExtGISEnvInf m_csEnvInf;

        /// <summary>ファクトリ管理</summary>
        protected HySFactoryMng m_csFactoryMng;

        /// <summary>システムコントローラー</summary>
        protected HySExtGISController m_csSystemCtl;

        /// <summary>ビューアコントローラー</summary>
        protected HySViewerController m_csViewerCtl;

        /// <summary>GIS制御</summary>
        protected HySGISController m_csGISCtl;

        /// <summary>定義データファイル定義名称</summary>
        protected HySString m_csConfigFileDefName;

        /// <summary><para>method outline:</para>
        /// <para>コンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySSystemController =csController = new HySSystemController( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySExtGISController()
        {
        }

        /// <summary><para>method outline:</para>
        /// <para>定義データ管理クラス取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetConfigureFileName(csName)</para>
        /// </example>
        /// <param name="csName">定義データファイル定義名称</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetConfigureFileName(HySString csName)
        {
            m_csConfigFileDefName = csName;
        }

        /// <summary><para>method outline:</para>
        /// <para>初期化処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Initialize( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>true : 正常、false : 異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual Boolean Initialize()
        {
            
            // 環境情報管理クラス生成
            m_csEnvInf = new HySExtGISEnvInf(m_csConfigFileDefName);
            HyssopGISCtlMainProgram.DebugLOG("end of new HySExtGISEnvInf()");
            if (m_csEnvInf.Initialize() != 0) 
            {
                return false; 
            }
            HyssopGISCtlMainProgram.DebugLOG("end of new HySExtGISEnvInf.Initialize()");

            // ===== start of 各種制御クラス生成 ====
            try
            {
                // システム全体制御
                m_csSystemCtl = this;


                // ＧＩＳ制御生成
                m_csGISCtl = new HySGISController();
                HyssopGISCtlMainProgram.DebugLOG("end of new HySGISController()");

                // 画面制御生成
                m_csViewerCtl = new HySViewerController();
                HyssopGISCtlMainProgram.DebugLOG("end of new HySViewerController()");

                // ===== end  of 各種制御クラス生成 ====


                // === start of ファクトリ管理関係処理
                // ファクトリ管理生成
                m_csFactoryMng = new HySFactoryManager();
                // ＤＩコンテナ生成
                HySSystemDIContainer csSystemDIContainer = new HySSystemDIContainer();
                // 定義データ管理取得
                HySConfigDataManager csDataManager = csSystemDIContainer.GetConfigDataManager((HySFactoryManager)m_csFactoryMng);
                HyssopGISCtlMainProgram.DebugLOG("end of new HySConfigDataManager()");

                // 定義データ読込
                csDataManager.ConfigDataLoad();
                // 全ファクトリクラス生成
                csDataManager.CreateFactoryClassAll();
                HyssopGISCtlMainProgram.DebugLOG("end of HySConfigDataManager.CreateFactoryClassAll()");

                // === end of ファクトリ管理関係処理


                // === start of ファクトリから各種インスタンスを生成し管理クラスに設定する

                // 画面制御
                m_csViewerCtl.SetConfigDataMng(csDataManager);

                // ＧＩＳ制御にファクトリ管理を教える
                m_csGISCtl.SetFactoryManager(m_csFactoryMng);
                // ＧＩＳ初期化処理（インスタンス等生成）
                m_csGISCtl.Initialize();
                HyssopGISCtlMainProgram.DebugLOG("end of m_csGISCtl.Initialize()");

                // 画面制御にファクトリ管理を教える
                m_csViewerCtl.SetFactoryMng(m_csFactoryMng);

                // 初期初期化処理（インスタンス等生成）
                //m_csViewerCtl.Initialize();
                HySGISCtlViewer csViewer = new HySGISCtlViewer();
                csViewer.SetController(m_csViewerCtl);
                csViewer.SetFactoryManager(m_csFactoryMng);
                m_csViewerCtl.SetSysUnit(csViewer);
                HyssopGISCtlMainProgram.DebugLOG("end of m_csViewerCtl.SetSysUnit(csViewer)");

                return true;
            }
            catch (Exception ex)
            {
                // 例外発生
                HyssopGISCtlMainProgram.ErrorLOG("HySExtGISController.Initialize():" + ex.Message);
                return false;
            }
            // === end of ファクトリから各種インスタンスを生成し管理クラスに設定する
        }

        /// <summary><para>method outline:</para>
        /// <para>システム制御クラス設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetBusiController( csController ) </para>
        /// </example>
        /// <param name="csController">システム制御クラス</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetSystemController(HySExtGISController csController)
        {
            m_csSystemCtl = csController;
        }

        /// <summary><para>method outline:</para>
        /// <para>画面制御クラス設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetBusiController( csViewerCtl ) </para>
        /// </example>
        /// <param name="csViewerCtl">画面制御クラス</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetViewerController(HySViewerController csViewerCtl)
        {
            m_csViewerCtl = csViewerCtl;
        }

        /// <summary><para>method outline:</para>
        /// <para>業務制御クラス設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetBusiController( csBusiCtl ) </para>
        /// </example>
        /// <param name="csBusiCtl">業務制御クラス</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetBusiController(HySBusiController csBusiCtl)
        {
            //Do Nothing
        }

        /// <summary><para>method outline:</para>
        /// <para>画面制御クラス取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySViewerController = csVewerCtl = GetViewerController( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>画面制御クラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySViewerController GetViewerController()
        {
            return m_csViewerCtl;
        }

        /// <summary><para>method outline:</para>
        /// <para>立ち上がり処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bRtn = WakeUp( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>true : 正常、false : 異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual Boolean WakeUp()
        {
            bool bRtn = true;
            HyssopGISCtlMainProgram.DebugLOG("start of csSysCtl.WakeUp()");

            // 各コンポーネントの　立ち上げ
            try
            {


                // ＧＩＳ管理制御起動
                m_csGISCtl.WakeUp();
                HyssopGISCtlMainProgram.DebugLOG("end of m_csGISCtl.WakeUp()");
                
                // 最後に画面を立ち上げる
                m_csViewerCtl.WakeUp();
                HyssopGISCtlMainProgram.DebugLOG("end of m_csViewerCtl.WakeUp()");

            }
            catch (Exception ex)
            {
                HyssopGISCtlMainProgram.ErrorLOG("HySExtGISController.WakeUp aAend  (catch exception  " + ex.Message + ")");
                bRtn = false;
            }

            return bRtn;
        }

        /// <summary><para>method outline:</para>
        /// <para>メイン画面起動処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Run( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void Run()
        {
            m_csViewerCtl.Run();
        }

        /// <summary><para>method outline:</para>
        /// <para>終了処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bRtn = Initialize( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>true : 正常、false : 異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual Boolean ShutDown()
        {          
            // 画面制御終了
            m_csViewerCtl.ShutDown();

            // ＧＩＳエンジン終了
            m_csGISCtl.ShutDown();

            // ファクトリマネージャ終了
            m_csFactoryMng.ShutDown();

            return true;
        }

        /// <summary><para>method outline:</para>
        /// <para>システム終了準備完了判別</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bRtn = ExitOK( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>true : システムExit準備OK　、false : システムExit準備NG</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual Boolean ExitOK()
        {
            Boolean bRtn = true;

            if( m_csGISCtl.ExitOK() == false )
            {   // GIS制御
                bRtn = false;
            }
            else if( m_csViewerCtl.ExitOK() == false )
            {   // ビューアコントローラー
                bRtn = false;
            }
            return bRtn;
        }

        /// <summary><para>method outline:</para>
        /// <para>システム終了指示</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bRtn = CmndShutDown( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>true : 正常、false : 異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual Boolean CmndShutDown()
        {
            return true;
        }

        /// <summary><para>method outline:</para>
        /// <para>システム構成要素を設定する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetSysUnit( csUnit ) </para>
        /// </example>
        /// <param name="csUnit">システム構成要素</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>本クラスは何もしない</para>
        /// </remarks>
        public void SetSysUnit(HySSysUnit csUnit)
        {
        }

        /// <summary><para>method outline:</para>
        /// <para>イベント管理クラスを設定する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetSysEventManager( csEventMng ) </para>
        /// </example>
        /// <param name="csEventMng">イベント管理クラス</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetEventManager(HySEventMngRoot csEventMng)
        {
            // Do Nothing
        }

        /// <summary><para>method outline:</para>
        /// <para>イベントを受け取った時に動作するメソッド</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bRtn = EventCallback( csEvent ) </para>
        /// </example>
        /// <param name="csEvent">送られたイベント</param>
        /// <returns>true:=正常, false:=異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>各実装クラスは受け取ったイベントをシステム構成要素にポストする</para>
        /// </remarks>
        public virtual Boolean EventCallback(HySSysEvent csEvent)
        {
            return true;
        }
        /// <summary><para>method outline:</para>
        /// <para>イベントをイベント管理クラスにポストする</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bRtn = PutEvent( csEvent ) </para>
        /// </example>
        /// <param name="csEvent">送るイベント</param>
        /// <returns>true:=正常, false:=異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>送信元識別子を自分で付与する</para>
        /// </remarks>
        public virtual Boolean PutEvent(HySSysEvent csEvent)
        {
            bool bRtn = false;
            long lToNo = csEvent.To();
            if (lToNo == HySSysEvent.OBJID_SYSCONTROLLER)
            {   // 宛先がシステムコントローラーならば
                if (m_csSystemCtl != null)
                {
                    bRtn = m_csSystemCtl.EventCallback(csEvent);
                }
            }
            else if (lToNo == HySSysEvent.OBJID_VIEWER)
            {   // 宛先がビューアコントローラーならば
                if (m_csViewerCtl != null)
                {
                    bRtn = m_csViewerCtl.EventCallback(csEvent);
                }
            }
            else if (lToNo == HySSysEvent.OBJID_GISCONTROLLER)
            {   // 宛先がＧＩＳコントローラーならば
                if (m_csGISCtl != null)
                {
                    bRtn = m_csGISCtl.EventCallback(csEvent);
                }
            }
            else
            {
                // Do Nothing
            }
            return bRtn;
        }
        
        /// <summary><para>method outline:</para>
        /// <para>宛先識別番号を取得する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> long lAdressIDNo = AdressIDNo() </para>
        /// </example>
        /// <returns>宛先識別番号:(HySSysEvent.OBJID_GISCONTROLLER)</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public long AdressIDNo()
        {
            return HySSysEvent.OBJID_SYSCONTROLLER;
        }
        
        /// <summary><para>method outline:</para>
        /// <para>システムExit制御スレッド</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> ProcExitCtlThread() </para>
        /// </example>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        protected virtual void ProcExitCtlThread()
        {
            // Do Nothing
        }
    }
}
