﻿// <summary>ソースコード：背景地図スクリーンクラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.Interface.HSViewer;
using CommonMP.HYSSOP.Interface.HSGIS;

using CommonMP.HYSSOP.CoreImpl;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSGIS;
using CommonMP.HYSSOP.CoreImpl.HSViewer;

namespace CommonMP.HYSSOP.OptionImpl.HSViewer.HyssopGISController
{
    /// <summary><para>class outline:</para>
    /// <para>背景地図スクリーンクラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.1.0][2010/12/22][新規作成]</para>
    /// </remarks>
    public class HySGISBaseMapScreen : HySGISScreenBase
    {
        /// <summary>背景地図表示制御データ </summary>
        protected HySGeoBaseMapData m_csMapCtlData=null;

        /// <summary><para>method outline:</para>
        /// <para>ビュー種別取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySKind csKind = GetViewKind()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>ＧＩＳビュー種別</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override HySKind GetViewKind()
        { return HySDefine.DISP_FORM_GIS_BASEMAP; }
        /// <summary><para>method outline:</para>
        /// <para>ＧＩＳビュー種別比較</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bRtn = EqualViewKind(csViewKindID)</para>
        /// </example>
        /// <param name="csGISViewKindID">ビュー種別</param>
        /// <returns>true  : 同じ、false : 異なる</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override Boolean EqualViewKind(HySKind csGISViewKindID)
        { return HySDefine.DISP_FORM_GIS_BASEMAP.Equals(csGISViewKindID); }

        /// <summary><para>method outline:</para>
        /// <para>システムから受け取ったイベントに対する動作メソッド</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bRtn = EventCallback( csEvent ) </para>
        /// </example>
        /// <param name="csEvent">送られたイベント</param>
        /// <returns>true:=正常, false:=異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>各実装クラスは受け取ったイベント毎に処理を行う</para>
        /// </remarks>
        public override Boolean EventCallback(HySSysEvent csEvent)
        {
            return false;
        }

        /// <summary><para>method outline:</para>
        /// <para>表示に特別に必要なイベント情報の設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetDispEventData( csEvent ) </para>
        /// </example>
        /// <param name="csEvent">イベント情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>表示に特別に必要なイベント情報があった場合のみ発行</para>
        /// </remarks>
        public override void SetDispEventData(HySSysEvent csEvent)
        {
            // Do Nothing
        }
        /// <summary><para>method outline:</para>
        /// <para>表示用のデータ設定設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetDispData( csDispData ) </para>
        /// </example>
        /// <param name="csDispData">背景地図表示用データ</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void SetDispData(HySGeoBaseMapData csDispData)
        {
            m_csMapCtlData = csDispData;
            // ビューに設定
            ((HySGISBaseMapView)m_csGISView).SetDispMapData(m_csMapCtlData);
        }
        /// <summary><para>method outline:</para>
        /// <para>背景地図マウスクリック位置通知</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> NoticeMapMouseEvent( dLat,dLon) 
        /// </para>
        /// </example>
        /// <param name="dLat">地図上緯度（度）</param>
        /// <param name="dLon">地図上経度（度）</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void NoticeMapPoint(double dLat, double dLon)
        {
            //HySEventObject csEvtObj = new HySEventObject(HySSysEvent.OBJID_BUSIPROCEDURE, HySEventObject.NOTICE_GIS_OK, HySGISDefine.MAP_POSITION_GET);
            //csEvtObj.SetData(new HySGeoPoint(dLat, dLon, 0.0));
            //this.PutEvent(csEvtObj);
            // 将来用
        }
    }
}
