﻿// <summary>ソースコード：２次元メッシュスクリーンクラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Collections;
using System.Text;
using System.Threading;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.Interface.HSViewer;
using CommonMP.HYSSOP.Interface.HSGIS;

using CommonMP.HYSSOP.CoreImpl;
using CommonMP.HYSSOP.CoreImpl.HSGIS;
using CommonMP.HYSSOP.CoreImpl.HSBusiProc;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;
using CommonMP.HYSSOP.CoreImpl.HSViewer;


namespace CommonMP.HYSSOP.OptionImpl.HSViewer.HyssopGISController
{
    /// <summary><para>class outline:</para>
    /// <para>２次元メッシュスクリーンクラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.1.0][2010/12/22][新規作成]</para>
    /// </remarks>
    /// <remarks><para>Remarks</para>
    /// <para>インスタンス複数存在有り（複数のメッシュ情報をオーバーレイ表示する）</para>
    /// </remarks>
    public class HySGISDim2MeshScreen : HySGISScreenBase
    {
        /// <summary>２次元メッシュ時系列データ </summary>
        HySGeoDim2MeshSerialData m_cs2DMeshSerialData = null;
        /// <summary>２次元メッシュデータ </summary>
        HySGeoDim2MeshData m_cs2DMeshData = null;

        /// <summary><para>method outline:</para>
        /// <para>ビュー種別取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySKind csKind = GetViewKind()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>ＧＩＳビュー種別</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override HySKind GetViewKind()
        { return HySDefine.DISP_FORM_GIS2D_MESH; }
        /// <summary><para>method outline:</para>
        /// <para>ＧＩＳビュー種別比較</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bRtn = EqualViewKind(csViewKindID)</para>
        /// </example>
        /// <param name="csViewKindID">ビュー種別</param>
        /// <returns>true  : 同じ、false : 異なる</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override Boolean EqualViewKind(HySKind csViewKindID)
        { return HySDefine.DISP_FORM_GIS2D_MESH.Equals(csViewKindID); }

        /// <summary><para>method outline:</para>
        /// <para>画面表示</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> ShowScreen( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void ShowScreen()
        {
            if (m_csGISView != null)
            {
                //m_csGISView.Show();
                this.RenewScreen();
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>画面更新</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> RenewScreen( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void RenewScreen()
        {
            if (m_cs2DMeshSerialData != null)
            {   // 時系列の２次元メッシュデータの場合
                ((HySGISDim2MeshView)m_csGISView).SetDispMeshData(m_cs2DMeshSerialData);
                ((HySGISDim2MeshView)m_csGISView).StartAnimation();
            }
            else if (m_cs2DMeshData != null )
            {   // ２次元メッシュデータの場合
                ((HySGISDim2MeshView)m_csGISView).SetDispMeshData(m_cs2DMeshData);
                m_csGISView.Renew();
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>イベントを受け取った時に動作するメソッド</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bRtn = EventCallback( csEvent ) </para>
        /// </example>
        /// <param name="csEvent">送られたイベント</param>
        /// <returns>true:=正常, false:=異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>各実装クラスは受け取ったイベント毎に処理を行う</para>
        /// </remarks>
        public override Boolean EventCallback(HySSysEvent csEvent)
        {
            // Do Nothing
            return true;
        }

        /// <summary><para>method outline:</para>
        /// <para>表示に特別に必要なイベント情報の設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetDispEventData( csEvent ) </para>
        /// </example>
        /// <param name="csEvent">イベント情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>表示に特別に必要なイベント情報があった場合のみ発行</para>
        /// </remarks>
        public override void SetDispEventData(HySSysEvent csEvent)
        {
            // Do Nothing
        }

        /// <summary><para>method outline:</para>
        /// <para>表示用のデータ設定設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetDispData( cs2DMeshSerialData ) </para>
        /// </example>
        /// <param name="cs2DMeshSerialData">２次元メッシュ時系列データ</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>
        /// セル内のデータ数は１個とする。
        /// また、HySGeoDim2MeshSerialDataには、
        ///    HySDataCharacteristicInCell csCellChara = new HySDataCharacteristicInCell(1);
        ///    csCellChara.SetDataKind(0, "水位", HySDataKindDefine.WATER_LEVEL, "cm");
        ///    cs2DMeshSerialData.SetCellDataCharacteristic(csCellChara);
        ///    の設定が予め必要である。
        /// </para>
        /// </remarks>
        public void SetDispData(HySGeoDim2MeshSerialData cs2DMeshSerialData)
        {
            m_cs2DMeshData = null;
            ((HySGISDim2MeshView)m_csGISView).SetDispMeshData(m_cs2DMeshData);
            m_cs2DMeshSerialData = cs2DMeshSerialData;
            ((HySGISDim2MeshView)m_csGISView).SetDispMeshData(m_cs2DMeshSerialData);
        }
        /// <summary><para>method outline:</para>
        /// <para>表示用のデータ設定設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetDispData( cs2DMeshData ) </para>
        /// </example>
        /// <param name="cs2DMeshData">２次元メッシュデータ</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>
        /// セル内のデータ数は１個とする。
        /// また、HySGeoDim2MeshDataには、
        ///    HySDataCharacteristicInCell csCellChara = new HySDataCharacteristicInCell(1);
        ///    csCellChara.SetDataKind(0, "水位", HySDataKindDefine.WATER_LEVEL, "cm");
        ///    HySGeoDim2MeshData.SetCellDataCharacteristic(csCellChara);
        ///    の設定が予め必要である。
        /// </para>
        /// </remarks>
        public void SetDispData(HySGeoDim2MeshData cs2DMeshData)
        {
            m_cs2DMeshSerialData = null;
            ((HySGISDim2MeshView)m_csGISView).SetDispMeshData(m_cs2DMeshSerialData);
            m_cs2DMeshData = cs2DMeshData;
            ((HySGISDim2MeshView)m_csGISView).SetDispMeshData(m_cs2DMeshData);
        }
    }
}
