﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Runtime.Serialization;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;

namespace CommonMP.HYSSOP.OptionImpl.HSViewer.HyssopGISController
{
    /// <summary><para>class outline:</para>
    /// <para>Long値クラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.1.0][2010/12/22][新規作成]</para>
    /// <para>Remarks:</para>
    /// <para>無し</para>
    /// </remarks>
    [Serializable]
    public class HySSelectDataInf : HySDataRoot, HySVersionManagement 
    {
        /// <summary> 選択したファイル名称 </summary>
        protected string m_csFileNameWithPath = null;
        /// <summary> 選択データのセル内アイテム番号：０相対 </summary>
        protected long m_lSlectItemNo = 0;


        /// <summary><para>method outline:</para>
        /// <para>コンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySSelectDataInf csDataInf = new HySSelectDataInf(csFileNameWithPath, lSlectItemNo) </para>
        /// </example>
        /// <param name="csFileNameWithPath">ファイル名称</param>
        /// <param name="lSlectItemNo">選択データのセル内アイテム番号：０相対</param>
        /// <returns>生成したインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySSelectDataInf(string csFileNameWithPath, long lSlectItemNo)
        {
            m_csFileNameWithPath = csFileNameWithPath;
            m_lSlectItemNo = lSlectItemNo;
            //バージョン情報設定
            SetNowVersion();
        }

        /// <summary><para>method outline:</para>
        /// <para>ファイル名称設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetFileName(csFileNameWithPath) </para>
        /// </example>
        /// <param name="csFileNameWithPath">ファイル名称</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetFileName(string csFileNameWithPath)
        {
            m_csFileNameWithPath = csFileNameWithPath;
        }

        /// <summary><para>method outline:</para>
        /// <para>ファイル名称取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> string sStr = GetFileName() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>ファイル名称</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public string GetFileName()
        { 
            return m_csFileNameWithPath;
        }

        /// <summary><para>method outline:</para>
        /// <para>セル内アイテム番号設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetSlectItemNo(lSelectItemNo) </para>
        /// </example>
        /// <param name="lSelectItemNo">選択データのセル内アイテム番号：０相対</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetSlectItemNo(long lSelectItemNo)
        {
            m_lSlectItemNo = lSelectItemNo;
        }

        /// <summary><para>method outline:</para>
        /// <para>セル内アイテム番号取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> long lNo = GetSelectDataItemNo() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>選択データのセル内アイテム番号：０相対</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public long GetSelectDataItemNo()
        { 
            return m_lSlectItemNo;
        }


        // ================================================
        //   バージョンアップ時の下位互換性を保つ為の処理
        // ================================================
        /// <summary>保存バージョン情報</summary>
        private string m_sDecodedVersion;
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> string sDecodedVersion = GetDecodedVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>string 保存バージョン情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>メンバー変数に設定されているバージョン情報を返す</para>
        /// </remarks>
        public string GetDecodedVersion()
        {
            return m_sDecodedVersion;
        }
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> string sVersion = GetNowVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>string 現在のバージョン情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public string GetNowVersion()
        {
            return "1.00";
        }
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetNowVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>現在のバージョン情報をメンバー変数に設定する</para>
        /// </remarks>
        public void SetNowVersion()
        {
            m_sDecodedVersion = GetNowVersion();
        }
        /// <summary><para>method outline:</para>
        /// <para>復元後の整合性確保処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> PostDeserialize( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>シリアライズされた旧バージョン情報を復元する際、過去の整合性をとる時に使用する
        /// バージョンによって変数等追加がない場合には、実装の必要がない
        /// </para>
        /// </remarks>
        public virtual void PostDeserialize()
        {
            if (GetDecodedVersion() != GetNowVersion())
            {
                if (GetDecodedVersion() == null)
                {
                    // 旧バージョンからの移行処理を入れる
                }
                else
                {
                    //旧バージョンから順にバージョンを上げて行く
                    switch (GetDecodedVersion())
                    {
                        case "1.00":
                            {
                                // 旧バージョンからの移行処理を入れる
                                break;
                            }
                        //case "2.00": << 以後バージョンアップに伴って処理追加
                        //{
                        //    break;
                        //}
                    }                    
                }
                SetNowVersion();
            }
        }
        /// <summary><para>method outline:</para>
        /// <para>逆シリアル化時追加処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> IDeserializationCallback.OnDeserialization(csObj)</para>
        /// </example>
        /// <param name="csObj">ダミー</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>予約処理</para>
        /// </remarks>
        void IDeserializationCallback.OnDeserialization(Object csObj)
        {
            PostDeserialize();
        }
    }
}
