﻿// <summary>ソースコード：メイン画面フォームクラス</summary>
// <author>CommonMP</author>


//using System.Linq;
using System;
using System.Collections;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Diagnostics;

using CommonMP.HYSSOP.Interface.HSViewer;
using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.CoreImpl;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;
using CommonMP.HYSSOP.CoreImpl.HSTools.Msg;

namespace CommonMP.HYSSOP.OptionImpl.HSViewer.HyssopGISController
{   
    /// <summary><para>class outline:</para>
    /// <para>メイン画面フォームクラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.1.0][2010/12/22][新規作成]</para>
    /// </remarks>
    public partial class HySGISCtlMainForm : Form
    {
        /// <summary>ＧＩＳ制御用ビューアクラス </summary>
        protected HySGISCtlViewer m_csViewer = null;

        /// <summary> ＧＩＳビューア内制御クラス </summary>
        protected HySGISCtlViewerJob m_csCtlJob = null;

        /// <summary> データファイル取得確認用ハッシュ </summary>
        protected HySDataHashTable m_csInputFileChkTable = null;

        ///// <summary> 入力データ対応付け用ハッシュ </summary>
        //protected HySDataHashTable m_csRowLinkedInputData = null;

        ///// <summary> 選択行番号 </summary>
        //protected HySString m_csRowNo = null;

        /// <summary> ダイアログで指定されたファイル名称 </summary>
        private string sReadFileName;


        /// <summary>
        /// <para>method outline:</para>
        /// <para>デフォルトコンストラクタ</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>HySDotNetMainForm csDotNetForm = new HySDotNetMainForm( )</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        protected HySGISCtlMainForm()
        {
            InitializeComponent();
        }
             
        /// <summary>
        /// <para>method outline:</para>
        /// <para>コンストラクタ</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>HySDotNetMainForm csDotNetForm = new HySDotNetMainForm(csViewr)</para>
        /// </example>
        /// <param name="csViewr">ビューア</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySGISCtlMainForm(HySViewer csViewr)
        {
            m_csViewer = csViewr as HySGISCtlViewer;
            m_csCtlJob = m_csViewer.GetJob();
            m_csInputFileChkTable = new HySDataHashTable();
            //m_csRowLinkedInputData = new HySDataHashTable();
            //m_csRowNo = new HySString("");

            InitializeComponent();

            CheckCommonMPTimer.Enabled = true;  // タイマー起動

            // サイズ変更抑止
            this.MinimumSize = new System.Drawing.Size(331, 722);
            this.MaximumSize = new System.Drawing.Size(331, 722); 
            // DataGridViewの初期処理
            // 複数行選択禁止
            DataSelectGridView.MultiSelect = false;
            // 列幅調整
            DataGridViewCheckBoxColumn checkColumn = (DataGridViewCheckBoxColumn)DataSelectGridView.Columns[0];
            checkColumn.Width = 45;
            // Buttonの初期処理
            // 非活性
            MapDispButton.Enabled = false;
            KMLOutButton.Enabled = false;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>GIS表示イベント処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>VeryFirstJob()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void VeryFirstJob()
        {
            HySEventObject csEvent = new HySEventObject(HySSysEvent.OBJID_VIEWER, HySEventObject.CMND_DISP_SCREEN, HySGISCtlDefine.DISP_BASE_MAP);
            m_csCtlJob.EventCallback(csEvent);
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>CommonMP起動中監視タイマー</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>CheckCMPTimer(sender,e)</para>
        /// </example>
        /// <param name="sender">オブジェクト</param>
        /// <param name="e">イベント</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void CheckCMPTimer(object sender, EventArgs e)
        {
            /*
            if ((System.Diagnostics.Process.GetProcessesByName("CommonMPMain").Length < 1)
             && (System.Diagnostics.Process.GetProcessesByName("CommonMPMain.vshost").Length < 1)
             && (System.Diagnostics.Process.GetProcessesByName("CommonMPModelDebug.vshost").Length < 1)) // <-- ここの判定条件は複数ある（モデル開発者のディバッガー動作の時、この条件では立ち上がらない）
            {   // CommonMPが起動中で無い時

                // メッセージボックス表示：”CommonMPが起動されていません”<-- 行わない

                Application.Exit();// 処理強制終了
                HyssopGISCtlMainProgram.ErrorLOG("CommonMP is not running.");
            }
            */
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>地図表示イベント処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>DispMapCallBack(sender,e)</para>
        /// </example>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void DispMapCallBack(object sender, EventArgs e)
        {
            bool bRtn = true;

            HySSelectDataInf csSlctInf = null;
            for (int iLp = 0; iLp < DataSelectGridView.RowCount; iLp++)
            {
                if ((bool)DataSelectGridView[0, iLp].Value == true)
                {
                    string sItemNo = (string)DataSelectGridView["ItemNo", iLp].Value;
                    long lItemNo = 0;
                    long.TryParse(sItemNo, out lItemNo);
                    csSlctInf = new HySSelectDataInf((string)DataSelectGridView[3, iLp].Value, lItemNo);
                }
            }

            if (csSlctInf != null)
            {
                HySEventObject csEvent = new HySEventObject(HySSysEvent.OBJID_VIEWER, HySEventObject.CMND_DISP_SCREEN, HySGISCtlDefine.DISP_2D_MESH);
                csEvent.SetData(csSlctInf);
                bRtn = m_csCtlJob.EventCallback(csEvent);
                if (bRtn == false)
                {
                    // 処理異常
                    // メッセージ表示
                    MessageBox.Show("処理中にエラーが発生しました。", "GIS表示", MessageBoxButtons.OK, MessageBoxIcon.Error);
                    return;
                }

            }
        }
        /// <summary>
        /// <para>method outline:</para>
        /// <para>ＫＭＬ出力イベント処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>DispMapCallBack(sender,e)</para>
        /// </example>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void KMLOutCallBack(object sender, EventArgs e)
        {
            bool bRtn = true;
            SaveFileDialog csSaveFileDlg = new SaveFileDialog();
            csSaveFileDlg.FileName = ".kml";
            csSaveFileDlg.InitialDirectory = HySEnvInf.GetDataHomeDirectory().ToString() +"\\";
            csSaveFileDlg.Filter = "KML(*.kml)|*.kml";
            csSaveFileDlg.Title = "KML出力ファイルの設定（時系列の場合には複数のファイルに自動分割されます）";
            csSaveFileDlg.RestoreDirectory = true;
            if (csSaveFileDlg.ShowDialog() == DialogResult.OK)
            {  // ファイル名入力が完了の場合
                if (csSaveFileDlg.FileName.Length > 0)
                {  // 名称入力が有る場合

                    HySEventObject csEvent = new HySEventObject(HySSysEvent.OBJID_VIEWER, HySEventObject.CMND_DISPLY_COMMON, HySGISCtlDefine.KML_OUT);
                    # region
                    ////此処ではダミー値を入れておく　、実際は画面から選択された情報を持つ事
                    //string sFileName = sReadFileName; // " 選択されたファイル名称";
                    //;
                    //long lItemNo = 0;  // <-- 選択されたデータのセル内の位置（０相対）
                 
                    //// 選択情報格納データを作成
                    //HySSelectDataInf csSlctInf = new HySSelectDataInf(sFileName, lItemNo); 
                    # endregion
                    // 画面上で選択された情報取得
                    //HySSelectDataInf csSlctInf = (HySSelectDataInf)m_csRowLinkedInputData[m_csRowNo];

                    HySSelectDataInf csSlctInf = null;
                    for (int iLp = 0; iLp < DataSelectGridView.RowCount; iLp++)
                    {
                        if ((bool)DataSelectGridView[0, iLp].Value == true)
                        {
                            string sItemNo = (string)DataSelectGridView["ItemNo", iLp].Value;
                            long lItemNo = 0;
                            long.TryParse(sItemNo, out lItemNo);
                            csSlctInf = new HySSelectDataInf((string)DataSelectGridView[3, iLp].Value, lItemNo);
                        }
                    }
                    if (csSlctInf != null)
                    {
                        csEvent.SetData(csSlctInf);


                        //csEvent.SetSubEventNo(HySID.NOTICE_SCREEN_DISPLAY);
                        //csEvent.SetData(HySDefine.DISP_FORM_GIS2D_MESH);

                        HySString csKMLName = new HySString(csSaveFileDlg.FileName); // 出力するＫＭＬファイル名
                        csEvent.SetSubData(csKMLName);

                        bRtn = m_csCtlJob.EventCallback(csEvent);
                        if (bRtn == false)
                        {
                            // 処理異常
                            // メッセージ表示
                            MessageBox.Show("処理中にエラーが発生しました。", "GIS表示", MessageBoxButtons.OK, MessageBoxIcon.Error);
                            // コントロール有効
                            this.Enabled = true;
                            return;
                        }
                    }
                    // 監視開始
                    CheckKMLFileOutTimer.Enabled = true;
                }
            }
        }
        /// <summary>
        /// <para>method outline:</para>
        /// <para>表示用データファイル取得イベント処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>DispFileSelectCallBack(sender,e)</para>
        /// </example>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void DispFileSelectCallBack(object sender, EventArgs e)
        {
            bool bRtn = true;
            OpenFileDialog csReadFileDlg = new OpenFileDialog();
            
            csReadFileDlg.FileName = ".d2gis";
            csReadFileDlg.InitialDirectory = HySEnvInf.GetDataHomeDirectory().ToString() + "\\";
            csReadFileDlg.Filter = "D2GIS(*.d2gis)|*.d2gis";
            csReadFileDlg.Title = "表示用２次元メッシュデータファイル取得";
            csReadFileDlg.RestoreDirectory = true;
            if (csReadFileDlg.ShowDialog() == DialogResult.OK)
            {  // ファイル名入力が完了の場合
                if (csReadFileDlg.FileName.Length > 0)
                {  // 名称入力が有る場合
                    sReadFileName = csReadFileDlg.FileName;
                    // 取得データ重複確認
                    if (m_csInputFileChkTable.GetObject(new HySString(sReadFileName)) != null)
                    {
                        // 重複有り
                        // メッセージ表示
                        MessageBox.Show("選択されたデータファイルは既に取得されています。", "GIS表示", MessageBoxButtons.OK, MessageBoxIcon.Information);
                        return;
                    }
                    // テーブル生成処理
                    bRtn = this.CreateDataSelectTable(new HySString(sReadFileName));
                    if (bRtn == false)
                    {
                        // 処理異常
                        // メッセージ表示
                        MessageBox.Show("処理中にエラーが発生しました。", "GIS表示", MessageBoxButtons.OK, MessageBoxIcon.Error);
                        return;
                    }
                    // 入力ファイルフルパス表示
                    this.InputFileNameBox.Text = sReadFileName;
                    // 右端表示(長いフルパスでもファイル名が認識できるよう)
                    this.InputFileNameBox.SelectAll();
                    int idx = this.InputFileNameBox.SelectionLength;
                    this.InputFileNameBox.SelectionStart = idx;
                    # region
                    /*
                    HySString csDispDataName = new HySString(csReadFileDlg.FileName);
                    HySFile csFile = new HySFile(csDispDataName);
                    csFile.Open(HySFile.OPEN_MODE.OPEN,HySFile.READ_WRITE_MODE.READ,HySFile.DIRECTORY_MODE.NOT_MK_DIR);

                    HySGeoDim2MeshSerialData m_dmyDispData = null;

                    m_dmyDispData = HySGeoDim2MeshSerialData.CSVHeaderRead(csFile);
                    if (m_dmyDispData != null)
                    {
                        m_dmyDispData.ReadCSVFileDataOnly(csFile);
                    }
                    csFile.Close();
                    */
                    # endregion
                }
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>終了イベント処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>EndButtonCallBack(sender,e)</para>
        /// </example>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void EndButtonCallBack(object sender, EventArgs e)
        {
            // 終了ＯＫかを問い合わせるメッセージボックス表示
            DialogResult result = MessageBox.Show("GIS表示を終了します。よろしいですか?", "GIS表示", MessageBoxButtons.OKCancel, MessageBoxIcon.Information);
            if (result == DialogResult.OK)
            {
                // 終了ＯＫならば、
                // アプリケーションの終了
                Application.Exit();
            }
        }



        /// <summary>
        /// <para>method outline:</para>
        /// <para>データ選択用テーブル生成処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>CreateDataSelectTable(csFileName)</para>
        /// </example>
        /// <param name="csFileName">入力ファイル名称</param>
        /// <returns>bool: true:正常終了, false:異常終了</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private bool CreateDataSelectTable(HySString csFileName)
        {
            bool bRtn = true;
            try
            {
                // ファイルオープン
                HySFile csFile = new HySFile(csFileName);
                if (csFile.Open(HySFile.OPEN_MODE.OPEN, HySFile.READ_WRITE_MODE.READ, HySFile.DIRECTORY_MODE.NOT_MK_DIR) != 0)
                {
                    // オープン処理異常
                    HyssopGISCtlMainProgram.ErrorLOG("HySGISCtlMainForm.CreateDataSelectTable():" + "File Open Failed.");
                    return false;
                }
                HySGeoDim2MeshSerialData csD2MeshData = null;
                csD2MeshData = HySGeoDim2MeshSerialData.CSVHeaderRead(csFile);
                if (csD2MeshData != null)
                {
                    csD2MeshData.ReadCSVFileDataOnly(csFile);
                }
                else
                {
                    // データ生成処理異常
                    HyssopGISCtlMainProgram.ErrorLOG("HySGISCtlMainForm.CreateDataSelectTable():" + "Data Create Failed.");
                    csFile.Close();
                    return false;
                }
                csFile.Close();
                // データ名称取得（もしくはデータ種別）
                HySDataCharacteristicInCell csCellCharactor = csD2MeshData.GetCellDataCharacteristic();
                // 生成処理
                bRtn = this.AddInputDataInfo(csCellCharactor, csFileName);
            }
            catch (Exception ex)
            {
                // 例外発生
                HyssopGISCtlMainProgram.ErrorLOG("HySGISCtlMainForm.CreateDataSelectTable():" + ex.Message);
                bRtn = false;
            }
            return bRtn;
        }
        
        /// <summary>
        /// <para>method outline:</para>
        /// <para>入力データ情報追加</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>AddInputDataInfo(csCellCharactor, csFileName)</para>
        /// </example>
        /// <param name="csCellCharactor">セル内データ</param>
        /// <param name="csFileName">入力ファイル名称</param>
        /// <returns>bool: true:正常終了, false:異常終了</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private bool AddInputDataInfo(HySDataCharacteristicInCell csCellCharactor, HySString csFileName)
        {
            bool bRtn = true;
            try
            {
                // 保持データ数確認
                int iDataNum = csCellCharactor.m_csDataKind.Length;
                // 現在の行数確認
                int iRowCount = DataSelectGridView.Rows.Count;
                // 行追加(現在の行数～)
                DataSelectGridView.Rows.Add(iDataNum);
                // データ名称取得/設定
                for (int iLp = 0; iLp < iDataNum; iLp++)
                {
                    string sDataName = csCellCharactor.m_csLabel[iLp];
                    if (sDataName == "")
                    {
                        // 名称がなければデータ種別使用
                        HySObjectKind csKind = csCellCharactor.m_csDataKind[iLp];
                        sDataName = csKind.ToString();
                    }
                    // データ名称設定
                    DataSelectGridView[1, iRowCount + iLp].Value = sDataName;
                    // ファイル名称設定
                    string sFileName = System.IO.Path.GetFileName(csFileName.ToString());
                    DataSelectGridView[2, iRowCount + iLp].Value = sFileName;
                    // フルパス名称設定
                    DataSelectGridView[3, iRowCount + iLp].Value = csFileName.ToString();
                    
                    // フルパス名称設定
                    DataSelectGridView["ItemNo", iRowCount + iLp].Value = iLp.ToString();

                    // 設定済みファイル名称の記憶
                    m_csInputFileChkTable.AddObject(csFileName, csFileName);
                    // チェックボックスON/OFF判断の為の値設定
                    DataGridViewCheckBoxCell cell = DataSelectGridView.Rows[iRowCount + iLp].Cells[0] as DataGridViewCheckBoxCell;
                    cell.Value = false;
                    //// 選択行と入力データの対応付け記憶
                    //HySSelectDataInf csDataInf = new HySSelectDataInf(csFileName.ToString(), (long)iLp);
                    //m_csRowLinkedInputData.AddObject(new HySString((iRowCount + iLp).ToString()), csDataInf);
                }
            }
            catch (Exception ex)
            {
                // 例外発生
                HyssopGISCtlMainProgram.ErrorLOG("HySGISCtlMainForm.AddInputDataInfo():" + ex.Message);
                bRtn = false;
            }
            return bRtn;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>セルクリックイベント処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>DataSelectGridView_CellClick(sender,e)</para>
        /// </example>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void DataSelectGridView_CellClick(object sender, DataGridViewCellEventArgs e)
        {
            // 列ヘッダクリック時対策
            if (e.RowIndex == -1)
            {
                return;
            }
            // 1行選択
            DataSelectGridView.SelectionMode = DataGridViewSelectionMode.FullRowSelect;
            // 入力ファイルフルパス表示
            DataGridViewTextBoxCell TextCell = DataSelectGridView.Rows[e.RowIndex].Cells[3] as DataGridViewTextBoxCell;
            HySString csFullPath = new HySString((string)TextCell.Value);
            this.InputFileNameBox.Text = csFullPath.ToString();
            // 右端表示(長いフルパスでもファイル名が認識できるよう)
            this.InputFileNameBox.SelectAll();
            int idx = this.InputFileNameBox.SelectionLength;
            this.InputFileNameBox.SelectionStart = idx;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>セル内容クリックイベント処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>DataSelectGridView_CellContentClick(sender,e)</para>
        /// </example>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void DataSelectGridView_CellContentClick(object sender, DataGridViewCellEventArgs e)
        {
            // 列ヘッダクリック時対策
            if (e.RowIndex == -1)
            {
                return;
            }
            // 1行選択
            DataSelectGridView.SelectionMode = DataGridViewSelectionMode.FullRowSelect;
            // 「選択」列ならば
            if (e.ColumnIndex == 0)
            {
                // チェック選択状態をクリア
                this.ClearSelected(e.RowIndex);
                // チェックボックスのON/OFF実施
                DataGridViewCheckBoxCell cell = DataSelectGridView.Rows[e.RowIndex].Cells[e.ColumnIndex] as DataGridViewCheckBoxCell;
                cell.Value = !((bool)cell.Value);
                // チェック済み行番号の設定とボタン制御
                if ((bool)cell.Value == true)
                {
                    //m_csRowNo = new HySString(((e.RowIndex).ToString()));
                    // 活性
                    //MapDispButton.Enabled = true;
                    KMLOutButton.Enabled = true;
                }
                else
                {
                    // 非活性
                    MapDispButton.Enabled = false;
                    KMLOutButton.Enabled = false;
                }
                if (DataSelectGridView.IsCurrentCellDirty)
                {
                    DataSelectGridView.CommitEdit(DataGridViewDataErrorContexts.Commit);
                }
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>セル内容ダブルクリックイベント処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>DataSelectGridView_CellContentDoubleClick(sender,e)</para>
        /// </example>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void DataSelectGridView_CellContentDoubleClick(object sender, DataGridViewCellEventArgs e)
        {
            // 列ヘッダクリック時対策
            if (e.RowIndex == -1)
            {
                return;
            }
            // 1行選択
            DataSelectGridView.SelectionMode = DataGridViewSelectionMode.FullRowSelect;
            // 「選択」列ならば
            if (e.ColumnIndex == 0)
            {
                // チェック選択状態をクリア
                this.ClearSelected(e.RowIndex);
                // チェックボックスのON/OFF実施
                DataGridViewCheckBoxCell cell = DataSelectGridView.Rows[e.RowIndex].Cells[e.ColumnIndex] as DataGridViewCheckBoxCell;
                cell.Value = !((bool)cell.Value);
                // チェック済み行番号の設定とボタン制御
                if ((bool)cell.Value == true)
                {
                    //m_csRowNo = new HySString(((e.RowIndex).ToString()));
                    // 活性
                    //MapDispButton.Enabled = true;
                    KMLOutButton.Enabled = true;
                }
                else
                {
                    // 非活性
                    MapDispButton.Enabled = false;
                    KMLOutButton.Enabled = false;
                }
                if (DataSelectGridView.IsCurrentCellDirty)
                {
                    DataSelectGridView.CommitEdit(DataGridViewDataErrorContexts.Commit);
                }
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>チェックボックス選択状態クリア</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>ClearSelected()</para>
        /// </example>
        /// <param name="index">選択行インデックス</param>
        /// <returns>bool: true: クリア実施 false: クリア未実施</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private bool ClearSelected(int index)
        {
            bool bRtn = false;
            int iRowCount = DataSelectGridView.Rows.Count;
            for (int iLp = 0; iLp < iRowCount; iLp++)
            {
                // 選択行チェックボックスの状態は除外
                if (iLp != index)
                {
                    DataGridViewCheckBoxCell cell = DataSelectGridView.Rows[iLp].Cells[0] as DataGridViewCheckBoxCell;
                    if ((bool)cell.Value == true)
                    {
                        // チェック済み有り
                        cell.Value = !((bool)cell.Value);
                        bRtn = true;
                        //break;
                    }
                }
            }
            return bRtn;
        }

        /// <summary>
        /// <para>method outline</para>
        /// <para>TabControl選択処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>DataSelectTabControl_SelectedIndexChanged(sender, e)</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void DataSelectTabControl_SelectedIndexChanged(object sender, EventArgs e)
        {
            if (DataSelectTabControl.SelectedTab == D3Mesh)
            {//初期設定タブを無効とする。
                DataSelectTabControl.SelectedTab = D2Mesh;
            }
        }

        /// <summary>
        /// <para>method outline</para>
        /// <para>セル入力フォーカス取得イベント処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>DataSelectGridView_CellEnter(sender, e)</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void DataSelectGridView_CellEnter(object sender, DataGridViewCellEventArgs e)
        {
            // 列ヘッダクリック時対策
            if (e.RowIndex == -1)
            {
                return;
            }
            // 1行選択
            DataSelectGridView.SelectionMode = DataGridViewSelectionMode.FullRowSelect;
            // 入力ファイルフルパス表示
            DataGridViewTextBoxCell TextCell = DataSelectGridView.Rows[e.RowIndex].Cells[3] as DataGridViewTextBoxCell;
            HySString csFullPath = new HySString((string)TextCell.Value);
            this.InputFileNameBox.Text = csFullPath.ToString();
            // 右端表示(長いフルパスでもファイル名が認識できるよう)
            this.InputFileNameBox.SelectAll();
            int idx = this.InputFileNameBox.SelectionLength;
            this.InputFileNameBox.SelectionStart = idx;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>KML出力中監視タイマー</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>CheckKMLTimer(sender,e)</para>
        /// </example>
        /// <param name="sender">オブジェクト</param>
        /// <param name="e">イベント</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void CheckKMLTimer(object sender, EventArgs e)
        {
            if (HySGISCtlViewerJob.KMLOUT_THREAD_WORK == true)
            {
                // KML出力処理開始
                this.Text = "KML出力中";
                // コントロール抑止
                this.Enabled = false;
            }
            else if (HySGISCtlViewerJob.KMLOUT_THREAD_WORK == false)
            {
                if (HySGISCtlViewerJob.KMLOUT_STATUS == true)
                {
                    // タイマ停止
                    CheckKMLFileOutTimer.Stop();
                    CheckKMLFileOutTimer.Enabled = false;
                    MessageBox.Show("KML出力が完了しました。", "GIS表示", MessageBoxButtons.OK, MessageBoxIcon.Information);
                }
                else if (HySGISCtlViewerJob.KMLOUT_STATUS == false)
                {
                    // タイマ停止
                    CheckKMLFileOutTimer.Stop();
                    CheckKMLFileOutTimer.Enabled = false;
                    MessageBox.Show("処理中にエラーが発生したため、KML出力に失敗しました。", "GIS表示", MessageBoxButtons.OK, MessageBoxIcon.Error);
                }
                // KML出力処理終了
                this.Text = "GIS表示データ選択";
                // コントロール有効
                this.Enabled = true;
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>データ項目削除</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>DeleteList(sender,e)</para>
        /// </example>
        /// <param name="sender">オブジェクト</param>
        /// <param name="e">イベント</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void DeleteList(object sender, EventArgs e)
        {
            if (DataSelectGridView.SelectedRows.Count <= 0)
            {// 選択無しの場合は、処理無し
                return;
            }

            string csFullPath = (string)DataSelectGridView.SelectedRows[0].Cells[3].Value;
            m_csInputFileChkTable.DeleteData(new HySString(csFullPath));
            DataSelectGridView.ClearSelection();
            for (int iLp = DataSelectGridView.RowCount-1; iLp >= 0; iLp--)
            {
                if (csFullPath.Equals((string)DataSelectGridView[3, iLp].Value) == true)
                {// ファイル名が一致（フルパス）
                    if ((bool)DataSelectGridView[0, iLp].Value == true)
                    {// 非活性
                        MapDispButton.Enabled = false;
                        KMLOutButton.Enabled = false;
                    }
                    DataSelectGridView.Rows.RemoveAt(iLp);
                }
            }

            //　選択無しの場合、ファイル名称テキストボックスクリア
            if (DataSelectGridView.RowCount <= 0)
            {
                InputFileNameBox.Text = "";
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>データ項目全て削除</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>AllDeleteList(sender,e)</para>
        /// </example>
        /// <param name="sender">オブジェクト</param>
        /// <param name="e">イベント</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void AllDeleteList(object sender, EventArgs e)
        {
            //管理情報クリア
            DataSelectGridView.Rows.Clear();
            m_csInputFileChkTable.ClearAllObject();
            InputFileNameBox.Text = "";

            // 非活性
            MapDispButton.Enabled = false;
            KMLOutButton.Enabled = false;
        }
    }
}
