﻿// <summary>ソースコード：メインプログラム</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Windows.Forms;

using CommonMP.HYSSOP.Interface.HSController;
using CommonMP.HYSSOP.CoreImpl.HSController;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;
using CommonMP.HYMCO.CoreOptions.McViewer.DotNetViewer;

namespace CommonMPMain
{
    static class CommonMPProgram
    {
        /// <summary><para>class outline:</para>
        /// <para>アプリケーションのメイン エントリ ポイントです。</para>
        /// </summary>
        /// <remarks><para>history:</para>
        /// <para>[CommonMP][ver 1.0.0][2008/10/01][新規作成]</para>
        /// </remarks>
        [STAThread]
        static int Main(string[] sArgs)
        {
            int iRtn = 0;
            HySString csCinfigFileName = null;
            csCinfigFileName = new HySString("CommonMP.cfg");
            // 起動引数チェック
            if (sArgs.Length == 0)
            {
                // Do Nothing
                //csCinfigFileName = new HySString("CommonMP.cfg");
            }
            else if (sArgs[0] == "-c")
            {
                csCinfigFileName = new HySString(sArgs[1]);
            }

            HySFile csErrFile = new HySFile(HySEnvInf.sErorrFileName);
            csErrFile.Delete();

            //GC.Collect(); // 強制　ガベージコレクション
            // 二重起動チェックを行う。
            if (System.Diagnostics.Process.GetProcessesByName(
                System.Diagnostics.Process.GetCurrentProcess().ProcessName).Length <= 1)
            {   // 起動されていない場合のみ起動する。

                // 地域情報をTheadにセット
                System.Threading.Thread.CurrentThread.CurrentUICulture = System.Globalization.CultureInfo.CurrentCulture;

                // ライブラリ入力処理
                HySFile libraryImportInfoFile = new HySFile("..\\temp\\LibraryImportInfo");
                if (libraryImportInfoFile.Exist() == true)
                {   // ライブラリ入力情報ファイルが有る場合
                    McStartupLibraryImport.ImportLibrary(libraryImportInfoFile);
                    libraryImportInfoFile.Delete();
                }

                // システム制御生成
                HySSystemController csSysCtl = new HySSystemController();
                csSysCtl.SetSystemController(csSysCtl);
                //csSysCtl.SetConfigureFileName(new HySString("CommonMP.cfg"));
                csSysCtl.SetConfigureFileName(csCinfigFileName);

                // システム制御初期処理
                if (csSysCtl.Initialize() == true)
                {
                    // システム起動
                    if (csSysCtl.WakeUp() == true)
                    {
                        //// メイン画面起動
                        csSysCtl.Run();
                    }
                    else
                    {   // システム起動時に異常発生
                        if (csErrFile.Exist() == true)
                        {
                            csErrFile.Open(HySFile.OPEN_MODE.APPEND, HySFile.READ_WRITE_MODE.WRITE, HySFile.DIRECTORY_MODE.NOT_MK_DIR);
                        }
                        else
                        {
                            csErrFile.Open(HySFile.OPEN_MODE.OPEN_OR_CREAT, HySFile.READ_WRITE_MODE.WRITE, HySFile.DIRECTORY_MODE.NOT_MK_DIR);
                        }
                        csErrFile.WriteText("Fail System WakeUp.");
                        csErrFile.WriteText("Abnormal End  CommonMP.");
                        csErrFile.Close();
                        iRtn = -1;
                    }
                }
                else
                {   // 初期化時に異常発生
                    if (csErrFile.Exist() == true)
                    {
                        csErrFile.Open(HySFile.OPEN_MODE.APPEND, HySFile.READ_WRITE_MODE.WRITE, HySFile.DIRECTORY_MODE.NOT_MK_DIR);
                    }
                    else
                    {
                        csErrFile.Open(HySFile.OPEN_MODE.OPEN_OR_CREAT, HySFile.READ_WRITE_MODE.WRITE, HySFile.DIRECTORY_MODE.NOT_MK_DIR);
                    }
                    csErrFile.WriteText("Fail System Initialize.");
                    csErrFile.WriteText("Abnormal End  CommonMP.");
                    csErrFile.Close();
                    iRtn = -1;
                }
            }
            else
            {   // ２重起動
                if (csErrFile.Exist() == true)
                {
                    csErrFile.Open(HySFile.OPEN_MODE.APPEND, HySFile.READ_WRITE_MODE.WRITE, HySFile.DIRECTORY_MODE.NOT_MK_DIR);
                }
                else
                {
                    csErrFile.Open(HySFile.OPEN_MODE.OPEN_OR_CREAT, HySFile.READ_WRITE_MODE.WRITE, HySFile.DIRECTORY_MODE.NOT_MK_DIR);
                }
                csErrFile.WriteText("CommonMPの２重起動");
                csErrFile.WriteText("Abnormal End  CommonMP.");
                csErrFile.Close();
                iRtn = -1;
            }
            //Application.Exit(); <-- これはダメ
            if (iRtn != 0)
            {   // 異常発生の場合には強制終了
                System.Environment.Exit(iRtn);
            }
            return iRtn;
        }
    }
}