﻿// <summary>ソースコード：>リモートサーバのオブザーバ</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;

namespace CommonMP.HYSSOP.OptionImpl.HSCommunicationTool.HyssopDotNetIpcTool
{
    /// <summary><para>class outline:</para>
    /// <para>リモートサーバのオブザーバ</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2009/12/28][新規作成]</para>
    /// <para>このインターフェースの実装クラスを<see cref="HySIpcRemoteService.SetObserver"/>で
    /// 登録することにより、外部デバッガプロセスからの送信データを受信する。</para>
    /// </remarks>
    public interface HySIpcRemoteSerivceObserverIF
    {
        /// <summary><para>method outline:</para>
        /// <para>データ送信通知</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SendDataNotify(csName, csData)</para>
        /// </example>
        /// <param name="csName">クライアントから送信されたデータの名前</param>
        /// <param name="csData">クライアントから送信されたデータの実体</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        void SendDataNotify(string csName, object csData);
    }
}
