﻿// <summary>ソースコード：定義データクラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.Interface;
using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;

namespace CommonMP.HYSSOP.OptionImpl.HSDIConfEditor
{
    /// <summary><para>class outline:</para>
    /// <para>定義データクラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.2.0][2011/12/01][新規作成]</para>
    /// </remarks>
    public class DiconFileData : HySRoot
    {
        /// <summary>キー名称リスト</summary>
        private IList m_csKeyList;

        /// <summary>種別</summary>
        private Hashtable m_csKind;

        /// <summary>ＤＬＬ名称</summary>
        private Hashtable m_csDllName;

        /// <summary>パッケージ名称</summary>
        private Hashtable m_csPackageName;

        /// <summary>クラス名</summary>
        private Hashtable m_csClassName;

        /// <summary><para>method outline:</para>
        /// <para>デフォルトコンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>HySConfigData csData = new HySConfigData()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public DiconFileData()
        {
            m_csKeyList = new ArrayList();
            m_csKind = new Hashtable();
            m_csDllName = new Hashtable();
            m_csPackageName = new Hashtable();
            m_csClassName = new Hashtable();
        }

        /// <summary><para>method outline:</para>
        /// <para>ファクトリクラスデータ設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>AddConfigData( csKey,csKind,csPackage,csClass,csDll )</para>
        /// </example>
        /// <param name="csKey">キー</param>
        /// <param name="csKind">種別名</param>
        /// <param name="csPackage">パッケージ名</param>
        /// <param name="csClass">クラス名</param>
        /// <param name="csDll">ＤＬＬ名</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void AddConfigData(String csKey, String csKind, String csPackage, String csClass, String csDll)
        {
            m_csKeyList.Add(csKey);
            m_csKind[csKey] = csKind;
            m_csDllName[csKey] = csDll;
            m_csPackageName[csKey] = csPackage;
            m_csClassName[csKey] = csClass;
        }

        /// <summary><para>method outline:</para>
        /// <para>キー指定種別名称取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>String csKind = GetFactoryKind( csKey )</para>
        /// </example>
        /// <param name="csKey">キー</param>
        /// <returns>種別名称</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public String GetFactoryKind(String csKey)
        {
            return (String)m_csKind[csKey];
        }

        /// <summary><para>method outline:</para>
        /// <para>キー指定ＤＬＬ名称取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>String csDll = GetFactoryDll( csKey )</para>
        /// </example>
        /// <param name="csKey">キー</param>
        /// <returns>ＤＬＬ名称</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public String GetFactoryDll(String csKey)
        {
            return (String)m_csDllName[csKey];
        }

        /// <summary><para>method outline:</para>
        /// <para>キー指定クラス名称取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>String csClass = GetFactoryClass( csKey )</para>
        /// </example>
        /// <param name="csKey">キー</param>
        /// <returns>クラス名称</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public String GetFactoryClass(String csKey)
        {
            return (String)m_csClassName[csKey];
        }

        /// <summary><para>method outline:</para>
        /// <para>キー指定パッケージ名称取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>String csPack = GetFactoryPackage( csKey )</para>
        /// </example>
        /// <param name="csKey">キー</param>
        /// <returns>パッケージ名称</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public String GetFactoryPackage(String csKey)
        {
            return (String)m_csPackageName[csKey];
        }

        /// <summary><para>method outline:</para>
        /// <para>キー位置指定種別名称取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>String csKind = GetFactoryKind( lIndex )</para>
        /// </example>
        /// <param name="lIndex">キー位置</param>
        /// <returns>種別名称</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public string GetFactoryKind(long lIndex)
        {
            return (string)m_csKind[m_csKeyList[(int)lIndex]];
        }

        /// <summary><para>method outline:</para>
        /// <para>キー位置指定ＤＬＬ名称取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>String csDll = GetFactoryDll( lIndex )</para>
        /// </example>
        /// <param name="lIndex">キー位置</param>
        /// <returns>ＤＬＬ名称</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public string GetFactoryDll(long lIndex)
        {
            return (string)m_csDllName[m_csKeyList[(int)lIndex]];
        }

        /// <summary><para>method outline:</para>
        /// <para>キー位置指定クラス名称取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>String csClass = GetFactoryClass( lIndex )</para>
        /// </example>
        /// <param name="lIndex">キー位置</param>
        /// <returns>クラス名称</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public string GetFactoryClass(long lIndex)
        {
            return (string)m_csClassName[m_csKeyList[(int)lIndex]];
        }

        /// <summary><para>method outline:</para>
        /// <para>キー位置指定パッケージ名称取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>String csPack = GetFactoryPackage( lIndex )</para>
        /// </example>
        /// <param name="lIndex">キー位置</param>
        /// <returns>パッケージ名称</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public string GetFactoryPackage(long lIndex)
        {
            return (string)m_csPackageName[m_csKeyList[(int)lIndex]];
        }

        /// <summary><para>method outline:</para>
        /// <para>データ数取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>long lNum = Count( )</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>データ数</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public long Count
        {
            get
            {
                return (long)m_csKeyList.Count;
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>キー位置指定データキー取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>String csPack = GetKeyName( lIndex )</para>
        /// </example>
        /// <param name="lIndex">キー位置</param>
        /// <returns>データキー</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public string GetKeyName(long lIndex)
        {
            return (string)m_csKeyList[(int)lIndex];
        }

        /// <summary><para>method outline:</para>
        /// <para>データのクリア</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>Clear()</para>
        /// </example>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void Clear()
        {
            m_csKeyList.Clear();
            m_csKind.Clear();
            m_csDllName.Clear();
            m_csPackageName.Clear();
            m_csClassName.Clear();
        }

        /// <summary><para>method outline:</para>
        /// <para>ファクトリクラスデータ削除</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>RemoveConfigData( csKey )</para>
        /// </example>
        /// <param name="csKey">キー</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void RemoveConfigData(String csKey)
        {
            m_csKeyList.Remove(csKey);
            m_csKind.Remove(csKey);
            m_csDllName.Remove(csKey);
            m_csPackageName.Remove(csKey);
            m_csClassName.Remove(csKey);
        }

    }
}