﻿// <summary>ソースコード：ツール管理（アセンブリ設定）画面クラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Reflection;
using System.Collections;
using System.IO;
using System.Xml;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.Interface.HSTools;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;
using CommonMP.HYSSOP.CoreImpl.HSTools.Msg;


namespace CommonMP.HYSSOP.OptionImpl.HSDIConfEditor
{
    /// <summary><para>class outline:</para>
    /// <para>ツール管理（アセンブリ設定）画面クラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.2.0][2011/12/01][新規作成]</para>
    /// </remarks>
    public partial class DIConfEditorForm : Form
    {
        ///// <summary>ログ出力用クラス名称</summary>
        //static private readonly string CLASS_NAME = "DIConfEditorForm";
        /// <summary>環境情報管理クラス</summary>
        private HySEnvInf m_csEnvInf;

        /// <summary>
        /// メッセージボックスタイトル『ツール管理（アセンブリ設定）』
        /// </summary>
        private static readonly string MSGBOX_TITLE = HysMessage.GetString("HYS_MSG_TITLE_COMMON_MP");
        /// <summary>「編集するファイルを指定してください。」</summary>
        private static readonly string MSG_SELECT_DATA_DICON = Properties.HSDIConfEditorResources.HYS_MSG_CHECK_SELECT_DATA_DICON;
        /// <summary>「修正情報があります。保存されませんが宜しいですか？」</summary>
        private static readonly string MSG_SAVE_DATA_DICON =  Properties.HSDIConfEditorResources.HYS_MSG_INFO_SAVE_DATA_DICON;
        /// <summary>「設定済みの情報が含まれていました。」</summary>
        private static readonly string MSG_EXIST_DATA_ASSEMBLY =  Properties.HSDIConfEditorResources.HYS_MSG_WARNING_EXIST_DATA_ASSEMBLY;

        /// <summary> DICONファイル選択画面フィルター</summary>
        static private readonly string DICON_DLG_FILTER =
            Properties.HSDIConfEditorResources.ResourceManager.GetString("FILE_DLG_FILTER_DICON");
        /// <summary> DLLファイル選択画面フィルター</summary>
        static private readonly string DLL_DLG_FILTER =
            Properties.HSDIConfEditorResources.ResourceManager.GetString("FILE_DLG_FILTER_DLL");


        /// <summary> XMLタグ　components </summary>
        static public readonly string xml_COMPONEBTS = "components";
        /// <summary> XMLタグ　component </summary>
        static public readonly string xml_COMPONEBT = "component";
        /// <summary> XMLタグ　kind </summary>
        static public readonly string xml_KIND = "kind";
        /// <summary> XMLタグ　package </summary>
        static public readonly string xml_PACKAGE = "package";
        /// <summary> XMLタグ　class </summary>
        static public readonly string xml_CLASS = "class";
        /// <summary> XMLタグ　dll </summary>
        static public readonly string xml_DLL = "dll";

        /// <summary> バックアップ拡張子 </summary>
        static public readonly string extension_BACKUP = ".backup";

        /// <summary> 定義データ</summary>
        private DiconFileData m_csDIConfigData = new DiconFileData();

        ///// <summary> プロセス起動ホームディレクトリ </summary>
        //private HySString m_csHomeDirectory = null;
        /// <summary> 編集ＤＩＣＯＮファイル（フルパス） </summary>
        private string m_csFileFullName;

        /// <summary> 修正有無フラグ </summary>
        private bool m_bModifyFlg = false;

        /// <summary> 処理対象ファクトリー種別 </summary>
        private Hashtable m_csFactoryKindData = new Hashtable();


        /// <summary><para>method outline:</para>
        /// <para>デフォルトコンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>DIConfEditorForm csDotNetForm = new DIConfEditorForm()</para>
        /// </example>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public DIConfEditorForm()
        {
            InitializeComponent();

            toolTip1.SetToolTip(Register_Button, Properties.HSDIConfEditorResources.TOOLTIP_MSG_REGISTER);
            toolTip1.SetToolTip(Undo_Button, Properties.HSDIConfEditorResources.TOOLTIP_MSG_UNDO);

            m_csEnvInf = new HySEnvInf(new HySString("CommonMP.cfg"));
//            m_csEnvInf.Initialize();
            m_csEnvInf.InitializeNoLog();
            HSDIConfEditorProgram.startLOG();

            //// ホームディレクトリ取得
            //DirectoryInfo csDi = Directory.GetParent(Directory.GetCurrentDirectory());
            //m_csHomeDirectory = new HySString(csDi.ToString());

            // 処理対象ファクトリー種別定義読込み
            //LoadFactoryKind(m_csHomeDirectory + new HySString("\\conf\\DiconFactory.xml"));
            LoadFactoryKind(HySEnvInf.GetHomeDirectory() + new HySString("\\conf\\DiconFactory.xml"));

            m_bModifyFlg = false;
            Undo_Button.Enabled = false;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>ＤＩＣＯＮファイル選択ボタン処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>FileSelect_Button_Click(sender,e)</para>
        /// </example>
        /// <param name="sender">オブジェクト</param>
        /// <param name="e">イベント</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void FileSelect_Button_Click(object sender, EventArgs e)
        {
            if (m_bModifyFlg == true)
            {// 修正有り
                // "修正情報があります。保存されませんがよろしいですが？"
                if (MessageBox.Show(MSG_SAVE_DATA_DICON, MSGBOX_TITLE, MessageBoxButtons.OKCancel, MessageBoxIcon.Information) == DialogResult.Cancel)
                {
                    return;
                }
            }

            // 表示フォルダ設定
//            DiconFile_OpenFileDialog.InitialDirectory = m_csHomeDirectory.ToString() + "\\conf";
            DiconFile_OpenFileDialog.InitialDirectory = HySEnvInf.GetHomeDirectory().ToString() + "\\conf";
            DiconFile_OpenFileDialog.Filter = DICON_DLG_FILTER;

            if (DiconFile_OpenFileDialog.ShowDialog() == DialogResult.OK)
            {
                FilePath_TextBox.Text = "";
                Item_DataGridView.Rows.Clear();
                Item_DataGridView.RowCount = 0;
                Dll_TextBox.Text = "";
                m_bModifyFlg = false;
                Undo_Button.Enabled = false;
                Assembly_DataGridView.Rows.Clear();

                m_csFileFullName = DiconFile_OpenFileDialog.FileName;

                HySXmlReader csXmlRFile = new HySXmlReader(m_csFileFullName);
                if (Parser(csXmlRFile) == -1)
                {// 読込ファイルデータ取得異常
                    return;
                }
                FilePath_TextBox.Text = m_csFileFullName;
                AddGridView();

                HySFile csFile = new HySFile(m_csFileFullName + extension_BACKUP);
                if (csFile.Exist() == true)
                {
                    Undo_Button.Enabled = true;
                }
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>登録ボタン処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>Register_Button_Click(sender,e)</para>
        /// </example>
        /// <param name="sender">オブジェクト</param>
        /// <param name="e">イベント</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void Register_Button_Click(object sender, EventArgs e)
        {
            if (m_csFileFullName != "" && m_bModifyFlg == true)
            {
                try
                {
                    //File.Move(m_csFileFullName, m_csFileFullName + extension_BACKUP);
                    File.Copy(m_csFileFullName, m_csFileFullName + extension_BACKUP, true);
                }
                catch
                {// バックアップ異常
                    HSDIConfEditorProgram.ErrorLOG("DIConfEditorForm.Register_Button_Click", "バックアップファイル作成失敗");
                }


                HySXmlNode csRootNode = null;           // ルートノード
                HySXmlNode csBodyNode = null;           // Bodyノード

                if (m_csDIConfigData.Count > 0)
                {
                    HySXmlWriter csXmlFile = new HySXmlWriter(m_csFileFullName);
                    csRootNode = csXmlFile.CreateRoot(xml_COMPONEBTS);

                    for (long lLoop = 0; lLoop < m_csDIConfigData.Count; lLoop++)
                    {
                        string csKey = m_csDIConfigData.GetKeyName(lLoop);
                        if (csKey != "")
                        {
                            csBodyNode = csXmlFile.CreateElement(xml_COMPONEBT);
                            csBodyNode.SetAttribute(xml_KIND, m_csDIConfigData.GetFactoryKind(csKey));
                            csBodyNode.SetAttribute(xml_PACKAGE, m_csDIConfigData.GetFactoryPackage(csKey));
                            csBodyNode.SetAttribute(xml_CLASS, m_csDIConfigData.GetFactoryClass(csKey));
                            csBodyNode.SetAttribute(xml_DLL, m_csDIConfigData.GetFactoryDll(csKey));

                            csRootNode.AppendChild(csBodyNode);                     // ルートノードに追加
                        }

                    }
                    // ファイル保存
                    if (csXmlFile.Save() != true)
                    {
                        HSDIConfEditorProgram.ErrorLOG("DIConfEditorForm.Register_Button_Click", "DICONファイル保存失敗");
                    }

                }

                m_csDIConfigData.Clear();
                Assembly_DataGridView.Rows.Clear();
                Assembly_DataGridView.RowCount = 0;
                FilePath_TextBox.Text = "";

                Item_DataGridView.Rows.Clear();
                Item_DataGridView.RowCount = 0;
                Dll_TextBox.Text = "";

                m_bModifyFlg = false;　// 修正無し
                Undo_Button.Enabled = false;
            }

        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>行削除ボタン処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>RowDelete_Button_Click(sender,e)</para>
        /// </example>
        /// <param name="sender">オブジェクト</param>
        /// <param name="e">イベント</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void RowDelete_Button_Click(object sender, EventArgs e)
        {
            int iIndex = -1;
            int cnt = 0;
            if (Assembly_DataGridView.SelectedRows.Count != 0)
            {
                while(Assembly_DataGridView.SelectedRows.Count >0)
                {
                    cnt = Assembly_DataGridView.SelectedRows.Count;
                    iIndex = Assembly_DataGridView.SelectedRows[0].Index;
                    // 保存情報削除
                    string csPackage = Assembly_DataGridView.SelectedRows[0].Cells[NameSpace_DIC.Name].Value.ToString();
                    string csClassName = Assembly_DataGridView.SelectedRows[0].Cells[Class_DIC.Name].Value.ToString();
                    string csDllName = Assembly_DataGridView.SelectedRows[0].Cells[Dll_DIC.Name].Value.ToString();
                    // キーをパッケージ＋クラス名称＋ＤＬＬ名称とする。
                    string csKey = csPackage + "_" + csClassName + "_" + csDllName;
                    m_csDIConfigData.RemoveConfigData(csKey);

                    // グリッドビュー行削除
                    Assembly_DataGridView.Rows.RemoveAt(iIndex);
                    if (cnt == 1)
                    {
                        Assembly_DataGridView.ClearSelection();
                    }
                }
                m_bModifyFlg = true;　// 修正有り
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>ＤＬＬファイル選択ボタン処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>AssemblySelect_Button_Click(sender,e)</para>
        /// </example>
        /// <param name="sender">オブジェクト</param>
        /// <param name="e">イベント</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void AssemblySelect_Button_Click(object sender, EventArgs e)
        {
            string AssemblyDir = null;
            Assembly csAssembly = null;
            string csDLLFullName;
            string csDllName;

            // 指定されたDLLよりnamespace名称を取得する
            if (m_csFileFullName != "" && m_csFileFullName != null)
            {
                DirectoryInfo csDi = Directory.GetParent(Directory.GetParent(m_csFileFullName).ToString());
                AssemblyDir = csDi.ToString() + "\\bin";
                if (Directory.Exists(AssemblyDir) == true)
                {// ディレクトリ有り
                    DllFile_OpenFileDialog.InitialDirectory = AssemblyDir;
                }
                else
                {// ディレクトリ無し　開発環境等は、ディレクトリが絞り込めないため、１つ上の階層を表示
                    DllFile_OpenFileDialog.InitialDirectory = csDi.ToString();
                }
                DllFile_OpenFileDialog.Filter = DLL_DLG_FILTER;

                DialogResult csRtn = DllFile_OpenFileDialog.ShowDialog();
                if (csRtn == DialogResult.OK)
                {
                    csDLLFullName = DllFile_OpenFileDialog.FileName;
                    int iIndex = csDLLFullName.LastIndexOf("\\");
                    csDllName = csDLLFullName.Substring(iIndex + 1, csDLLFullName.Length - (iIndex + 1));
                    // リストのクリア
                    Item_DataGridView.Rows.Clear();
                    Item_DataGridView.RowCount = 0;

                    Dll_TextBox.Text = csDllName;

                    try
                    {
                        csAssembly = Assembly.LoadFrom(csDllName);         // アセンブリ取り込み
                        Type[] csType = csAssembly.GetTypes();
                        //型の情報を表示する
                        foreach (Type t in csType)
                        {
                            string csKindName = null;

                            // ファクトリー種別の確認
                            Type[] csInterfaceType = t.GetInterfaces();
                            foreach (Type Int_t in csInterfaceType)
                            {

                                if ((object)Int_t.Name == null)
                                {
                                    continue;
                                }

                                csKindName = (string)m_csFactoryKindData[Int_t.Name.ToString()];
                                if (csKindName != null)
                                {
                                    break;
                                }
                            }

                            if (csKindName != null)
                            {
                                Item_DataGridView.Rows.Add();
                                // ファクトリクラス名称の設定
                                Item_DataGridView.Rows[Item_DataGridView.Rows.Count - 1].Cells[Class_DLL.Name].Value = t.Name.ToString();
                                // 種別
                                Item_DataGridView.Rows[Item_DataGridView.Rows.Count - 1].Cells[Kind_DLL.Name].Value = csKindName;
                                // ネームスペース名称の設定
                                Item_DataGridView.Rows[Item_DataGridView.Rows.Count - 1].Cells[NameSpace_DLL.Name].Value = t.Namespace.ToString();

                            }

                        }

                        Item_DataGridView.ClearSelection();
                    }
                    catch
                    {
                        HSDIConfEditorProgram.ErrorLOG("DIConfEditorForm.AssemblySelect_Button_Click", "アセンブリ情報読込み失敗");
                    }
                }
            }
            else
            {
                // "編集するファイルを指定してください。"
                MessageBox.Show(MSG_SELECT_DATA_DICON, MSGBOX_TITLE, MessageBoxButtons.OK, MessageBoxIcon.Information);
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>読み込み情報解析</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>Parser(csXmlReader)</para>
        /// </example>
        /// <param name="csXmlReader">読込み情報</param>
        /// <returns>=1:正常　=-1:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public long Parser(HySXmlReader csXmlReader)
        {
            HySXmlNode csRootNode;
            HySXmlNodeList csNodeList;
            HySXmlNode csNode;
            long lNodeListCount;
            long lLoop;

            String csKey;
            String csKind;
            String csPackage;
            String csClassName;
            String csDllName;

            m_csDIConfigData.Clear();
            
            try
            {
                csRootNode = csXmlReader.GetRootNode();
                csNodeList = csRootNode.GetChildNodeList();
                lNodeListCount = csNodeList.GetCount();
                for (lLoop = 0; lLoop < lNodeListCount; lLoop++)
                {
                     csNode = csNodeList.GetNode(lLoop);
                    string cname = csNode.GetName();
                    if (cname.CompareTo("#comment") != 0)
                    {

                        csKind = csNode.GetAttribute(xml_KIND);
                        csPackage = csNode.GetAttribute(xml_PACKAGE);
                        csClassName = csNode.GetAttribute(xml_CLASS);
                        csDllName = csNode.GetAttribute(xml_DLL);

                        // キーをパッケージ＋クラス名称＋ＤＬＬ名称とする。
                        csKey = csPackage + "_" + csClassName + "_" + csDllName;

                        if ((csClassName != null) &&
                            (csDllName != null) &&
                            (csPackage != null))
                        {
                            m_csDIConfigData.AddConfigData(csKey, csKind, csPackage, csClassName, csDllName);
                        }
                    }
                }

                return 1;
            }
            catch
            {
                HSDIConfEditorProgram.ErrorLOG("DIConfEditorForm.Parser", "DICON定義ファイル解析異常発生");
                return -1;
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>ＤＩＣＯＮグリットビュー表示</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>AddGridView()</para>
        /// </example>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void AddGridView()
        {
            Assembly_DataGridView.Rows.Clear();
            Assembly_DataGridView.RowCount = 0;
            if (m_csDIConfigData.Count > 0)
            {
                int iCnt = 0;
                Assembly_DataGridView.RowCount = (int)m_csDIConfigData.Count;
                for (long lLoop = 0; lLoop < m_csDIConfigData.Count; lLoop++)
                {
                    string csKey = m_csDIConfigData.GetKeyName(lLoop);
                    if (csKey != "")
                    {
                        Assembly_DataGridView.Rows[iCnt].Cells[Kind_DIC.Name].Value = m_csDIConfigData.GetFactoryKind(csKey);
                        Assembly_DataGridView.Rows[iCnt].Cells[NameSpace_DIC.Name].Value = m_csDIConfigData.GetFactoryPackage(csKey);
                        Assembly_DataGridView.Rows[iCnt].Cells[Class_DIC.Name].Value = m_csDIConfigData.GetFactoryClass(csKey);
                        Assembly_DataGridView.Rows[iCnt].Cells[Dll_DIC.Name].Value = m_csDIConfigData.GetFactoryDll(csKey);
                        iCnt++;
                    }
                }
                Assembly_DataGridView.ClearSelection();
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>追加ボタン処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>Apend_Button_Click(sender,e)</para>
        /// </example>
        /// <param name="sender">オブジェクト</param>
        /// <param name="e">イベント</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void Apend_Button_Click(object sender, EventArgs e)
        {
            if(Item_DataGridView.SelectedRows.Count == 0)
            {// 選択無し
                return;
            }

            bool bFlg = false;

            for (int iLoop = 0; iLoop < Item_DataGridView.SelectedRows.Count; iLoop++ )
            {
                string csKind = (string)Item_DataGridView.SelectedRows[iLoop].Cells[Kind_DLL.Name].Value;
                string csPackage = (string)Item_DataGridView.SelectedRows[iLoop].Cells[NameSpace_DLL.Name].Value;
                string csClassName = (string)Item_DataGridView.SelectedRows[iLoop].Cells[Class_DLL.Name].Value;
                string csDllName = Dll_TextBox.Text;

                // キーをパッケージ＋クラス名称＋ＤＬＬ名称とする。
                string csKey = csPackage + "_" + csClassName + "_" + csDllName;
                if (m_csDIConfigData.GetFactoryPackage(csKey) == null)
                {
                    m_csDIConfigData.AddConfigData(csKey, csKind, csPackage, csClassName, csDllName);
                    Assembly_DataGridView.Rows.Add();
                    Assembly_DataGridView.Rows[Assembly_DataGridView.RowCount - 1].Cells[Kind_DIC.Name].Value = csKind;
                    Assembly_DataGridView.Rows[Assembly_DataGridView.RowCount - 1].Cells[NameSpace_DIC.Name].Value = csPackage;
                    Assembly_DataGridView.Rows[Assembly_DataGridView.RowCount - 1].Cells[Class_DIC.Name].Value = csClassName;
                    Assembly_DataGridView.Rows[Assembly_DataGridView.RowCount - 1].Cells[Dll_DIC.Name].Value = csDllName;
                }
                else
                {// 重複情報有り
                    bFlg = true;
                }
            }
            
            Item_DataGridView.ClearSelection();
            m_bModifyFlg = true;　// 修正有り

            if (bFlg == true)
            {// 重複情報有り
                // "設定済みの情報が含まれていました。"
                MessageBox.Show(MSG_EXIST_DATA_ASSEMBLY, MSGBOX_TITLE, MessageBoxButtons.OK, MessageBoxIcon.Information);
            }

        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>クローズボタン処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>DIConfEditorForm_FormClosing(sender,e)</para>
        /// </example>
        /// <param name="sender">オブジェクト</param>
        /// <param name="e">イベント</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void DIConfEditorForm_FormClosing(object sender, FormClosingEventArgs e)
        {
            if (m_bModifyFlg == true)
            {// 修正有り
                // "修正情報があります。保存されませんがよろしいですが？"
                if (MessageBox.Show(MSG_SAVE_DATA_DICON, MSGBOX_TITLE, MessageBoxButtons.OKCancel, MessageBoxIcon.Information) == DialogResult.Cancel)
                {
                    e.Cancel = true;           
                }
            }

        }
        
        /// <summary><para>method outline:</para>
        /// <para>処理対象アセンブリ定義情報読込み</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>LoadFactoryKind(csFileName)</para>
        /// </example>
        /// <param name="csFileName">ファイル名称</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void LoadFactoryKind(HySString csFileName)
        {
            HySXmlNode csRootNode;
            HySXmlNodeList csNodeList;
            HySXmlNode csNode;
            long lNodeListCount;
            long lLoop;
            string csKind;
            string csClassName;

            HySFile csFile = new HySFile(csFileName.ToString());
            if (csFile.Exist() == false)
            {// 定義ファイル無し
                return;
            }

            try
            {
                HySXmlReader csXmlReader = new HySXmlReader(csFileName.ToString());

                csRootNode = csXmlReader.GetRootNode();
                csNodeList = csRootNode.GetChildNodeList();
                lNodeListCount = csNodeList.GetCount();
                for (lLoop = 0; lLoop < lNodeListCount; lLoop++)
                {// データ件数分処理
                    csNode = csNodeList.GetNode(lLoop);
                    string cname = csNode.GetName();
                    if (cname.CompareTo("#comment") != 0)
                    {// コメントは対象外

                        csKind = csNode.GetAttribute(xml_KIND);
                        csClassName = csNode.GetAttribute(xml_CLASS);

                        //m_csFactoryKindData.Add(csClassName, csKind);
                        m_csFactoryKindData[csClassName] = csKind;
                    }
                }
            }
            catch
            {
                HSDIConfEditorProgram.ErrorLOG("DIConfEditorForm.LoadFactoryKind", "処理対象アセンブリ定義情報読込み失敗");
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>復元ボタン処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>Undo_Button_Click(sender,e)</para>
        /// </example>
        /// <param name="sender">オブジェクト</param>
        /// <param name="e">イベント</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>編集中のdiconのバックアップファイルが有る場合、情報を読込み表示する</para>
        /// </remarks>
        private void Undo_Button_Click(object sender, EventArgs e)
        {
            HySXmlReader csXmlRFile = new HySXmlReader(m_csFileFullName + extension_BACKUP);
            Parser(csXmlRFile);
            AddGridView();

            m_bModifyFlg = true;
        }

        /// <summary><para>method outline</para>
        /// <para>ヘルプリンクイベント</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>Help_Button_Click(sender, e)</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void HelpJump_button_Click(object sender, EventArgs e)
        {
            // ヘルプ画面の表示
            HySShowHelpNavigator.ShowHelpNavigator(HySShowHelpNavigator.NAV_MSG_TOOL_0001, null);
        }

        /// <summary><para>method outline:</para>
        /// <para>終了ボタン処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>Close_Button_Click(sender,e)</para>
        /// </example>
        /// <param name="sender">オブジェクト</param>
        /// <param name="e">イベント</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>無し</para>
        /// </remarks>
        private void Close_Button_Click(object sender, EventArgs e)
        {
            // 終了
            Close();
        }

        /// <summary>
        /// <para>method outline</para>
        /// <para>Formが閉じた後に発生するイベント</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>FormClosedEvent(sender, e)</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void DIConfEditorForm_FormClosed(object sender, FormClosedEventArgs e)
        {
            //HySEnvInf.Terminate();
        }
    }
}
