// <summary>ソースコード：文字列処理クラス</summary>
// <author>McModelWizard</author>
using System;
using System.Collections.Generic;
using System.Text;

namespace CommonMP.HYSSOP.OptionImpl.HSMenuEditor
{
    /// <summary><para>class outline:</para>
    /// <para>文字列処理クラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[McModelWizard][ver 1.0.0][2009/12/02][新規作成]</para>
    /// </remarks>
    /// <remarks><para>remarks:</para>
    /// <para>無し</para>
    /// </remarks>
    public class HSInputStr
    {
        /// <summary>
        /// <para>method outline:</para>
        /// <para>使用できない文字チェック</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>bool bRtn = InputWordCheck(string sStr)</para>
        /// </example>
        /// <param name="sStr">チェックする文字列</param>
        /// <returns>false:使用できない文字を含む true:使用できない文字を含まない</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>指定された文字列から使用できない文字(半角英数字_.-以外)を検索し結果を返す。</para>
        /// </remarks>
        public static bool InputWordCheck(string sStr)
        {
            string sChkStr = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ_.-";
            if (sStr.Length > 0)
            {
                // 半角英数字_.-以外不可
                if (CheckInputKind(sStr, sChkStr, false))
                {
                    return false;
                }
            }
            return true;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>使用できない文字チェック</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>bool bRtn = InputMenuTextCheck(string sStr)</para>
        /// </example>
        /// <param name="sStr">チェックする文字列</param>
        /// <returns>false:使用できない文字を含む true:使用できない文字を含まない</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>指定された文字列から使用できない文字以外を検索し結果を返す。</para>
        /// </remarks>
        public static bool InputMenuTextCheck(string sStr)
        {
            string sChkStr = "(&).-_ ";
            if (sStr.Length > 0)
            {
                // (&) 以外不可
                if (CheckInputKind(sStr, sChkStr, false))
                {
                    return false;
                }
            }
            return true;
        }
        /// <summary>
        /// <para>method outline:</para>
        /// <para>使用できない文字チェック</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>bool bRtn = InputWordCheck_Num(string sStr)</para>
        /// </example>
        /// <param name="sStr">チェックする文字列</param>
        /// <returns>false:使用できない文字を含む true:使用できない文字を含まない</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>指定された文字列から使用できない文字(数字.〔ピリオド〕以外)を検索し結果を返す。</para>
        /// <para>ただし.〔ピリオド〕が先頭または末尾は不可。</para>
        /// </remarks>
        public static bool InputWordCheck_Num(string sStr)
        {
            // 数値 .(ピリオド） 以外不可
            string sChkStr = "1234567890.";
            if (sStr.Length > 0)
            {
                if (CheckInputKind(sStr, sChkStr, false))
                {
                    return false;
                }
                // 先頭.(ピリオド）不可
                string sStartStr = sStr.Substring(0, 1);
                if (CheckInputKind(sStartStr, ".", true))
                {
                    return false;
                }                
                // 末尾.(ピリオド）不可
                sStartStr = sStr.Substring(sStr.Length-1);
                if (CheckInputKind(sStartStr, ".", true))
                {
                    return false;
                }
            }
            return true;
        }
        /// <summary>
        /// <para>method outline:</para>
        /// <para>使用できない文字チェック</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>bool bRtn = InputWordCheck_Number(string sStr)</para>
        /// </example>
        /// <param name="sStr">チェックする文字列</param>
        /// <returns>false:使用できない文字を含む true:使用できない文字を含まない</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>指定された文字列から使用できない文字(数字-〔マイナス〕以外)を検索し結果を返す。</para>
        /// <para>ただし-〔マイナス〕が先頭先頭以外不可。</para>
        /// </remarks>
        public static bool InputWordCheck_Number(string sStr)
        {
            // 数値 -(マイナス） 以外不可
            string sChkStr = "1234567890-";
            if (sStr.Length > 0)
            {
                if (CheckInputKind(sStr, sChkStr, false))
                {
                    return false;
                }

                string　sStartStr = "-";
                if (CheckInputKind(sStr, sStartStr, true))
                {
                    // 先頭-(マイナス）以外不可
                    if (sStr.IndexOf(sStartStr) != 0)
                    {
                        return false;
                    }
                    else if (sStr.IndexOf(sStartStr, 1) > 0)
                    {
                        return false;
                    }
                }
            }
            return true;
        }
        /// <summary>
        /// <para>method outline:</para>
        /// <para>使用できない文字チェック</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>bool bRtn = InputWordCheck_Name(string sStr)</para>
        /// </example>
        /// <param name="sStr">チェックする文字列</param>
        /// <returns>false:使用できない文字を含む true:使用できない文字を含まない</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>指定された文字列から使用できない文字(全角文字と半角カナ英数字以外)を検索し結果を返す。</para>
        /// </remarks>
        public static bool InputWordCheck_Name(string sStr)
        {
            if (sStr.Length > 0)
            {
                Encoding csEnc = Encoding.GetEncoding(HSMenuEditorDefine.FILE_ENCODE_JIS);
                for (int i = 0; i < sStr.Length; i++)
                {
                    string sBuf = sStr.Substring(i, 1);
                    int iLen = csEnc.GetByteCount(sBuf);
                    if (iLen == sBuf.Length * 2)
                    {
                        // 全角はALLOK
                    }
                    else
                    {
                        // 半角文字数字以外
                        if (!Char.IsLetter(sBuf, 0) &&
                            !Char.IsNumber(sBuf, 0))
                        {
                            if (!InputMenuTextCheck(sBuf))
                            {
                                return false;
                            }
                        }

                    }
                }
            }
            return true;
        }
        /// <summary>
        /// <para>method outline:</para>
        /// <para>文字種別チェック処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>bool bRtn = CheckInputKind(string sText, string sChkStr, bool bFlg)</para>
        /// </example>
        /// <param name="sText">チェック対象文字</param>
        /// <param name="sChkStr">含まれているかチェックしたい文字</param>
        /// <param name="bFlg">true:チェックしたい文字が含まれているか  false:チェックしたい文字以外が含まれているか</param>
        /// <returns>true：含む false: 含まない</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public static bool CheckInputKind(string sText, string sChkStr, bool bFlg)
        {
            bool bRtn = false;
            if (bFlg)
            {
                // チェックしたい文字が含まれているか
                bRtn = (sText.IndexOfAny(sChkStr.ToCharArray()) >= 0);
            }
            else
            {
                // チェックしたい文字以外が含まれているか
                char[] cBuff = sText.ToCharArray();
                char[] cErrChar = sChkStr.ToCharArray();
                for (int i = 0; i < cBuff.Length; i++)
                {
                    bool bChkFlg = false;
                    for (int y = 0; y < cErrChar.Length; y++)
                    {
                        if (cBuff[i] == cErrChar[y])
                        {
                            bChkFlg = true;
                            break;
                        }
                    }
                    if (!bChkFlg)
                    {
                        bRtn = true;
                    }
                }
            }

            return bRtn;
        }
    }
}
