﻿using System;
using System.Collections;
using System.Collections.Generic;
using System.Text;
using CommonMP.HYSSOP.Interface;
using CommonMP.HYSSOP.CoreImpl.HSTools;
using CommonMP.HYSSOP.CoreImpl.HSData;

using CommonMP.HYSSOP.OptionImpl.HSViewer.DotNetViewer;


namespace CommonMP.HYSSOP.OptionImpl.HSMenuEditor
{
    /// <summary><para>class outline:</para>
    /// <para>メニューアイテム管理クラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.2.0][2011/10/25][新規作成]</para>
    /// </remarks>
    public class HSMenuEditorCtl : HySViewerMenuCtl
    {
        # region 不要メソッド　後で消す
        ///// <summary>
        ///// <para>method outline:</para>
        ///// <para>指定階層メニュー項目の最大レベル数取得</para>
        ///// </summary>
        ///// <example>
        ///// <para>usage:</para>
        ///// <para>GetMainMenuItemLeve(lIndex)</para>
        ///// </example>
        ///// <param name="lIndex">メインメニュー項目インデックス</param>
        ///// <returns>long: 各メインメニュー項目で存在するレベル数</returns>
        ///// <exception cref="">無し</exception>
        ///// <remarks><para>remarks:</para>
        ///// <para>無し</para>
        ///// </remarks>
        //public bool GetMenuItemLeve(long lIndex, long lLevel, Hashtable csTbl)
        //{
        //    bool bRtn = false;
        //    ArrayList csList = (ArrayList)m_csMenuList[lLevel][(int)csTbl[0]];
        //    if (lLevel == 1)
        //    {
        //        return true;
        //    }
        //    bRtn = QueryMenuItem(csList, null, (int)lLevel, (int)lIndex, csTbl, 0);
        //    return bRtn;
        //}

        ///// <summary>
        ///// <para>method outline:</para>
        ///// <para>各メインメニュー項目の指定階層におけるサブメニュー項目一覧取得</para>
        ///// </summary>
        ///// <example>
        ///// <para>usage:</para>
        ///// <para>GetMenuItemList(lIndex, lLevel)</para>
        ///// </example>
        ///// <param name="lIndex">メインメニュー項目インデックス</param>
        ///// <param name="lLevel">取得する項目の階層(1～：レベル2以降の階層対象)</param>
        ///// <returns>ArrayList: 指定メインメニュー項目の指定階層におけるサブメニュー項目一覧</returns>
        ///// <exception cref="">無し</exception>
        ///// <remarks><para>remarks:</para>
        ///// <para>無し</para>
        ///// </remarks>
        //public ArrayList GetMenuItemList(long lIndex, long lLevel)
        //{
        //    ArrayList bRtn = null;
        //    ArrayList csList = (ArrayList)m_csMenuList[lLevel][(int)lIndex];
        //    bRtn = QueryMenuItemList(csList, null);
        //    return bRtn;
        //}
        # endregion

        /// <summary>
        /// <para>method outline:</para>
        /// <para>各メインメニュー項目の指定階層におけるサブメニュー項目一覧取得</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>GetMenuItemList(lIndex, lLevel, csTbl)</para>
        /// </example>
        /// <param name="lIndex">メインメニュー項目インデックス</param>
        /// <param name="lLevel">取得する項目の階層(1～：レベル2以降の階層対象)</param>
        /// <param name="csTbl">対象メニュー格納位置</param>
        /// <returns>ArrayList: 指定メインメニュー項目の指定階層におけるサブメニュー項目一覧</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public ArrayList GetMenuItemList(long lIndex, long lLevel, Hashtable csTbl)
        {
            ArrayList bRtn = null;
            ArrayList csList = (ArrayList)m_csMenuList[lLevel][(int)csTbl[0]];
            if (lLevel == 1)
            {
                return csList;
            }
            bRtn = QueryMenuItemList(csList, null, (int)lLevel, (int)lIndex, csTbl, 0);
            return bRtn;
        }

        # region 不要メソッド　後で消す
        ///// <summary>
        ///// <para>method outline:</para>
        ///// <para>メニューアイテムの存在検索</para>
        ///// </summary>
        ///// <example>
        ///// <para>usage:</para>
        ///// <para>QueryMenuItem(csArrayList)</para>
        ///// </example>
        ///// <param name="csArrayList">メインメニューのリスト</param>
        ///// <returns>bool: true:存在する　false:存在しない</returns>
        ///// <exception cref="">無し</exception>
        ///// <remarks><para>remarks:</para>
        ///// <para>無し</para>
        ///// </remarks>
        //public bool QueryMenuItem(ArrayList csArrayList)
        //{
        //    bool bRtn = false;
        //    bool bSubRtn = false;
        //    int icount = csArrayList.Count;
        //    for (int iLp = 0; iLp < icount; iLp++)
        //    {
        //        if (csArrayList[iLp] as ArrayList != null)
        //        {
        //            bSubRtn = this.QueryMenuItem((ArrayList)csArrayList[iLp]);
        //            if (bSubRtn == true)
        //            {
        //                bRtn = true;
        //                break;
        //            }
        //        }
        //        else
        //        {
        //            HySViewerMenuItem csMenuItem = (HySViewerMenuItem)csArrayList[iLp];
        //            if (csMenuItem != null)
        //            {
        //                bRtn = true;
        //                break;
        //            }
        //        }
        //    }
        //    return bRtn;
        //}

        ///// <summary>
        ///// <para>method outline:</para>
        ///// <para>メニューアイテムの存在検索</para>
        ///// </summary>
        ///// <example>
        ///// <para>usage:</para>
        ///// <para>QueryMenuItem(csArrayList)</para>
        ///// </example>
        ///// <param name="csArrayList">メインメニューのリスト</param>
        ///// <returns>bool: true:存在する　false:存在しない</returns>
        ///// <exception cref="">無し</exception>
        ///// <remarks><para>remarks:</para>
        ///// <para>無し</para>
        ///// </remarks>
        //public bool QueryMenuItem(ArrayList csArrayList, ArrayList csReflexiveList, int iLevel, int iIndex, Hashtable csTbl, int icount)
        //{
        //    bool bRtn = false;
        //    bool bSubRtn = false;
        //    ArrayList bList = null;
        //    int iLevelCount = 0;
        //    if (csReflexiveList == null)
        //    {
        //        bList = new ArrayList();
        //    }
        //    else
        //    {
        //        bList = csReflexiveList;
        //    }
        //    if (icount == 0)
        //    {
        //        iLevelCount = 1;
        //    }
        //    else
        //    {
        //        icount++;
        //        iLevelCount += icount;
        //    }
        //    if (iLevelCount != iLevel)
        //    {
        //        if (((ArrayList)csArrayList[(int)csTbl[iLevelCount]]).Count == 0)
        //        {
        //            return false;
        //        }
        //        else
        //        {
        //            bSubRtn = this.QueryMenuItem((ArrayList)csArrayList[(int)csTbl[iLevelCount]], bList, iLevel, iIndex, csTbl, iLevelCount);
        //            bRtn = bSubRtn;
        //        }
        //    }
        //    else
        //    {
        //        return true;
        //    }

        //    return bRtn;
        //}
        # endregion

        # region 不要メソッド　後で消す
        ///// <summary>
        ///// <para>method outline:</para>
        ///// <para>サブメニュー項目一覧検索</para>
        ///// </summary>
        ///// <example>
        ///// <para>usage:</para>
        ///// <para>QueryMenuItemList(csArrayList)</para>
        ///// </example>
        ///// <param name="csArrayList">指定メインメニュー項目における指定階層のメニューリスト</param>
        ///// <returns>ArrayList: 指定メインメニュー項目の指定階層におけるサブメニュー項目一覧</returns>
        ///// <exception cref="">無し</exception>
        ///// <remarks><para>remarks:</para>
        ///// <para>無し</para>
        ///// </remarks>
        //public ArrayList QueryMenuItemList(ArrayList csArrayList, ArrayList csReflexiveList)
        //{
        //    ArrayList bRtn = null;
        //    ArrayList bSubRtn = null;
        //    if (csReflexiveList == null)
        //    {
        //        bRtn = new ArrayList();
        //    }
        //    else
        //    {
        //        bRtn = csReflexiveList;
        //    }
        //    int icount = csArrayList.Count;
        //    for (int iLp = 0; iLp < icount; iLp++)
        //    {
        //        if (csArrayList[iLp] as ArrayList != null)
        //        {
        //            bSubRtn = this.QueryMenuItemList((ArrayList)csArrayList[iLp], bRtn);
        //            bRtn = bSubRtn;
        //        }
        //        else
        //        {
        //            HySViewerMenuItem csMenuItem = (HySViewerMenuItem)csArrayList[iLp];
        //            if (csMenuItem != null)
        //            {
        //                bRtn.Add(csMenuItem);
        //            }
        //        }
        //    }
        //    return bRtn;
        //}
        #endregion

        /// <summary>
        /// <para>method outline:</para>
        /// <para>サブメニュー項目一覧検索</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>QueryMenuItemList(csArrayList,csReflexiveList,iLevel,iIndex,csTbl,icount)</para>
        /// </example>
        /// <param name="csArrayList">指定メインメニュー項目における指定階層のメニューリスト</param>
        /// <param name="csReflexiveList">指定メインメニュー項目における指定階層のメニューリスト</param>
        /// <param name="iLevel">取得する項目の階層</param>
        /// <param name="iIndex">指定メインメニュー項目インデックス</param>
        /// <param name="csTbl">対象メニュー格納位置</param>
        /// <param name="icount">処理中レベル</param>
        /// <returns>ArrayList: 指定メインメニュー項目の指定階層におけるサブメニュー項目一覧</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public ArrayList QueryMenuItemList(ArrayList csArrayList, ArrayList csReflexiveList, int iLevel, int iIndex, Hashtable csTbl, int icount)
        {
            ArrayList bRtn = null;
            ArrayList bSubRtn = null;
            int iLevelCount = 0;
            if (csReflexiveList == null)
            {
                bRtn = new ArrayList();
            }
            else
            {
                bRtn = csReflexiveList;
            }
            if (icount == 0)
            {
                iLevelCount = 1;
            }
            else
            {
                icount++;
                iLevelCount += icount;
            }
            if (iLevelCount != iLevel)
            {
                bSubRtn = this.QueryMenuItemList((ArrayList)csArrayList[(int)csTbl[iLevelCount]], bRtn, iLevel, iIndex, csTbl, iLevelCount);
                bRtn = bSubRtn;
            }
            else
            {
                return csArrayList;
            }
            return bRtn;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>メインメニューの項目を追加する</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>AddMainMenu(lIndex, csManuItem)</para>
        /// </example>
        /// <param name="iIndex">メインメニュー項目追加位置インデックス</param>
        /// <param name="csManuItem">メニュー情報</param>
        /// <returns>0: 処理成功　-1:異常発生</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public long AddMainMenu(int iIndex, HySViewerMenuItem csManuItem)
        {
            long lRtn = 0;
            try
            {
                // 未指定・メニュー無しの場合、１件目に追加
                if (iIndex == -1)
                {
                    iIndex = 0;
                }
                // レベル１メニュー情報追加
                m_csMenuList[0].Insert(iIndex, csManuItem);
                for (int iLoop = 1; iLoop < m_lMenuLevelCount; iLoop++)
                {// レベル２以降リスト作成
                    ArrayList csArrayList = (ArrayList)m_csMenuList[iLoop];
                    csArrayList.Insert(iIndex, new ArrayList());
                }
            }
            catch
            {
                lRtn = -1;
            }

            return lRtn;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>サブメニューの項目を追加する</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>AddSubMenu(iLevel, iIndex, csTbl, csManuItem)</para>
        /// </example>
        /// <param name="iLevel">追加するメニューレベル</param>
        /// <param name="iIndex">メニュー項目追加位置インデックス</param>
        /// <param name="csTbl">対象メニュー格納位置</param>
        /// <param name="csManuItem">メニュー情報</param>
        /// <returns>0: 処理成功　-1:異常発生</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public long AddSubMenu(int iLevel, int iIndex, Hashtable csTbl, HySViewerMenuItem csManuItem)
        {
            long lRtn = 0;
            try
            {
                //　レベル数追加
                //if (iLevel >= m_lMenuLevelCount)
                //{
                //    m_lMenuLevelCount = iLevel + 1;
                //}

                for (int iLoop = iLevel; iLoop < m_lMenuLevelCount; iLoop++)
                {
                    // レベル情報取出し
                    ArrayList csArrayList = (ArrayList)m_csMenuList[iLoop];

                    if (csArrayList == null)
                    {// レベル１のリストが作成されていない場合は作成
                        csArrayList = new ArrayList();
                        for (int iMCnt = 0; iMCnt < m_csMenuList[0].Count; iMCnt++)
                        {
                            csArrayList.Add(new ArrayList());
                        }
                    }

                    // 未指定・メニュー無しの場合、１件目に追加
                    if (iIndex == -1)
                    {
                        iIndex = 0;
                    }

                    // 下位メニュー情報編集
                    int iSubCnt = 1;
                    lRtn = AddSubMenuDown(iLevel, iIndex, csTbl, (ArrayList)csArrayList[(int)csTbl[0]], csManuItem, iLoop, iSubCnt);

                }
            }
            catch
            {
                lRtn = -1;
            }

            return lRtn;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>サブメニューの項目を追加する</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>AddSubMenuDown(iLevel, iIndex, csTbl, csArrayList, csManuItem, iLoop, iSubCnt)</para>
        /// </example>
        /// <param name="iLevel">追加するメニューレベル</param>
        /// <param name="iIndex">メニュー項目追加位置インデックス</param>
        /// <param name="csTbl">対象メニュー格納位置</param>
        /// <param name="csArrayList">下位メニュー情報</param>
        /// <param name="csManuItem">メニュー情報</param>
        /// <param name="iLoop">処理中レベル</param>
        /// <param name="iSubCnt">処理中階層</param>
        /// <returns>0: 処理成功　-1:異常発生</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public long AddSubMenuDown(int iLevel, int iIndex, Hashtable csTbl, ArrayList csArrayList, HySViewerMenuItem csManuItem, int iLoop, int iSubCnt)
        {
            long lRtn = 0;

            try
            {
                // メニュー情報を追加
                if (iLevel == iLoop && iLevel == iSubCnt)
                {
                    if (csArrayList.Count >= iIndex)
                    {
                        csArrayList.Insert(iIndex, csManuItem);
                    }
                }
                else
                {
                    if (iLevel == iSubCnt)
                    {// リストを追加
                        if (csArrayList.Count >= iIndex)
                        {
                            csArrayList.Insert(iIndex, new ArrayList());
                        }
                    }
                    else
                    {// 下位メニューの編集
                        ArrayList csArrayListSub = (ArrayList)csArrayList[(int)csTbl[iSubCnt]];
                        if (csArrayListSub != null)
                        {
                            iSubCnt++;
                            if (iSubCnt <= iLoop)
                            {
                                lRtn = AddSubMenuDown(iLevel, iIndex, csTbl, csArrayListSub, csManuItem, iLoop, iSubCnt);
                            }
                        }
                    }

                }
            }
            catch
            {
                lRtn = -1;
            }
            return lRtn;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>メインメニューの項目を削除する</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>DeleteMainMenu(iIndex)</para>
        /// </example>
        /// <param name="iIndex">メニュー項目削除位置インデックス</param>
        /// <returns>0: 処理成功　-1:異常発生</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public long DeleteMainMenu(int iIndex)
        {
            long lRtn = 0;
            try
            {
                // 未選択の場合、処理無し
                if (iIndex == -1)
                {
                    return lRtn;
                }

                // リストを削除
                for (int iLoop = 0; iLoop < m_lMenuLevelCount; iLoop++)
                {
                    m_csMenuList[iLoop].RemoveAt(iIndex);
                }
            }
            catch
            {
                lRtn = -1;
            }

            return lRtn;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>メインメニューの項目を削除する</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>DeleteSubMenu(iLevel, iIndex, csTbl)</para>
        /// </example>
        /// <param name="iLevel">メニュー項目削除レベル</param>
        /// <param name="iIndex">メニュー項目削除位置インデックス</param>
        /// <param name="csTbl">対象メニュー格納位置</param>
        /// <returns>0: 処理成功　-1:異常発生</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public long DeleteSubMenu(int iLevel, int iIndex, Hashtable csTbl)
        {
            long lRtn = 0;
            try
            {
                // 未選択の場合、処理無し
                if (iIndex == -1)
                {
                    return lRtn;
                }

                // レベル２以降編集
                for (int iLoop = iLevel; iLoop < m_lMenuLevelCount; iLoop++)
                {
                    ArrayList csArrayList = (ArrayList)m_csMenuList[iLoop];
                    if (csArrayList == null)
                    {
                        continue;
                    }

                    int iSubCnt = 1;
                    lRtn = DeleteSubMenuDown(iLevel, iIndex, csTbl, (ArrayList)csArrayList[(int)csTbl[0]], iLoop, iSubCnt);

                }
            }
            catch
            {
                lRtn = -1;
            }

            return lRtn;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>サブメニューの項目を削除する</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>DeleteSubMenuDown(iLevel, iIndex, csTbl, csArrayList, iLoop, iSubCnt)</para>
        /// </example>
        /// <param name="iLevel">削除するメニューレベル</param>
        /// <param name="iIndex">メニュー項目削除位置インデックス</param>
        /// <param name="csTbl">対象メニュー格納位置</param>
        /// <param name="csArrayList">下位メニュー情報</param>
        /// <param name="iLoop">処理中レベル</param>
        /// <param name="iSubCnt">処理中階層</param>
        /// <returns>0: 処理成功　-1:異常発生</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public long DeleteSubMenuDown(int iLevel, int iIndex, Hashtable csTbl, ArrayList csArrayList, int iLoop, int iSubCnt)
        {
            long lRtn = 0;

            try
            {
                if (iLevel == iLoop && iLevel == iSubCnt)
                {// メニュー情報を削除
                    if (csArrayList.Count >= iIndex)
                    {   // 位置がメニュー数以内
                        csArrayList.RemoveAt(iIndex);
                    }
                }
                else
                {   // 指定以外
                    if (iLevel == iSubCnt)
                    {// リストを削除
                        if (csArrayList.Count >= iIndex)
                        {   // 位置がメニュー数以内
                            csArrayList.RemoveAt(iIndex);
                        }
                    }
                    else
                    {// 下位メニュー編集
                        ArrayList csArrayListSub = (ArrayList)csArrayList[(int)csTbl[iSubCnt]];
                        if (csArrayListSub != null)
                        {   // メニュー有り
                            iSubCnt++;
                            if (iSubCnt <= iLoop)
                            {   // 処理中レベル以内
                                lRtn = DeleteSubMenuDown(iLevel, iIndex, csTbl, csArrayListSub, iLoop, iSubCnt);
                            }
                        }
                    }

                }
            }
            catch
            {   // 異常処理
                lRtn = -1;
            }
            return lRtn;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>メインメニューの項目を移動する</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>MoveMainMenu(iIndex, bMode)</para>
        /// </example>
        /// <param name="iIndex">メニュー項目移動位置インデックス</param>
        /// <param name="bMode">上下移動先 [true:上部へ移動 false:下部へ移動</param>
        /// <returns>0: 処理成功　-1:異常発生</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public long MoveMainMenu(int iIndex, bool bMode)
        {
            long lRtn = 0;
            try
            {
                // 未選択の場合、処理無し
                if (iIndex == -1)
                {   // 未選択
                    return lRtn;
                }

                int iIns;
                if (bMode)
                {// 上移動　移動先インデックス番号算出
                    iIns = iIndex - 1;
                }
                else
                {// 下移動　移動先インデックス番号算出
                    iIns = iIndex + 1;
                }

                HySViewerMenuItem csMenuItem = (HySViewerMenuItem)m_csMenuList[0][iIndex];
                m_csMenuList[0].RemoveAt(iIndex);
                m_csMenuList[0].Insert(iIns, csMenuItem);
                for (int iLoop = 1; iLoop < m_lMenuLevelCount; iLoop++)
                {   // メニュー数分
                    ArrayList csArrayList = (ArrayList)m_csMenuList[iLoop];
                    ArrayList csSecArrayList = (ArrayList)csArrayList[iIndex];
                    csArrayList.RemoveAt(iIndex);
                    csArrayList.Insert(iIns, csSecArrayList);
                }
            }
            catch
            {   // 異常処理
                lRtn = -1;
            }

            return lRtn;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>メインメニューの項目を削除する</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>DeleteSubMenu(iLevel, iIndex, csTbl, bMode)</para>
        /// </example>
        /// <param name="iLevel">メニュー項目削除レベル</param>
        /// <param name="iIndex">メニュー項目削除位置インデックス</param>
        /// <param name="csTbl">対象メニュー格納位置</param>
        /// <param name="bMode">上下移動先 [true:上部へ移動 false:下部へ移動</param>
        /// <returns>0: 処理成功　-1:異常発生</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public long MoveSubMenu(int iLevel, int iIndex, Hashtable csTbl, bool bMode)
        {
            long lRtn = 0;
            try
            {
                // 未選択の場合、処理無し
                if (iIndex == -1)
                {   // 未選択
                    return lRtn;
                }

                // レベル２以降編集
                for (int iLoop = iLevel; iLoop < m_lMenuLevelCount; iLoop++)
                {   // メニュー数分
                    ArrayList csArrayList = (ArrayList)m_csMenuList[iLoop];
                    if (csArrayList == null)
                    {   // リスト無し
                        continue;
                    }

                    int iSubCnt = 1;
                    lRtn = MoveSubMenuDown(iLevel, iIndex, csTbl, (ArrayList)csArrayList[(int)csTbl[0]], iLoop, iSubCnt, bMode);

                }
            }
            catch
            {   // 異常処理
                lRtn = -1;
            }

            return lRtn;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>サブメニューの項目を削除する</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>DeleteSubMenuDown(iLevel, iIndex, csTbl, csArrayList, iLoop, iSubCnt, bMode)</para>
        /// </example>
        /// <param name="iLevel">削除するメニューレベル</param>
        /// <param name="iIndex">メニュー項目削除位置インデックス</param>
        /// <param name="csTbl">対象メニュー格納位置</param>
        /// <param name="csArrayList">下位メニュー情報</param>
        /// <param name="iLoop">処理中レベル</param>
        /// <param name="iSubCnt">処理中階層</param>
        /// <param name="bMode">上下移動先 [true:上部へ移動 false:下部へ移動</param>
        /// <returns>0: 処理成功　-1:異常発生</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public long MoveSubMenuDown(int iLevel, int iIndex, Hashtable csTbl, ArrayList csArrayList, int iLoop, int iSubCnt, bool bMode)
        {
            long lRtn = 0;

            try
            {
                int iIns;
                if (bMode)
                {// 上移動　移動先インデックス番号算出
                    iIns = iIndex - 1;
                }
                else
                {// 下移動　移動先インデックス番号算出
                    iIns = iIndex + 1;
                }

                if (iLevel == iLoop && iLevel == iSubCnt)
                {// メニュー情報を移動
                    if (csArrayList.Count >= iIns)
                    {   // 位置がメニュー数以内
                        HySViewerMenuItem csMenuItem = (HySViewerMenuItem)csArrayList[iIndex];
                        csArrayList.RemoveAt(iIndex);
                        csArrayList.Insert(iIns, csMenuItem);
                    }
                }
                else
                {   // 対象外
                    if (iLevel == iSubCnt)
                    {// リストを移動
                        if (csArrayList.Count >= iIns)
                        {   // 位置がメニュー数以内
                            ArrayList csSecArrayList = (ArrayList)csArrayList[iIndex];
                            csArrayList.RemoveAt(iIndex);
                            csArrayList.Insert(iIns, csSecArrayList);
                        }
                    }
                    else
                    {// 下位メニュー編集
                        ArrayList csArrayListSub = (ArrayList)csArrayList[(int)csTbl[iSubCnt]];
                        if (csArrayListSub != null)
                        {   // リスト有り
                            iSubCnt++;
                            if (iSubCnt <= iLoop)
                            {   // 処理中レベル以内
                                lRtn = MoveSubMenuDown(iLevel, iIndex, csTbl, csArrayListSub, iLoop, iSubCnt, bMode);
                            }
                        }
                    }

                }
            }
            catch
            {   // 異常処理
                lRtn = -1;
            }

            return lRtn;
        }
    }
}
