﻿using System;
using System.Collections;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using CommonMP.HYSSOP.CoreImpl.HSTools;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.OptionImpl.HSViewer.DotNetViewer;

namespace CommonMP.HYSSOP.OptionImpl.HSMenuEditor
{
    /// <summary><para>class outline:</para>
    /// <para>メニュー編集エディター画面</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.2.0][2011/10/25][新規作成]</para>
    /// </remarks>
    public partial class HSMenuEditorForm : Form
    {
        /// <summary>メニューアイテム管理クラス</summary>
        private HSMenuEditorCtl m_csEditorCtl;
        /// <summary>メニュー項目追加・編集画面</summary>
        private HSMenuItemEditForm m_csEditForm;
        /// <summary>環境情報管理クラス</summary>
        private HySEnvInf m_csEnvInf;

        /// <summary>現在のコンボ選択Index</summary>
        private int m_csSelectNo = 0;

        /// <summary>Index履歴管理（Key:階層、Val:Index）</summary>
        private Hashtable m_csIndexMngTbl = null;

        /// <summary>メニュー定義ファイル名称</summary>
        private HySString m_csXmlFileName = null;

        /// <summary>メニュー定義バックアップファイル名称</summary>
        private HySString m_csBackUpXmlFileName = null;

        /// <summary>
        /// <para>method outline:</para>
        /// <para>デフォルトコンストラクタ</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>new HSMenuEditorForm( )</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HSMenuEditorForm()
        {
            InitializeComponent();

            toolTip1.SetToolTip(SetButton, Properties.HSMenuMsgResource.TOOLTIP_MSG_MENUOUT);
            toolTip1.SetToolTip(checkedMenuItemList, Properties.HSMenuMsgResource.TOOLTIP_MSG_LIST);
            toolTip1.SetToolTip(PreDataLoadbutton, Properties.HSMenuMsgResource.TOOLTIP_MSG_PREDATA);
            m_csEnvInf = new HySEnvInf(new HySString("CommonMP.cfg"));
            //m_csEnvInf.Initialize();
            m_csEnvInf.InitializeNoLog();

            m_csEditForm = new HSMenuItemEditForm();
            m_csEditorCtl = new HSMenuEditorCtl();
            m_csIndexMngTbl = new Hashtable();
            this.Initialize();
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>初期化処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>Initialize( )</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        protected void Initialize()
        {
            //m_csEnvInf = new HySEnvInf(new HySString("CommonMP.cfg"));
            //m_csEnvInf.Initialize();
            //// メニュー情報の生成
            //m_csEditorCtl.CheckMenu();
            //m_csEditorCtl.GenerateMenu();
            //// 項目一覧の初期表示
            //this.ShowMenuItemList();
            MenuLevelSelectBox.Enabled = false;
            AddMenuItemButton.Enabled = false;
            EditMenuItemButton.Enabled = false;
            DelMenuItemButton.Enabled = false;
            MoveUpMenuItemButton.Enabled = false;
            MoveDownMenuItemButton.Enabled = false;
            PreDataLoadbutton.Enabled = false;
            SetButton.Enabled = false;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>メインメニュー項目の一覧表示</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>ShowMenuItemList( )</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        protected void ShowMenuItemList()
        {
            bool bState = true;
            long lCount = m_csEditorCtl.GetMainMenuCount();
            // リストのクリア
            if (this.checkedMenuItemList.Items.Count != 0)
            {   // リスト有り
                this.checkedMenuItemList.Items.Clear();
            }
            for (long lLp = 0; lLp < lCount; lLp++)
            {
                HySViewerMenuItem csMenuItem = m_csEditorCtl.GetMainMenuItem(lLp);
                if (((object)csMenuItem.GetMenuText()) != null)
                {   // メニューテキスト有効
                    bState = csMenuItem.GetMenuDisp();
                    this.checkedMenuItemList.Items.Add(csMenuItem.GetMenuText().ToString(), bState);
                }
            }
            // 項目の上位を選択済みにする
            if (this.checkedMenuItemList.Items.Count > 0)
            {   // 編集項目有り
                this.checkedMenuItemList.SelectedIndex = 0;
                MenuLevelSelectBox.Enabled = true;
                AddMenuItemButton.Enabled = true;
                EditMenuItemButton.Enabled = true;
                DelMenuItemButton.Enabled = true;
                MoveUpMenuItemButton.Enabled = true;
                MoveDownMenuItemButton.Enabled = true;
                PreDataLoadbutton.Enabled = true;
                SetButton.Enabled = true;
            }
            else
            {   // 編集項目無し
                // リストのクリア
                if (this.MenuLevelSelectBox.Items.Count != 0)
                {   // 表示アイテム有り
                    this.MenuLevelSelectBox.Items.Clear();
                }
                this.MenuLevelSelectBox.Items.Add(Properties.HSMenuMsgResource.MAINMENU);
                this.MenuLevelSelectBox.SelectedIndex = 0;
            }
        }

        /// <summary>
        /// <para>method outline</para>
        /// <para>「新しいメニュー追加」ボタンが押された時に発生するイベント</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>AddMenuItemButton_Click(sender, e)</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void AddMenuItemButton_Click(object sender, EventArgs e)
        {

            HySViewerMenuItem csMenuItem = new HySViewerMenuItem();
            m_csEditForm.m_csMenuItem = csMenuItem;

            m_csEditForm.ShowDialog(this);
            if (m_csEditForm.IsButtonOK() == true)
            {
                int iIndex = checkedMenuItemList.SelectedIndex;

                csMenuItem = m_csEditForm.m_csMenuItem;
                csMenuItem.SetUserEdit(true);

                if (m_csSelectNo == 0)
                {
                    if (iIndex == -1)
                    {
                        iIndex = 0;
                    }
                    m_csEditorCtl.AddMainMenu(iIndex, csMenuItem);
                    checkedMenuItemList.Items.Insert(iIndex, csMenuItem.GetMenuText().ToString());
                    checkedMenuItemList.SetItemChecked(iIndex, csMenuItem.GetMenuDisp());
                }
                else
                {
                    m_csEditorCtl.AddSubMenu(m_csSelectNo, iIndex, m_csIndexMngTbl, csMenuItem);
                    if (iIndex >= 0)
                    {
                        checkedMenuItemList.Items.Insert(iIndex, csMenuItem.GetMenuText().ToString());
                        checkedMenuItemList.SetItemChecked(iIndex, csMenuItem.GetMenuDisp());
                    }
                    else
                    {
                        checkedMenuItemList.Items.Add(csMenuItem.GetMenuText().ToString(), csMenuItem.GetMenuDisp());
                    }
                }
                checkedMenuItemList.SelectedIndex = iIndex;
            }
        }

        /// <summary>
        /// <para>method outline</para>
        /// <para>「メニュー編集」ボタンが押された時に発生するイベント</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>EditMenuItemButton_Click(sender, e)</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void EditMenuItemButton_Click(object sender, EventArgs e)
        {
            int iIndex = checkedMenuItemList.SelectedIndex;
            if( iIndex == -1)
            {// 未選択
                return;
            }

            HySViewerMenuItem csMenuItem = null;

            if (m_csSelectNo == 0)
            {
                csMenuItem = m_csEditorCtl.GetMainMenuItem(iIndex);
            }
            else
            {
                ArrayList csList = m_csEditorCtl.GetMenuItemList((long)this.checkedMenuItemList.SelectedIndex, (long)this.MenuLevelSelectBox.SelectedIndex, m_csIndexMngTbl);
                if (csList.Count >= iIndex)
                {
                    csMenuItem = (HySViewerMenuItem)csList[iIndex];
                }
            }

            if (csMenuItem == null)
            {// 編集情報無し
                return;
            }

            m_csEditForm.m_csMenuItem = csMenuItem;
            m_csEditForm.ShowDialog(this);
            if (m_csEditForm.IsButtonOK() == true)
            {
                csMenuItem = m_csEditForm.m_csMenuItem;
                checkedMenuItemList.Items[iIndex] = csMenuItem.GetMenuText().ToString();
            }
        }

        /// <summary>
        /// <para>method outline</para>
        /// <para>Formが閉じた後に発生するイベント</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>FormClosedEvent(sender, e)</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void FormClosedEvent(object sender, FormClosedEventArgs e)
        {
            //HySEnvInf.Terminate();
        }

        /// <summary>
        /// <para>method outline</para>
        /// <para>項目がドロップダウンリストから変更された時に発生するイベント</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>MenuLevelSelectBox_SelectionChangeCommitted(sender, e)</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void MenuLevelSelectBox_SelectionChangeCommitted(object sender, EventArgs e)
        {
            bool bState = true;
            m_csSelectNo = this.MenuLevelSelectBox.SelectedIndex;
            if (this.MenuLevelSelectBox.SelectedIndex != 0)
            {
                ArrayList csList = m_csEditorCtl.GetMenuItemList((long)this.checkedMenuItemList.SelectedIndex, (long)this.MenuLevelSelectBox.SelectedIndex, m_csIndexMngTbl);
                // リストのクリア
                if (this.checkedMenuItemList.Items.Count != 0)
                {
                    this.checkedMenuItemList.Items.Clear();
                }
                for (int iLp = 0; iLp < csList.Count; iLp++)
                {
                    HySViewerMenuItem csMenuItem = (HySViewerMenuItem)csList[iLp];
                    bState = csMenuItem.GetMenuDisp();
                    this.checkedMenuItemList.Items.Add(csMenuItem.GetMenuText().ToString(), bState);
                }
                if (checkedMenuItemList.Items.Count > 0)
                {
                    // 項目の上位を選択済みにする
                    this.checkedMenuItemList.SelectedIndex = 0;
                }
            }
            else
            {
                ShowMenuItemList();
            }
        }

        /// <summary>
        /// <para>method outline</para>
        /// <para>「削除」ボタンが押された時に発生するイベント</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>DelMenuItemButton_Click(sender, e)</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void DelMenuItemButton_Click(object sender, EventArgs e)
        {
            int iIndex = checkedMenuItemList.SelectedIndex;

            if (iIndex == -1)
            {
                return;
            }

            if (m_csSelectNo == 0)
            {
                m_csEditorCtl.DeleteMainMenu(iIndex);
            }
            else
            {
                m_csEditorCtl.DeleteSubMenu(m_csSelectNo, iIndex, m_csIndexMngTbl);
            }


            checkedMenuItemList.Items.RemoveAt(iIndex);
            if (checkedMenuItemList.Items.Count > iIndex)
            {
                checkedMenuItemList.SelectedIndex = iIndex;
            }
            else if (checkedMenuItemList.Items.Count > 0)
            {
                checkedMenuItemList.SelectedIndex = iIndex - 1;
            }

        }

        /// <summary>
        /// <para>method outline</para>
        /// <para>「上へ移動」ボタンが押された時に発生するイベント</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>MoveUpMenuItemButton_Click(sender, e)</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void MoveUpMenuItemButton_Click(object sender, EventArgs e)
        {
            int iIndex = checkedMenuItemList.SelectedIndex;

            if (iIndex == -1)
            {
                return;
            }

            if (iIndex > 0)
            {
                if (m_csSelectNo == 0)
                {
                    m_csEditorCtl.MoveMainMenu(iIndex, true);
                }
                else
                {
                    m_csEditorCtl.MoveSubMenu(m_csSelectNo, iIndex, m_csIndexMngTbl, true);
                }

                string stext = checkedMenuItemList.Items[iIndex].ToString();
                bool bCheked = checkedMenuItemList.GetItemChecked(iIndex);
                checkedMenuItemList.Items.RemoveAt(iIndex);
                checkedMenuItemList.Items.Insert(iIndex - 1, stext);
                checkedMenuItemList.SetItemChecked(iIndex - 1, bCheked);
                checkedMenuItemList.SelectedIndex = iIndex - 1;
            }
        }

        /// <summary>
        /// <para>method outline</para>
        /// <para>「下へ移動」ボタンが押された時に発生するイベント</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>MoveDownMenuItemButton_Click(sender, e)</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void MoveDownMenuItemButton_Click(object sender, EventArgs e)
        {
            int iIndex = checkedMenuItemList.SelectedIndex;

            if (iIndex == -1)
            {
                return;
            }

            if (iIndex < checkedMenuItemList.Items.Count - 1)
            {
                if (m_csSelectNo == 0)
                {
                    m_csEditorCtl.MoveMainMenu(iIndex, false);
                }
                else
                {
                    m_csEditorCtl.MoveSubMenu(m_csSelectNo, iIndex, m_csIndexMngTbl, false);
                }

                string stext = checkedMenuItemList.Items[iIndex].ToString();
                bool bCheked = checkedMenuItemList.GetItemChecked(iIndex);
                checkedMenuItemList.Items.RemoveAt(iIndex);
                checkedMenuItemList.Items.Insert(iIndex + 1, stext);
                checkedMenuItemList.SetItemChecked(iIndex + 1, bCheked);
                checkedMenuItemList.SelectedIndex = iIndex + 1;
            }
        }

        /// <summary>
        /// <para>method outline</para>
        /// <para>「書込み」ボタンが押された時に発生するイベント</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>SetButton_Click(sender, e)</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void SetButton_Click(object sender, EventArgs e)
        {
            long lRtn = m_csEditorCtl.SaveMenuDefine(m_csXmlFileName);
            if (lRtn == 0)
            {
                System.Windows.Forms.MessageBox.Show(this, Properties.HSMenuMsgResource.WRITE_COMPLETE, Properties.HSMenuMsgResource.MENU_CAPTION, MessageBoxButtons.OK, MessageBoxIcon.Information);
            }
            else
            {
                System.Windows.Forms.MessageBox.Show(this, Properties.HSMenuMsgResource.WRITE_ERROR, Properties.HSMenuMsgResource.MENU_CAPTION, MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
        }

        /// <summary>
        /// <para>method outline</para>
        /// <para>選択項目が変更された時に発生するイベント</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>checkedMenuItemList_SelectedIndexChangedEvent(sender, e)</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void checkedMenuItemList_SelectedIndexChanged(object sender, EventArgs e)
        {
            // リストの選択に応じて、メニュー階層コンボを更新
            // リストのクリア
            if (this.MenuLevelSelectBox.Items.Count != 0)
            {   // 表示アイテム有り
                this.MenuLevelSelectBox.Items.Clear();
            }
            this.MenuLevelSelectBox.Items.Add(Properties.HSMenuMsgResource.MAINMENU);
            // メインメニューの選択項目インデックス
            if (this.checkedMenuItemList.SelectedIndex == -1)
            {   // メインメニューなし
                this.MenuLevelSelectBox.SelectedIndex = 0;
                return;
            }

            int iSelectNum = this.checkedMenuItemList.SelectedIndex;
            int iLevel = m_csSelectNo;
            if (iLevel == -1)
            {   // 未選択
                iLevel++;
            }
            // iLevelが1以上のときItems.Addする
            for (int iLp = 0; iLp < iLevel; iLp++)
            {   // レベル数分
                this.MenuLevelSelectBox.Items.Add(Properties.HSMenuMsgResource.SUBMENU + "(" + Properties.HSMenuMsgResource.LEVEL + (iLp + 2).ToString() + ")");
            }
            if (iLevel + 1 != m_csEditorCtl.GetMenuLevelCount())
            {
                // 各階層のどの項目から選択されてきたかを記憶
                // メイン（ファイル）‐レベル2（プロジェクト）：
                m_csIndexMngTbl[m_csSelectNo] = this.checkedMenuItemList.SelectedIndex;
                this.MenuLevelSelectBox.Items.Add(Properties.HSMenuMsgResource.SUBMENU + "(" + Properties.HSMenuMsgResource.LEVEL + (iLevel + 2).ToString() + ")");
            }
            // 項目の上位を選択済みにする
            if (m_csSelectNo != -1)
            {   // 選択あり
                this.MenuLevelSelectBox.SelectedIndex = m_csSelectNo;
            }
            else
            {   // 選択無し
                this.MenuLevelSelectBox.SelectedIndex = 0;
            }
        }

        /// <summary>
        /// <para>method outline</para>
        /// <para>チェックが変更された時に発生するイベント</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>checkedMenuItemList_SelectedIndexChangedEvent(sender, e)</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void checkedMenuItemList_ItemCheck(object sender, ItemCheckEventArgs e)
        {
            int iIndex = checkedMenuItemList.SelectedIndex;
            if (iIndex == -1)
            {// 未選択
                return;
            }

            HySViewerMenuItem csMenuItem = null;

            if (m_csSelectNo == 0)
            {   // メイン選択
                csMenuItem = m_csEditorCtl.GetMainMenuItem(iIndex);
            }
            else
            {   // 上記以外
                ArrayList csList = m_csEditorCtl.GetMenuItemList((long)this.checkedMenuItemList.SelectedIndex, (long)this.MenuLevelSelectBox.SelectedIndex, m_csIndexMngTbl);
                if (csList.Count >= iIndex)
                {   // リスト数が選択箇所より大
                    csMenuItem = (HySViewerMenuItem)csList[iIndex];
                }
            }

            if (csMenuItem == null)
            {// 編集情報無し
                return;
            }
            if (e.NewValue == CheckState.Checked)
            {   // チェック有り
                csMenuItem.SetMenuDisp(true);
            }
            else
            {   // チェックなし
                csMenuItem.SetMenuDisp(false);
            }
        }

        /// <summary>
        /// <para>method outline</para>
        /// <para>「終了」ボタンが押下された時に発生するイベント</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>Endbutton_Click(sender, e)</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void Endbutton_Click(object sender, EventArgs e)
        {
            Close();
        }

        /// <summary>
        /// <para>method outline</para>
        /// <para>「読込み」ボタンが押下された時に発生するイベント</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>Endbutton_Click(sender, e)</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void ReadButton_Click(object sender, EventArgs e)
        {
            string sSource = null;
            string sDest = null;
            try
            {
                if (openFileDialog.ShowDialog(this) == DialogResult.OK)
                {   // ファイル読込みダイアログOKボタン
                    m_csXmlFileName = new HySString(openFileDialog.FileName);
                    // メニュー情報の生成
                    m_csEditorCtl.CheckMenu(m_csXmlFileName);
                    m_csEditorCtl.GenerateMenu();
                    // レベル１選択セット
                    m_csSelectNo = 0;
                    // 項目一覧の初期表示
                    this.ShowMenuItemList();
                    if (this.checkedMenuItemList.Items.Count > 0)
                    {   // 編集項目有り
                        sSource = m_csXmlFileName.ToString();
                        sDest = sSource + ".Back";
                        m_csBackUpXmlFileName = new HySString(sDest);
                        if (System.IO.File.Exists(sDest) == true)
                        {   // バックアップファイル有り
                            System.IO.File.Delete(sDest);
                        }
                        System.IO.File.Copy(sSource, sDest);
                    }
                }
            }
            catch
            {
            }
        }

        /// <summary>
        /// <para>method outline</para>
        /// <para>「全て元に戻す」ボタンが押下された時に発生するイベント</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>Endbutton_Click(sender, e)</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void PreDataLoadbutton_Click(object sender, EventArgs e)
        {
            try
            {
                // メニューレベルチェック
                m_csEditorCtl.CheckMenu(m_csBackUpXmlFileName);
                // メニュー作成
                m_csEditorCtl.GenerateMenu();
                // レベル１選択セット
                m_csSelectNo = 0;
                // 項目一覧の初期表示
                this.ShowMenuItemList();
            }
            catch
            {
            }
        }

        /// <summary><para>method outline</para>
        /// <para>ヘルプリンクイベント</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>Help_Button_Click(sender, e)</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void HelpJump_button_Click(object sender, EventArgs e)
        {
            // ヘルプ画面の表示
            HySShowHelpNavigator.ShowHelpNavigator(HySShowHelpNavigator.NAV_MSG_TOOL_0002, null);
        }

    }
}
