﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;
using CommonMP.HYSSOP.OptionImpl.HSViewer.DotNetViewer;

namespace CommonMP.HYSSOP.OptionImpl.HSMenuEditor
{
    /// <summary><para>class outline:</para>
    /// <para>メニュー項目追加・編集画面</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.2.0][2011/10/25][新規作成]</para>
    /// </remarks>
    public partial class HSMenuItemEditForm : Form
    {
        /// <summary>ＯＫボタン押下有無</summary>
        protected bool m_bButtonOK = false;

        /// <summary><para>method outline:</para>
        /// <para>メニュー情報の設定・取得する</para>
        /// </summary>
        /// <value>メニュー情報</value>
        /// <example><para>usage:</para>
        /// <para>HySViewerMenuItem csMenuItem = csEditForm.m_csMenuItem()</para>
        /// </example>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySViewerMenuItem m_csMenuItem { get; set; }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>デフォルトコンストラクタ</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>new HSMenuItemEditForm( )</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HSMenuItemEditForm()
        {
            InitializeComponent();
        }

        /// <summary>
        /// <para>method outline</para>
        /// <para>「メニューの追加と編集」画面が表示された時に発生するイベント</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>HSMenuItemEditForm_Load(sender, e)</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void HSMenuItemEditForm_Load(object sender, EventArgs e)
        {
            if (m_csMenuItem != null)
            {   // メニューアイテムデータ有効
                if ((object)m_csMenuItem.GetMenuText() != null && m_csMenuItem.GetMenuText().ToString() != string.Empty)
                {   // メニューテキスト有効
                    this.MenuName_TextBox.Text = m_csMenuItem.GetMenuText().ToString();
                    this.CallBackNo_TextBox.Text = m_csMenuItem.GetCallBackNo().ToString();
                    this.Kind_TextBox.Text = m_csMenuItem.GetKindString().ToString();
                }
                else
                {
                    this.MenuName_TextBox.Text = "";
                    this.CallBackNo_TextBox.Text = "";
                    this.Kind_TextBox.Text = "";
                }
            }
            else
            {   // メニューアイテムデータ無し
                return;
            }
        }

        /// <summary>
        /// <para>method outline</para>
        /// <para>「設定」ボタンが押された時に発生するイベント</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>Setting_Button_Click(sender, e)</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void Setting_Button_Click(object sender, EventArgs e)
        {
            long lCallBackNo = 0;

            m_bButtonOK = true;

            if (HSInputStr.InputWordCheck_Name(this.MenuName_TextBox.Text) == true)
            {   // メニュー入力OK
                m_csMenuItem.SetMenuText(new HySString(this.MenuName_TextBox.Text));
                if (m_csMenuItem.GetMenuText().ToString().Equals(HSMenuEditorDefine.TEXT_SEPARATOR) == true)
                {   // セパレータ
                    m_csMenuItem.SetSeparator(true);
                }
            }
            else
            {   // 入力異常
                System.Windows.Forms.MessageBox.Show(this, Properties.HSMenuMsgResource.MENUTEXT_ERR, Properties.HSMenuMsgResource.CAPTION, MessageBoxButtons.OK, MessageBoxIcon.Error);
                m_bButtonOK = false;
            }

            if (HSInputStr.InputWordCheck_Number(this.CallBackNo_TextBox.Text) == true)
            {   // コールバック入力OK
                m_csMenuItem.SetCallBackFlg(false);
                if (long.TryParse(this.CallBackNo_TextBox.Text, out lCallBackNo) == true)
                {   // 整数変換有効
                    m_csMenuItem.SetCallBackNo(lCallBackNo);
                    if (lCallBackNo != -1)
                    {   // コールバック番号がー１以外
                        m_csMenuItem.SetCallBackFlg(true);
                    }
                }
                else
                {   // 整数変換無効
                    m_csMenuItem.SetCallBackNo(-1);
                }
            }
            else
            {   // 入力異常
                System.Windows.Forms.MessageBox.Show(this, Properties.HSMenuMsgResource.CALLBACKNO_ERR, Properties.HSMenuMsgResource.CAPTION, MessageBoxButtons.OK, MessageBoxIcon.Error);
                m_bButtonOK = false;
            }

            if (HSInputStr.InputWordCheck(this.Kind_TextBox.Text) == true)
            {   // 識別子入力OK
                m_csMenuItem.SetKindString(new HySString(this.Kind_TextBox.Text));
            }
            else
            {   // 入力異常
                System.Windows.Forms.MessageBox.Show(this, Properties.HSMenuMsgResource.BUSIPROCID_ERR, Properties.HSMenuMsgResource.CAPTION, MessageBoxButtons.OK, MessageBoxIcon.Error);
                m_bButtonOK = false;
            }

            if (m_bButtonOK == true)
            {   // 入力正常
                Close();
            }

        }

        /// <summary>
        /// <para>method outline</para>
        /// <para>「ｷｬﾝｾﾙ」ボタンが押された時に発生するイベント</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>Cancel_Button_Click(sender, e)</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void Cancel_Button_Click(object sender, EventArgs e)
        {
            m_bButtonOK = false;
        }

        /// <summary>
        /// <para>method outline</para>
        /// <para>「OK」ボタンが押下されたか否かを返す</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>CIsButtonOK( )</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public bool IsButtonOK()
        {
            return m_bButtonOK;
        }

        /// <summary><para>method outline</para>
        /// <para>ヘルプリンクイベント</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>Help_Button_Click(sender, e)</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void HelpJump_button_Click(object sender, EventArgs e)
        {
            // ヘルプ画面の表示
            HySShowHelpNavigator.ShowHelpNavigator(HySShowHelpNavigator.NAV_MSG_TOOL_0003, null);
        }
    }
}
