﻿// <summary>ソースコード：ツール削除処理プロセスクラス</summary>
// <author>CommonMP</author>
using System;
using System.Collections.Generic;
using System.Windows.Forms;
using System.IO;

using CommonMP.HYSSOP.CoreImpl.HSTools;
using CommonMP.HYSSOP.CoreImpl.HSData;

namespace CommonMP.HYSSOP.OptionImpl.HSToolDelete
{
    /// <summary><para>class outline:</para>
    /// <para>ツール削除処理プロセス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.3.0][2012/12/10][新規作成]</para>
    /// </remarks>
    public class HSToolDeleteProgram
    {

        /// <summary>ツール削除確認画面タイトル</summary>
        static private string TOOLDELETE_DLG_TITLE = Properties.HSToolDeleteResource.MSG_TITLE_TOOLDELETE_DLG;
        /// <summary>ツール削除確認メッセージ「正常終了」 </summary>
        static private string MSG_INFO_COMPLETE_DELETE_TOOL = Properties.HSToolDeleteResource.MSG_INFO_COMPLETE_DELETE_TOOL;
        /// <summary>ツール削除確認メッセージ「異常終了」 </summary>
        static private string MSG_WARNING_DELETE_TOOL = Properties.HSToolDeleteResource.MSG_WARNING_DELETE_TOOL;
        /// <summary>ツール削除確認メッセージ「異常終了（例外発生）」 </summary>
        static private string MSG_ERR_DELETE_TOOL = Properties.HSToolDeleteResource.MSG_ERR_DELETE_TOOL;

        /// <summary> 削除管理コード長 </summary>
        static private readonly int TOOL_KIND_LEN = 3;
        /// <summary> 削除管理コード　ファイル[F] </summary>
        static private readonly string TOOL_KIND_FILE = "[F]";
        /// <summary> 削除管理コード　ディレクトリ[D] </summary>
        static private readonly string TOOL_KIND_DIR = "[D]";

        /// <summary><para>class outline:</para>
        /// <para>アプリケーションのメイン エントリ ポイントです。</para>
        /// </summary>
        /// <remarks><para>history:</para>
        /// <para>[CommonMP][ver 1.3.0][2012/12/10][新規作成]</para>
        /// </remarks>
        [STAThread]
        static void Main()
        {
            try
            {
                // 地域情報をTheadにセット
                System.Threading.Thread.CurrentThread.CurrentUICulture = System.Globalization.CultureInfo.CurrentCulture;

                HSToolDeleteProgram csToolDeleteProgram = new HSToolDeleteProgram();

                // 初期設定
                csToolDeleteProgram.Initialize();

                // ツール削除処理
                csToolDeleteProgram.DeleteTool();
                // プロセス終了
            }
            catch
            {
                // Do nothing
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>初期設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>Initialize()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void Initialize()
        {
            // 地域情報の設定が有効とならない時点で設定されるため、再設定する。
            // 通常はＯＳの言語で設定されるため、本設定は必要無くても問題ない。
            TOOLDELETE_DLG_TITLE = Properties.HSToolDeleteResource.MSG_TITLE_TOOLDELETE_DLG;
            MSG_INFO_COMPLETE_DELETE_TOOL = Properties.HSToolDeleteResource.MSG_INFO_COMPLETE_DELETE_TOOL;
            MSG_WARNING_DELETE_TOOL = Properties.HSToolDeleteResource.MSG_WARNING_DELETE_TOOL;
            MSG_ERR_DELETE_TOOL = Properties.HSToolDeleteResource.MSG_ERR_DELETE_TOOL;
        }

        /// <summary><para>method outline:</para>
        /// <para>ツール削除処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>DeleteTool()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void DeleteTool()
        {
            bool bChkFlg = false;
            HySString csReadInfo = new HySString("");
            HySEnvInf csEnvInf = new HySEnvInf(new HySString("CommonMP.cfg"));
            List<DirectoryInfo> csDirList = new List<DirectoryInfo>();
            // >>> 階層無しのため、処理コメント
            //Hashtable csDirInfo = new Hashtable();
            // <<<

            try
            {
                csEnvInf.Initialize();
                // 削除情報ファイルの存在確認
                HySString csHomeDir = HySEnvInf.GetHomeDirectory();
                HySString csTargetDir = csHomeDir + "\\temp\\ToolDeleteInfo.txt";
                HySFile csFile = new HySFile(csTargetDir);
                bool bRtn = csFile.Exist();
                if (bRtn == true)
                {
                    //オープン
                    if (csFile.Open(HySFile.OPEN_MODE.OPEN, HySFile.READ_WRITE_MODE.READ, HySFile.DIRECTORY_MODE.NOT_MK_DIR) != 0)
                    {
                        // ファイルが開けない
                       // ver1.5 エラートレース日本語対応
                        HySLog.LogOut(HySLog.ONLINE, "HSToolDeleteProgram", "DeleteTool", 
                            Properties.HSToolDeleteResource.STATEMENT_FOPEN_NG + csTargetDir);
                       // HySLog.LogOut(HySLog.ONLINE, "HSToolDeleteProgram", "DeleteTool", "ファイルオープン処理失敗:" + csTargetDir);
                        MessageBox.Show(MSG_ERR_DELETE_TOOL, TOOLDELETE_DLG_TITLE, MessageBoxButtons.OK, MessageBoxIcon.Error);
                    }
                    else
                    {
                        // 削除対象ファイルの参照
                        while (csFile.ReadText(ref csReadInfo) != 0)
                        {
                            long lRtn = 0;
                            //csReadInfo = csHomeDir + "\\" + csReadInfo;
                            if (csReadInfo.ToString().StartsWith(TOOL_KIND_FILE) == true)
                            {// 個別ファイル削除
                                // 処理情報削除
                                csReadInfo.Remove(0, TOOL_KIND_LEN);
                                HySFile csDelFile = new HySFile(csReadInfo);
                                if (csDelFile.Exist() == true)
                                {
                                    // 削除対象が存在する場合のみ削除処理を実施する
                                    lRtn = csDelFile.Delete();

                                    // >>> 階層無しのため、処理コメント
                                    //// アイコンとマニュアルの場合は、上位フォルダ情報を取得しておく
                                    //bool IcoResult = csReadInfo.ToString().EndsWith("ico");
                                    //bool PdfResult = csReadInfo.ToString().EndsWith("pdf");
                                    //if (IcoResult == true || PdfResult == true)
                                    //{
                                    //    DirectoryInfo csInfo = Directory.GetParent(csReadInfo.ToString());
                                    //    // 重複取得を避ける
                                    //    if (csDirInfo[csInfo.ToString()] == null)
                                    //    {
                                    //        csDirList.Add(csInfo);
                                    //        csDirInfo.Add(csInfo.ToString(), csInfo);
                                    //    }
                                    //}
                                    // <<<

                                    if (lRtn == -1)
                                    {
                                        // 削除異常時の処理 メッセージorログ?
                                       // ver1.5 エラートレース日本語対応
                                        HySLog.LogOut(HySLog.ONLINE, "HSToolDeleteProgram", "DeleteTool", 
                                            Properties.HSToolDeleteResource.STATEMENT_DELETE_NG );
                                       // HySLog.LogOut(HySLog.ONLINE, "HSToolDeleteProgram", "DeleteTool", "削除処理失敗");
                                        bChkFlg = true;
                                    }
                                }
                                else
                                {
                                    if (Directory.Exists(csReadInfo.ToString()) != true)
                                    {// ディレクトリの場合エラー無し
                                        // 削除対象が存在しない場合
                                       // ver1.5 エラートレース日本語対応
                                        HySLog.LogOut(HySLog.ONLINE, "HSToolDeleteProgram", "DeleteTool", 
                                            Properties.HSToolDeleteResource.STATEMENT_DELETED_NO + "[" + csReadInfo.ToString() + "]");
                                       // HySLog.LogOut(HySLog.ONLINE, "HSToolDeleteProgram", "DeleteTool", "削除対象が見つかりません[" + csReadInfo.ToString() + "]");
                                        bChkFlg = true;
                                    }
                                }
                                csDelFile = null;
                            }
                            else if (csReadInfo.ToString().StartsWith(TOOL_KIND_DIR) == true)
                            {// ディレクトリ削除
                                // 処理情報削除
                                csReadInfo.Remove(0, TOOL_KIND_LEN);
                                if (Directory.Exists(csReadInfo.ToString()) == true)
                                {// プロジェクト情報削除
                                    try
                                    {
                                        Directory.Delete(csReadInfo.ToString(), true);
                                    }
                                    catch
                                    {
                                        // 削除異常時の処理 メッセージorログ?
                                       // ver1.5 エラートレース日本語対応
                                        HySLog.LogOut(HySLog.ONLINE, "HSToolDeleteProgram", "DeleteTool", 
                                            Properties.HSToolDeleteResource.STATEMENT_DELETE_NG );
                                       // HySLog.LogOut(HySLog.ONLINE, "HSToolDeleteProgram", "DeleteTool", "削除処理失敗");
                                        bChkFlg = true;
                                    }
                                }
                                else
                                {
                                    // 削除対象が存在しない場合
                                   // ver1.5 エラートレース日本語対応
                                    HySLog.LogOut(HySLog.ONLINE, "HSToolDeleteProgram", "DeleteTool",
                                        Properties.HSToolDeleteResource.STATEMENT_DELETED_NO + "[" + csReadInfo.ToString() + "]");
                                    // HySLog.LogOut(HySLog.ONLINE, "HSToolDeleteProgram", "DeleteTool", "削除対象が見つかりません[" + csReadInfo.ToString() + "]");
                                    bChkFlg = true;
                                }
                            }
                            else
                            {
                                // 削除対象が存在しない場合
                               // ver1.5 エラートレース日本語対応
                                HySLog.LogOut(HySLog.ONLINE, "HSToolDeleteProgram", "DeleteTool",
                                    Properties.HSToolDeleteResource.STATEMENT_DEL_INFO_NG + "[" + csReadInfo.ToString() + "]");
                                // HySLog.LogOut(HySLog.ONLINE, "HSToolDeleteProgram", "DeleteTool", "管理情報が異常[" + csReadInfo.ToString() + "]");
                                bChkFlg = true;
                            }
                        }
                        // クローズ
                        csFile.Close();

                        // >>> 階層無しのため、処理コメント
                        //// アイコンとマニュアルの場合は上位フォルダの削除実施
                        //for (int iLp = 0; iLp < csDirList.Count; iLp++)
                        //{
                        //    DirectoryInfo csDelInfo = csDirList[iLp];
                        //    // 上位フォルダが標準ディレクトリであればフォルダは削除しない
                        //    bool IconDirChk = csDelInfo.FullName.EndsWith(@"\ToolIcon");
                        //    bool PdfDirChk = csDelInfo.FullName.EndsWith(@"\ToolManual");
                        //    if (IconDirChk == true || PdfDirChk == true)
                        //    {
                        //        continue;
                        //    }
                        //    // 万が一ディレクトリが空でない場合でも削除を行う
                        //    csDelInfo.Delete(true);
                        //}
                        // <<<

                        // 削除情報ファイル削除
                        csFile.Delete();
                        if (bChkFlg == true)
                        {
                            // 異常メッセージ表示
                            MessageBox.Show(MSG_WARNING_DELETE_TOOL, TOOLDELETE_DLG_TITLE, MessageBoxButtons.OK, MessageBoxIcon.Warning);
                        }
                        else
                        {
                            // 完了メッセージ表示
                            MessageBox.Show(MSG_INFO_COMPLETE_DELETE_TOOL, TOOLDELETE_DLG_TITLE, MessageBoxButtons.OK, MessageBoxIcon.Information);
                        }
                    }
                }
                else
                {
                    // 存在しない場合は何もしない(通常のCommonMP終了時等)
                }
            }
            catch (Exception ex)
            {
                // ログ出力/メッセージ表示
               // ver1.5 エラートレース日本語対応
                HySLog.LogOut(HySLog.ONLINE, "HSToolDeleteProgram", "DeleteTool", 
                    Properties.HSToolDeleteResource.STATEMENT_EXCEPT_DEL_PROC + Environment.NewLine + ex.ToString());
               // HySLog.LogOut(HySLog.ONLINE, "HSToolDeleteProgram", "DeleteTool", "ツール削除処理で例外発生:" + Environment.NewLine + ex.ToString());
                MessageBox.Show(MSG_ERR_DELETE_TOOL, TOOLDELETE_DLG_TITLE, MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
            HySEnvInf.Terminate();
            csEnvInf = null;
        }
    }
}
