﻿// <summary>ソースコード：ツール情報クラス</summary>
// <author>CommonMP</author>

using System.Collections.Generic;

using CommonMP.HYSSOP.Interface;
using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;
using CommonMP.HYSSOP.CoreImpl.HSData;

namespace CommonMP.HYSSOP.OptionImpl.HSToolDeleteViewer
{
    /// <summary><para>class outline:</para>
    /// <para>ツール情報クラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.3.0][2012/12/10][新規作成]</para>
    /// </remarks>
    public class HSToolInfoData : HySRoot
    {

        /// <summary>ＤＬＬ名称</summary>
        private HySString m_csDllName = new HySString("");

        /// <summary>ツール名称</summary>
        protected HySString m_csToolName = new HySString("");

        /// <summary>パッケージ名称</summary>
        private HySString m_csPackageName = new HySString("");

        /// <summary>ファイルパス名</summary>
        private List<HySString> m_csFileNameList = new List<HySString>();

        /// <summary><para>method outline:</para>
        /// <para>デフォルトコンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>HSToolInfoData csData = new HSToolInfoData()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HSToolInfoData()
        {

        }

        /// <summary><para>method outline:</para>
        /// <para>ツール名称取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>HySString csName = GetToolName()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>ツール名称</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySString GetToolName()
        {
            return m_csToolName;
        }

        /// <summary><para>method outline:</para>
        /// <para>ツール名称設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetToolName( sToolName )</para>
        /// </example>
        /// <param name="sToolName">ツール名称</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetToolName(string sToolName)
        {
            m_csToolName = new HySString(sToolName);
        }

        /// <summary><para>method outline:</para>
        /// <para>ＤＬＬ名称取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>HySString csName = GetDllName()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>ＤＬＬ名称</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySString GetDllName()
        {
            return m_csDllName;
        }

        /// <summary><para>method outline:</para>
        /// <para>ＤＬＬ名称設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetDllName( sDllName )</para>
        /// </example>
        /// <param name="sDllName">ＤＬＬ名称</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetDllName(string sDllName)
        {
            m_csDllName = new HySString(sDllName);
        }

        /// <summary><para>method outline:</para>
        /// <para>パッケージ名称取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>HySString csName = GetPackageName()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>パッケージ名称</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySString GetPackageName()
        {
            return m_csPackageName;
        }

        /// <summary><para>method outline:</para>
        /// <para>パッケージ名称設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetPackageName( sPackageName )</para>
        /// </example>
        /// <param name="sPackageName">パッケージ名称</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetPackageName(string sPackageName)
        {
            m_csPackageName = new HySString(sPackageName);
        }

        /// <summary><para>method outline:</para>
        /// <para>ファイルパス名取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>var csList = GetFileNameList()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>ファイルパス名リスト</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public List<HySString> GetFileNameList()
        {
            return m_csFileNameList;
        }

        /// <summary><para>method outline:</para>
        /// <para>ファイルパス名設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>AddFileNameList( sFileName )</para>
        /// </example>
        /// <param name="sFileName">ファイルパス名</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void AddFileNameList(string sFileName)
        {
            m_csFileNameList.Add(new HySString(sFileName));
        }
    }
}